/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.wheel.FakePlayerCreateContext;
import org.jetbrains.annotations.Nullable;

public class GenericUtils {
    public static final ThreadLocal<Consumer<EntityPlayerMPFake>> FAKE_PLAYER_SPAWNING = new ThreadLocal();
    public static final ThreadLocal<Consumer<EntityPlayerMPFake>> INTERNAL_FAKE_PLAYER_SPAWNING = new ThreadLocal();
    public static final int CURRENT_DATA_VERSION = GenericUtils.getNbtDataVersion();

    private GenericUtils() {
    }

    public static Optional<class_1297> getEntity(MinecraftServer server, UUID uuid) {
        for (class_3218 world : server.method_3738()) {
            class_1297 entity = world.method_66347(uuid);
            if (entity == null) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    public static Optional<class_3222> getPlayer(MinecraftServer server, UUID uuid) {
        return Optional.ofNullable(server.method_3760().method_14602(uuid));
    }

    public static Optional<class_3222> getPlayer(MinecraftServer server, String name) {
        return Optional.ofNullable(server.method_3760().method_14566(name));
    }

    public static Optional<class_3222> getPlayer(MinecraftServer server, GameProfile gameProfile) {
        return GenericUtils.getPlayer(server, gameProfile.getName());
    }

    public static class_2960 getId(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    public static class_2960 getId(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    public static Optional<class_2960> getId(class_1937 world, class_1887 enchantment) {
        class_6880 entry = class_6880.method_40223((Object)enchantment);
        entry.method_40230().map(class_5321::method_29177);
        return GenericUtils.getId(world.method_30349(), enchantment);
    }

    public static Optional<class_2960> getId(MinecraftServer server, class_1887 enchantment) {
        return GenericUtils.getId((class_5455)server.method_30611(), enchantment);
    }

    public static Optional<class_2960> getId(class_5455 registryManager, class_1887 enchantment) {
        Optional optional = registryManager.method_46759(class_7924.field_41265);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        class_2378 enchantments = (class_2378)optional.get();
        return Optional.ofNullable(enchantments.method_10221((Object)enchantment));
    }

    public static String getIdAsString(class_1792 item) {
        return GenericUtils.getId(item).toString();
    }

    public static String getIdAsString(class_2248 block) {
        return GenericUtils.getId(block).toString();
    }

    public static class_1792 getItem(String id) {
        return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)id));
    }

    public static class_2248 getBlock(String id) {
        return (class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)id));
    }

    public static class_5321<class_1937> getWorld(String worldId) {
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)worldId));
    }

    public static void createFakePlayer(String username, MinecraftServer server, FakePlayerCreateContext context) {
        GenericUtils.createFakePlayer(username, server, context.pos(), context.yaw(), context.pitch(), context.dimension(), context.gamemode(), context.flying(), context.consumer());
    }

    public static Optional<UUID> uuidFromString(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(UUID.fromString(str));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFakePlayer(String username, MinecraftServer server, class_243 pos, double yaw, double pitch, class_5321<class_1937> dimension, class_1934 gamemode, boolean flying, Consumer<EntityPlayerMPFake> consumer) {
        try {
            FAKE_PLAYER_SPAWNING.set(consumer);
            EntityPlayerMPFake.createFake((String)username, (MinecraftServer)server, (class_243)pos, (double)yaw, (double)pitch, dimension, (class_1934)gamemode, (boolean)flying);
        }
        finally {
            FAKE_PLAYER_SPAWNING.remove();
        }
    }

    public static String getExceptionString(Throwable throwable) {
        String name = throwable.getClass().getSimpleName();
        String message = throwable.getMessage();
        return message == null ? name : name + ": " + message;
    }

    public static int getNbtDataVersion() {
        return class_155.method_16673().comp_4026().comp_4038();
    }

    public static void pass(Object ... ignored) {
    }
}

