/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.logger;

import carpet.logging.HUDLogger;
import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import java.lang.reflect.Field;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.logger.FunctionLogger;
import org.carpetorgaddition.logger.LoggerConfig;
import org.carpetorgaddition.logger.LoggerType;
import org.carpetorgaddition.logger.NetworkPacketLogger;
import org.carpetorgaddition.rule.Hidden;

public class LoggerRegister {
    @LoggerConfig(name="wanderingTraderSpawnCountdown", type=LoggerType.HUD)
    public static boolean wanderingTrader = false;
    @LoggerConfig(name="fishing", type=LoggerType.FUNCTION)
    public static boolean fishing = false;
    @LoggerConfig(name="beaconRange", type=LoggerType.NETWORK)
    public static boolean beaconRange = false;
    @LoggerConfig(name="villager", type=LoggerType.NETWORK, options={"bed", "jobSitePos", "potentialJobSite", "\"bed,jobSitePos\"", "\"jobSitePos,potentialJobSite\"", "all"})
    public static boolean villager = false;
    @LoggerConfig(name="obsidian", type=LoggerType.FUNCTION)
    public static boolean obsidian = false;
    @Hidden
    @LoggerConfig(name="fakePlayerPath", type=LoggerType.NETWORK)
    public static boolean fakePlayerPath = false;

    public static void register() {
        for (Field field : LoggerRegister.class.getFields()) {
            LoggerConfig annotation = field.getAnnotation(LoggerConfig.class);
            if (annotation == null || !CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION && field.isAnnotationPresent(Hidden.class)) continue;
            String name = annotation.name();
            Logger logger = LoggerRegister.createLogger(field, annotation, name);
            LoggerRegistry.registerLogger((String)name, (Logger)logger);
        }
    }

    private static Logger createLogger(Field field, LoggerConfig annotation, String name) {
        String defaultOption = annotation.defaultOption().isEmpty() ? null : annotation.defaultOption();
        String[] options = annotation.options();
        boolean strictOptions = annotation.strictOptions();
        return switch (annotation.type()) {
            default -> throw new MatchException(null, null);
            case LoggerType.STANDARD -> new Logger(field, name, defaultOption, options, strictOptions);
            case LoggerType.HUD -> new HUDLogger(field, name, defaultOption, options, strictOptions);
            case LoggerType.NETWORK -> new NetworkPacketLogger(field, name, defaultOption, options, strictOptions);
            case LoggerType.FUNCTION -> new FunctionLogger(field, name, defaultOption, options, strictOptions);
        };
    }
}

