/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.wheel.ItemStackPredicate;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.inventory.AutoGrowInventory;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class CraftingTableCraftAction
extends AbstractPlayerAction {
    private final ItemStackPredicate[] predicates = new ItemStackPredicate[9];

    public CraftingTableCraftAction(EntityPlayerMPFake fakePlayer, ItemStackPredicate[] predicates) {
        super(fakePlayer);
        if (predicates.length != 9) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(predicates, 0, this.predicates, 0, this.predicates.length);
    }

    @Override
    protected void tick() {
        class_1703 class_17032 = this.getFakePlayer().field_7512;
        if (class_17032 instanceof class_1714) {
            class_1714 craftingScreenHandler = (class_1714)class_17032;
            AutoGrowInventory inventory = new AutoGrowInventory();
            this.craftingTableCraft(inventory, craftingScreenHandler);
            for (class_1799 itemStack : inventory) {
                this.getFakePlayer().method_7329(itemStack, false, true);
            }
        }
    }

    private void craftingTableCraft(AutoGrowInventory inventory, class_1714 craftingScreenHandler) {
        int successCount;
        block12: {
            block13: {
                int craftCount = 0;
                int loopCount = 0;
                do {
                    if (++loopCount > 1200) {
                        throw new InfiniteLoopException();
                    }
                    successCount = 0;
                    block1: for (int index = 1; index <= 9; ++index) {
                        ItemStackPredicate predicate = this.predicates[index - 1];
                        class_1735 slot = craftingScreenHandler.method_7611(index);
                        if (slot.method_7681()) {
                            class_1799 itemStack = slot.method_7677();
                            if (predicate.test(itemStack)) {
                                ++successCount;
                                continue;
                            }
                            FakePlayerUtils.throwItem((class_1703)craftingScreenHandler, index, this.getFakePlayer());
                            continue;
                        }
                        if (predicate.isEmpty()) {
                            ++successCount;
                            continue;
                        }
                        int size = craftingScreenHandler.field_7761.size();
                        for (int inventoryIndex = 10; inventoryIndex < size; ++inventoryIndex) {
                            class_1799 contentItemStack;
                            class_1799 itemStack = craftingScreenHandler.method_7611(inventoryIndex).method_7677();
                            if (predicate.test(itemStack)) {
                                if (FakePlayerUtils.withKeepPickupAndMoveItemStack((class_1703)craftingScreenHandler, inventoryIndex, index, this.getFakePlayer())) {
                                    ++successCount;
                                    continue block1;
                                }
                            } else if (CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get().booleanValue() && InventoryUtils.isOperableSulkerBox(itemStack) && !(contentItemStack = InventoryUtils.pickItemFromShulkerBox(itemStack, predicate)).method_7960()) {
                                FakePlayerUtils.dropCursorStack((class_1703)craftingScreenHandler, this.getFakePlayer());
                                craftingScreenHandler.method_34254(contentItemStack);
                                FakePlayerUtils.pickupCursorStack((class_1703)craftingScreenHandler, index, this.getFakePlayer());
                                ++successCount;
                                continue block1;
                            }
                            if (index != 9 || inventoryIndex != size - 1) continue;
                            return;
                        }
                    }
                    if (successCount != 9) break block12;
                    if (!craftingScreenHandler.method_7611(0).method_7681()) break block13;
                    FakePlayerUtils.collectItem((class_1703)craftingScreenHandler, 0, inventory, this.getFakePlayer());
                } while (!FakePlayerUtils.shouldStop(++craftCount));
                return;
            }
            FakePlayerUtils.stopCraftAction(this.getFakePlayer().method_64396(), this.getFakePlayer());
            return;
        }
        if (successCount > 9) {
            throw new IllegalStateException(FetcherUtils.getPlayerName((class_1657)this.getFakePlayer()) + "\u627e\u5230\u6b63\u786e\u5408\u6210\u6750\u6599\u7684\u6b21\u6570\u4e3a" + successCount + "\uff0c\u6b63\u5e38\u4e0d\u5e94\u8be5\u8d85\u8fc79");
        }
    }

    @Override
    public ArrayList<class_2561> info() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        class_1799 craftOutput = ItemStackPredicate.getCraftOutput(this.predicates, 3, this.getFakePlayer());
        class_2561 itemText = craftOutput.method_7960() ? TextBuilder.translate("carpet.command.item.item", new Object[0]) : craftOutput.method_7909().method_63680();
        list.add(TextBuilder.translate("carpet.commands.playerAction.info.craft.result", this.getFakePlayer().method_5476(), itemText));
        this.addCraftRecipe(list, craftOutput);
        class_1703 class_17032 = this.getFakePlayer().field_7512;
        if (class_17032 instanceof class_1714) {
            class_1714 currentScreenHandler = (class_1714)class_17032;
            list.add(TextBuilder.translate("carpet.commands.playerAction.info.craft.state", this.getFakePlayer().method_5476()));
            this.addCraftGridState(currentScreenHandler, list);
        } else {
            list.add(TextBuilder.translate("carpet.commands.playerAction.info.craft.no_crafting_table", this.getFakePlayer().method_5476(), class_1802.field_8465.method_63680()));
        }
        return list;
    }

    private void addCraftRecipe(ArrayList<class_2561> list, class_1799 craftOutput) {
        list.add(TextBuilder.combineAll(TextProvider.INDENT_SYMBOL, this.predicates[0].getInitialUpperCase(), " ", this.predicates[1].getInitialUpperCase(), " ", this.predicates[2].getInitialUpperCase()));
        list.add(TextBuilder.combineAll(TextProvider.INDENT_SYMBOL, this.predicates[3].getInitialUpperCase(), " ", this.predicates[4].getInitialUpperCase(), " ", this.predicates[5].getInitialUpperCase(), craftOutput.method_7960() ? null : TextBuilder.combineAll(" -> ", FakePlayerUtils.getWithCountHoverText(craftOutput))));
        list.add(TextBuilder.combineAll(TextProvider.INDENT_SYMBOL, this.predicates[6].getInitialUpperCase(), " ", this.predicates[7].getInitialUpperCase(), " ", this.predicates[8].getInitialUpperCase()));
    }

    private void addCraftGridState(class_1714 currentScreenHandler, ArrayList<class_2561> list) {
        list.add(TextBuilder.combineAll("    ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(1).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(2).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(3).method_7677())));
        list.add(TextBuilder.combineAll("    ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(4).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(5).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(6).method_7677()), " -> ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(0).method_7677())));
        list.add(TextBuilder.combineAll("    ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(7).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(8).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(currentScreenHandler.method_7611(9).method_7677())));
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (int i = 0; i < this.predicates.length; ++i) {
            json.addProperty(String.valueOf(i), this.predicates[i].toString());
        }
        return json;
    }

    @Override
    public class_2561 getDisplayName() {
        return TextBuilder.translate("carpet.commands.playerAction.action.crafting_table_craft", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.CRAFTING_TABLE_CRAFT;
    }
}

