/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.schedule;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.Messenger;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.class_7417;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSerializer;
import org.carpetorgaddition.periodic.task.schedule.PlayerScheduleTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.jetbrains.annotations.Contract;

public class ReLoginTask
extends PlayerScheduleTask {
    public static final ThreadLocal<Boolean> HOME_POSITION = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> INTERNAL_HOME_POSITION = ThreadLocal.withInitial(() -> false);
    private final FakePlayerSerializer serializer;
    private int interval;
    private int remainingTick;
    private final MinecraftServer server;
    private final class_2168 source;
    private boolean stop = false;
    private int canSpawn = 2;

    public ReLoginTask(EntityPlayerMPFake fakePlayer, int interval, MinecraftServer server, class_2168 source) {
        this.serializer = new FakePlayerSerializer(fakePlayer);
        this.remainingTick = this.interval = interval;
        this.server = server;
        this.source = source;
    }

    @Override
    public void tick() {
        if (CarpetOrgAdditionSettings.fakePlayerSpawnMemoryLeakFix.get().booleanValue()) {
            class_3222 player = this.server.method_3760().method_14566(this.getPlayerName());
            if (player == null) {
                if (this.canSpawn == 0) {
                    this.loginPlayer();
                    this.canSpawn = 2;
                } else {
                    --this.canSpawn;
                }
            } else if (this.remainingTick <= 0) {
                this.remainingTick = this.interval;
                if (player instanceof EntityPlayerMPFake) {
                    EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)player;
                    if (fakePlayer.method_23318() < (double)(FetcherUtils.getWorld((class_3222)fakePlayer).method_31607() - 64)) {
                        this.stop();
                    }
                    ReLoginTask.logoutPlayer(fakePlayer);
                }
            } else {
                --this.remainingTick;
            }
        } else {
            Runnable function = () -> {
                MessageUtils.sendErrorMessage(this.source, "carpet.commands.playerManager.schedule.relogin.rule.disable", new Object[0]);
                class_3222 player = this.server.method_3760().method_14566(this.getPlayerName());
                if (player == null) {
                    this.loginPlayer();
                }
            };
            throw new TaskExecutionException(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logoutPlayer(EntityPlayerMPFake fakePlayer) {
        class_2588 text;
        class_2561 reason = Messenger.s((String)"Killed");
        if (fakePlayer.method_5854() instanceof class_1657) {
            fakePlayer.method_5848();
        }
        for (class_1297 passenger : fakePlayer.method_5736()) {
            if (!(passenger instanceof class_1657)) continue;
            passenger.method_5848();
        }
        class_7417 content = reason.method_10851();
        if (content instanceof class_2588 && (text = (class_2588)content).method_11022().equals("multiplayer.disconnect.duplicate_login")) {
            try {
                CarpetOrgAdditionSettings.hiddenLoginMessages.setExternal(true);
                fakePlayer.field_13987.method_10839(new class_9812(reason));
            }
            finally {
                CarpetOrgAdditionSettings.hiddenLoginMessages.setExternal(false);
            }
            return;
        }
        MinecraftServer server = FetcherUtils.getServer((class_3222)fakePlayer);
        server.method_63588((Runnable)new class_3738(server.method_3780(), () -> {
            try {
                CarpetOrgAdditionSettings.hiddenLoginMessages.setExternal(true);
                if (fakePlayer.method_31481()) {
                    return;
                }
                fakePlayer.field_13987.method_10839(new class_9812(reason));
            }
            finally {
                CarpetOrgAdditionSettings.hiddenLoginMessages.setExternal(false);
            }
        }));
    }

    @Override
    public boolean stopped() {
        return this.stop;
    }

    @Override
    public String getLogName() {
        return this.getPlayerName() + "\u5468\u671f\u6027\u91cd\u65b0\u4e0a\u7ebf";
    }

    @Override
    @Contract(pure=true)
    public String getPlayerName() {
        return this.serializer.getFakePlayerName();
    }

    @Override
    public void onCancel(CommandContext<class_2168> context) {
        this.markRemove();
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.relogin.cancel", this.getPlayerName());
        class_3222 player = this.server.method_3760().method_14566(this.getPlayerName());
        if (player == null) {
            this.loginPlayer();
        }
    }

    @Override
    public void sendEachMessage(class_2168 source) {
        MessageUtils.sendMessage(source, "carpet.commands.playerManager.schedule.relogin", this.getPlayerName(), this.interval);
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.remainingTick = interval;
    }

    public void stop() {
        this.stop = true;
    }

    private void loginPlayer() {
        try {
            CarpetOrgAdditionSettings.hiddenLoginMessages.setExternal(true);
            try {
                HOME_POSITION.set(true);
                this.serializer.spawn(this.server);
            }
            finally {
                HOME_POSITION.set(false);
            }
        }
        catch (CommandSyntaxException e) {
            CommandUtils.handlingException(e, this.source);
            this.stop();
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.warn("Fake player encounter unexpected errors while logging in", (Throwable)e);
            this.stop();
        }
        finally {
            CarpetOrgAdditionSettings.hiddenLoginMessages.setExternal(false);
        }
    }
}

