/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.action.StopAction;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.inventory.AbstractCustomSizeInventory;
import org.carpetorgaddition.wheel.inventory.AutoGrowInventory;
import org.carpetorgaddition.wheel.screen.QuickShulkerScreenHandler;

public class FakePlayerUtils {
    public static final int EMPTY_SPACE_SLOT_INDEX = -999;
    public static final int PICKUP_LEFT_CLICK = 0;
    public static final int PICKUP_RIGHT_CLICK = 1;
    public static final int THROW_Q = 0;
    public static final int THROW_CTRL_Q = 1;
    public static final int MAX_LOOP_COUNT = 1200;
    private static final boolean GCA_LOADED = FabricLoader.getInstance().isModLoaded("gca");
    public static final int PLAYER_INVENTORY_START = 9;
    public static final int PLAYER_INVENTORY_END = 44;

    private FakePlayerUtils() {
    }

    public static void dropItem(EntityPlayerMPFake player, class_1799 itemStack) {
        player.method_7329(itemStack.method_51164(), false, false);
    }

    public static boolean dropInventoryItem(EntityPlayerMPFake fakePlayer, Predicate<class_1799> predicate) {
        class_1723 screenHandler = fakePlayer.field_7498;
        boolean drop = false;
        for (class_1735 slot : screenHandler.field_7761) {
            int id;
            class_1799 itemStack = slot.method_7677();
            if (itemStack.method_7960() || !FakePlayerUtils.isStorageSlot(id = slot.field_7874) || FakePlayerUtils.isEquipmentSlot(id) || !predicate.test(itemStack)) continue;
            FakePlayerUtils.throwItem((class_1703)screenHandler, id, fakePlayer);
            drop = true;
        }
        return drop;
    }

    public static void sorting(EntityPlayerMPFake fakePlayer) {
        class_1723 screenHandler = fakePlayer.field_7498;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 44; i >= 9; --i) {
            if (!FakePlayerUtils.canClick(fakePlayer, (class_1703)screenHandler, i)) continue;
            list.add(i);
            class_1799 itemStack = screenHandler.method_7611(i).method_7677();
            if (InventoryUtils.isItemStackFull(itemStack)) continue;
            FakePlayerUtils.pickupCursorStack((class_1703)screenHandler, i, fakePlayer);
            FakePlayerUtils.mergeItemStack(fakePlayer, (class_1703)screenHandler, i - 1, 44);
            FakePlayerUtils.pickupCursorStack((class_1703)screenHandler, i, fakePlayer);
        }
        FakePlayerUtils.sorting(fakePlayer, (class_1703)screenHandler, (List<Integer>)list.reversed());
    }

    private static void sorting(EntityPlayerMPFake fakePlayer, class_1703 screenHandler, List<Integer> list) {
        if (list.isEmpty()) {
            return;
        }
        int start = 0;
        int end = list.size() - 1;
        class_1799 pivot = screenHandler.method_7611(list.getFirst().intValue()).method_7677();
        while (start < end) {
            boolean infiniteLoop = true;
            while (end > start && InventoryUtils.compare(pivot, screenHandler.method_7611(list.get(end).intValue()).method_7677()) <= 0) {
                --end;
                infiniteLoop = false;
            }
            while (end > start && InventoryUtils.compare(pivot, screenHandler.method_7611(list.get(start).intValue()).method_7677()) >= 0) {
                ++start;
                infiniteLoop = false;
            }
            if (infiniteLoop) {
                throw new InfiniteLoopException("Stuck in an infinite loop while sorting items on the %s".formatted(screenHandler.getClass().getName()));
            }
            FakePlayerUtils.swapSlotItem(screenHandler, list.get(start), list.get(end), fakePlayer);
        }
        FakePlayerUtils.swapSlotItem(screenHandler, list.getFirst(), list.get(start), fakePlayer);
        FakePlayerUtils.sorting(fakePlayer, screenHandler, list.subList(0, start));
        FakePlayerUtils.sorting(fakePlayer, screenHandler, list.subList(start + 1, list.size()));
    }

    private static void sorting(EntityPlayerMPFake fakePlayer, class_1703 screenHandler, int left, int right) {
        if (left >= right) {
            return;
        }
        int start = left;
        int end = right;
        class_1799 pivot = screenHandler.method_7611(left).method_7677();
        while (start < end) {
            while (end > start && InventoryUtils.compare(pivot, screenHandler.method_7611(end).method_7677()) <= 0) {
                --end;
            }
            while (end > start && InventoryUtils.compare(pivot, screenHandler.method_7611(start).method_7677()) >= 0) {
                ++start;
            }
            FakePlayerUtils.swapSlotItem(screenHandler, start, end, fakePlayer);
        }
        FakePlayerUtils.swapSlotItem(screenHandler, left, start, fakePlayer);
        FakePlayerUtils.sorting(fakePlayer, screenHandler, left, start - 1);
        FakePlayerUtils.sorting(fakePlayer, screenHandler, start + 1, right);
    }

    private static void mergeItemStack(EntityPlayerMPFake fakePlayer, class_1703 screenHandler, int start, int end) {
        for (int i = end; i > start; --i) {
            class_1799 cursorStack;
            class_1799 itemStack = screenHandler.method_7611(i).method_7677();
            if (itemStack.method_7960() || !FakePlayerUtils.canClick(fakePlayer, screenHandler, i) || !InventoryUtils.canMergeTo(cursorStack = screenHandler.method_34255(), itemStack)) continue;
            FakePlayerUtils.pickupCursorStack(screenHandler, i, fakePlayer);
            if (!screenHandler.method_34255().method_7960()) continue;
            return;
        }
    }

    private static boolean canClick(EntityPlayerMPFake fakePlayer, class_1703 screenHandler, int index) {
        class_1735 slot = screenHandler.method_7611(index);
        if (slot.method_32754((class_1657)fakePlayer)) {
            class_1799 itemStack = slot.method_7677();
            if (itemStack == AbstractCustomSizeInventory.PLACEHOLDER) {
                return false;
            }
            if (FakePlayerUtils.isGcaItem(itemStack)) {
                return false;
            }
            class_1703 class_17032 = fakePlayer.field_7512;
            if (class_17032 instanceof QuickShulkerScreenHandler) {
                QuickShulkerScreenHandler quickShulkerScreenHandler = (QuickShulkerScreenHandler)class_17032;
                return itemStack != quickShulkerScreenHandler.getShulkerBox();
            }
            return true;
        }
        return false;
    }

    public static void throwItem(class_1703 screenHandler, int slotIndex, EntityPlayerMPFake player) {
        screenHandler.method_7593(slotIndex, 1, class_1713.field_7795, (class_1657)player);
    }

    public static void stopAction(class_2168 source, EntityPlayerMPFake fakePlayer, String key, Object ... obj) {
        FetcherUtils.getFakePlayerActionManager(fakePlayer).setAction(new StopAction(fakePlayer));
        MessageUtils.broadcastMessage(source.method_9211(), TextBuilder.combineAll(fakePlayer.method_5476(), ": ", TextBuilder.translate(key, obj)));
    }

    public static class_1799 quickMove(class_1703 screenHandler, int slotIndex, EntityPlayerMPFake player) {
        return screenHandler.method_7601((class_1657)player, slotIndex);
    }

    public static void pickupAndThrow(class_1703 screenHandler, int slotIndex, EntityPlayerMPFake player) {
        screenHandler.method_7593(slotIndex, 0, class_1713.field_7790, (class_1657)player);
        screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)player);
    }

    public static boolean withKeepPickupAndMoveItemStack(class_1703 screenHandler, int fromIndex, int toIndex, EntityPlayerMPFake player) {
        class_1799 itemStack = screenHandler.method_7611(fromIndex).method_7677();
        if (CarpetOrgAdditionSettings.fakePlayerActionKeepItem.get().booleanValue() && itemStack.method_7947() == 1 && itemStack.method_7914() > 1) {
            return false;
        }
        if (!screenHandler.method_34255().method_7960()) {
            screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)player);
        }
        screenHandler.method_7593(fromIndex, 0, class_1713.field_7790, (class_1657)player);
        if (CarpetOrgAdditionSettings.fakePlayerActionKeepItem.get().booleanValue() && screenHandler.method_34255().method_7914() > 1) {
            screenHandler.method_7593(fromIndex, 1, class_1713.field_7790, (class_1657)player);
        }
        screenHandler.method_7593(toIndex, 0, class_1713.field_7790, (class_1657)player);
        return true;
    }

    public static void pickupAndMoveItemStack(class_1703 screenHandler, int fromIndex, int toIndex, EntityPlayerMPFake player) {
        if (!screenHandler.method_34255().method_7960()) {
            screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)player);
        }
        screenHandler.method_7593(fromIndex, 0, class_1713.field_7790, (class_1657)player);
        screenHandler.method_7593(toIndex, 0, class_1713.field_7790, (class_1657)player);
    }

    public static void pickupAndMoveHalfItemStack(class_1703 screenHandler, int fromIndex, int toIndex, EntityPlayerMPFake player) {
        if (!screenHandler.method_34255().method_7960()) {
            screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)player);
        }
        screenHandler.method_7593(fromIndex, 1, class_1713.field_7790, (class_1657)player);
        screenHandler.method_7593(toIndex, 0, class_1713.field_7790, (class_1657)player);
    }

    public static void pickupOneAndPlaceItemStack(class_1703 screenHandler, int fromIndex, int toIndex, EntityPlayerMPFake player) {
        if (fromIndex == toIndex) {
            return;
        }
        class_1799 from = screenHandler.method_7611(fromIndex).method_7677();
        class_1799 to = screenHandler.method_7611(toIndex).method_7677();
        if (to.method_7960() || InventoryUtils.canMergeTo(from, to)) {
            class_1799 cursorStack = screenHandler.method_34255();
            if (cursorStack.method_7960() || !InventoryUtils.canMerge(from, cursorStack)) {
                screenHandler.method_7593(fromIndex, 0, class_1713.field_7790, (class_1657)player);
                screenHandler.method_7593(toIndex, 1, class_1713.field_7790, (class_1657)player);
                screenHandler.method_7593(fromIndex, 0, class_1713.field_7790, (class_1657)player);
            } else {
                screenHandler.method_7593(toIndex, 1, class_1713.field_7790, (class_1657)player);
            }
        }
    }

    public static void loopThrowItem(class_1703 screenHandler, int slotIndex, EntityPlayerMPFake player) {
        InventoryUtils.assertEmptyStack(screenHandler.method_34255());
        class_1735 slot = screenHandler.method_7611(slotIndex);
        class_1792 item = slot.method_7677().method_7909();
        while (true) {
            class_1799 itemStack;
            if ((itemStack = slot.method_7677()).method_7960()) {
                return;
            }
            if (!itemStack.method_31574(item) || !slot.method_7674((class_1657)player)) break;
            screenHandler.method_7593(slotIndex, 0, class_1713.field_7795, (class_1657)player);
        }
    }

    public static void compareAndThrow(class_1703 screenHandler, int slotIndex, class_1799 itemStack, EntityPlayerMPFake player) {
        InventoryUtils.assertEmptyStack(screenHandler.method_34255());
        class_1735 slot = screenHandler.method_7611(slotIndex);
        while (slot.method_7681() && class_1799.method_31577((class_1799)itemStack, (class_1799)slot.method_7677()) && slot.method_7674((class_1657)player)) {
            screenHandler.method_7593(slotIndex, 0, class_1713.field_7795, (class_1657)player);
        }
    }

    public static void collectItem(class_1703 screenHandler, int slotIndex, AutoGrowInventory inventory, EntityPlayerMPFake fakePlayer) {
        class_1735 slot;
        InventoryUtils.assertEmptyStack(screenHandler.method_34255(), () -> "\u5149\u6807\u4e0a\u7269\u54c1\u975e\u7a7a");
        class_1792 item = screenHandler.method_7611(slotIndex).method_7677().method_7909();
        while ((slot = screenHandler.method_7611(slotIndex)).method_7681() && slot.method_7674((class_1657)fakePlayer) && item == slot.method_7677().method_7909()) {
            screenHandler.method_7593(slotIndex, 0, class_1713.field_7790, (class_1657)fakePlayer);
            inventory.addStack(screenHandler.method_34255());
            screenHandler.method_34254(class_1799.field_8037);
        }
    }

    public static void dropCursorStack(class_1703 screenHandler, EntityPlayerMPFake fakePlayer) {
        class_1799 itemStack = screenHandler.method_34255();
        if (itemStack.method_7960()) {
            return;
        }
        screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)fakePlayer);
    }

    public static void swapSlotItem(class_1703 screenHandler, int index1, int index2, EntityPlayerMPFake fakePlayer) {
        class_1799 slot2Item;
        if (index1 == index2) {
            return;
        }
        class_1799 slot1Item = screenHandler.method_7611(index1).method_7677();
        if (InventoryUtils.canMerge(slot1Item, slot2Item = screenHandler.method_7611(index2).method_7677())) {
            int difference = slot1Item.method_7947() - slot2Item.method_7947();
            if (difference > 0) {
                screenHandler.method_7593(index1, 0, class_1713.field_7790, (class_1657)fakePlayer);
                for (int i = 0; i < difference; ++i) {
                    screenHandler.method_7593(index2, 1, class_1713.field_7790, (class_1657)fakePlayer);
                }
                screenHandler.method_7593(index1, 0, class_1713.field_7790, (class_1657)fakePlayer);
            } else if (difference < 0) {
                screenHandler.method_7593(index2, 0, class_1713.field_7790, (class_1657)fakePlayer);
                for (int i = 0; i < -difference; ++i) {
                    screenHandler.method_7593(index1, 1, class_1713.field_7790, (class_1657)fakePlayer);
                }
                screenHandler.method_7593(index2, 0, class_1713.field_7790, (class_1657)fakePlayer);
            }
        } else {
            screenHandler.method_7593(index1, 0, class_1713.field_7790, (class_1657)fakePlayer);
            screenHandler.method_7593(index2, 0, class_1713.field_7790, (class_1657)fakePlayer);
            screenHandler.method_7593(index1, 0, class_1713.field_7790, (class_1657)fakePlayer);
        }
    }

    public static void pickupCursorStack(class_1703 screenHandler, int index, EntityPlayerMPFake fakePlayer) {
        screenHandler.method_7593(index, 0, class_1713.field_7790, (class_1657)fakePlayer);
    }

    public static boolean isGcaItem(class_1799 itemStack) {
        if (GCA_LOADED || CarpetOrgAddition.isDebugDevelopment()) {
            class_9279 component = (class_9279)itemStack.method_57824(class_9334.field_49628);
            if (component == null) {
                return false;
            }
            return component.method_57461().method_10580("GcaClear") != null;
        }
        return false;
    }

    public static boolean replenishment(EntityPlayerMPFake fakePlayer, Predicate<class_1799> predicate) {
        return FakePlayerUtils.replenishment(fakePlayer, class_1268.field_5808, predicate);
    }

    public static boolean replenishment(EntityPlayerMPFake fakePlayer, class_1268 hand, Predicate<class_1799> predicate) {
        class_1799 stackInHand = fakePlayer.method_5998(hand);
        if (predicate.test(stackInHand)) {
            return true;
        }
        class_1723 screenHandler = fakePlayer.field_7498;
        boolean pickItemFromShulker = CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get();
        ArrayList<Integer> shulkers = new ArrayList<Integer>();
        int headSlot = hand == class_1268.field_5808 ? 36 + fakePlayer.method_31548().field_7545 : 45;
        for (int i = 9; i <= 44; ++i) {
            class_1799 shulker;
            if (i == headSlot) continue;
            if (predicate.test(screenHandler.method_7611(i).method_7677())) {
                FakePlayerUtils.swapSlotItem((class_1703)screenHandler, i, headSlot, fakePlayer);
                return true;
            }
            if (!pickItemFromShulker || (shulker = screenHandler.method_7611(i).method_7677()).method_7960() || !InventoryUtils.isShulkerBoxItem(shulker)) continue;
            shulkers.add(i);
        }
        if (pickItemFromShulker) {
            for (Integer index : shulkers) {
                class_1799 shulker = screenHandler.method_7611(index.intValue()).method_7677();
                class_1799 picked = InventoryUtils.pickItemFromShulkerBox(shulker, predicate);
                if (picked.method_7960()) continue;
                fakePlayer.method_6122(hand, picked);
                FakePlayerUtils.putToEmptySlotOrDrop(fakePlayer, stackInHand);
                return true;
            }
        }
        return false;
    }

    public static void putToEmptySlotOrDrop(EntityPlayerMPFake fakePlayer, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        itemStack = itemStack.method_51164();
        class_1661 inventory = fakePlayer.method_31548();
        inventory.method_7394(itemStack);
        if (itemStack.method_7960()) {
            return;
        }
        if ((itemStack = InventoryUtils.putItemToInventoryShulkerBox(itemStack, fakePlayer)).method_7960()) {
            return;
        }
        fakePlayer.method_7329(itemStack, false, false);
    }

    public static boolean hasItem(EntityPlayerMPFake fakePlayer, Predicate<class_1799> predicate) {
        class_1661 inventory = fakePlayer.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!predicate.test(inventory.method_5438(i))) continue;
            return true;
        }
        return predicate.test(fakePlayer.method_6079());
    }

    public static void look(EntityPlayerMPFake fakePlayer, class_2350 direction) {
        EntityPlayerActionPack actionPack = ((ServerPlayerInterface)fakePlayer).getActionPack();
        actionPack.look(direction);
    }

    public static void swapHand(EntityPlayerMPFake fakePlayer) {
        class_1799 temp = fakePlayer.method_5998(class_1268.field_5810);
        fakePlayer.method_6122(class_1268.field_5810, fakePlayer.method_5998(class_1268.field_5808));
        fakePlayer.method_6122(class_1268.field_5808, temp);
    }

    public static class_2561 getWithCountHoverText(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return new TextBuilder("[A]").setHover(class_1802.field_8162.method_63680()).setColor(class_124.field_1063).build();
        }
        String capitalizeFirstLetter = FakePlayerUtils.getInitial(itemStack);
        class_2561 hover = TextBuilder.combineAll(itemStack.method_7909().method_63680(), "*" + itemStack.method_7947());
        return new TextBuilder(capitalizeFirstLetter).setHover(hover).build();
    }

    public static String getInitial(class_1799 itemStack) {
        String name = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        String[] split = name.split(":");
        int index = split.length == 1 ? 0 : 1;
        return "[" + Character.toUpperCase(split[index].charAt(0)) + "]";
    }

    public static boolean shouldStop(int craftCount) {
        if (CarpetOrgAdditionSettings.fakePlayerMaxItemOperationCount.get() < 0) {
            return false;
        }
        return craftCount >= CarpetOrgAdditionSettings.fakePlayerMaxItemOperationCount.get();
    }

    public static void stopCraftAction(class_2168 source, EntityPlayerMPFake playerMPFake) {
        FakePlayerUtils.stopAction(source, playerMPFake, "carpet.commands.playerAction.craft", new Object[0]);
    }

    public static boolean isStorageSlot(int index) {
        return MathUtils.isInRange(5, 44, index);
    }

    public static boolean isEquipmentSlot(int index) {
        return MathUtils.isInRange(5, 8, index);
    }
}

