/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.rule.OrgRule;
import org.carpetorgaddition.rule.RuleContext;
import org.carpetorgaddition.rule.RuleObserver;
import org.carpetorgaddition.rule.validator.Validator;
import org.jetbrains.annotations.NotNull;

public class RuleFactory {
    public static <T> Builder<T> create(Class<T> type, String rule, T value) {
        return new Builder<T>(type, rule, value);
    }

    public static class Builder<T> {
        private final Class<T> type;
        private final String name;
        private final Collection<String> categories = new ArrayList<String>();
        private final Collection<String> suggestions;
        @NotNull
        private final T value;
        private final List<Validator<T>> validators = new ArrayList<Validator<T>>();
        private final List<RuleObserver<T>> observers = new ArrayList<RuleObserver<T>>();
        private final List<Supplier<Boolean>> conditions = new ArrayList<Supplier<Boolean>>();
        private boolean canBeToggledClientSide = false;
        private boolean strict = true;
        private boolean isHidden;
        private boolean isRemove;
        private boolean isRuleSelf = false;
        private String displayName = "";
        private String displayDesc = "";

        private Builder(Class<T> type, String rule, @NotNull T value) {
            if (type != value.getClass()) {
                throw new IllegalArgumentException("Rule %s: type mismatch - expected %s, actual %s".formatted(rule, type.getSimpleName(), value.getClass().getSimpleName()));
            }
            this.type = type;
            this.value = value;
            this.name = rule;
            if (rule.isBlank()) {
                throw new IllegalArgumentException("Carpet rule name is empty");
            }
            this.suggestions = this.type == Boolean.class ? List.of("true", "false") : (this.type.isEnum() ? Arrays.stream(this.type.getEnumConstants()).map(e -> (Enum)e).map(Enum::name).map(s -> s.toLowerCase(Locale.ROOT)).toList() : new ArrayList<String>());
            this.categories.add("Org");
        }

        public Builder<T> addCategories(String ... categories) {
            if (categories.length == 0) {
                throw new IllegalArgumentException("At least one category must be provided");
            }
            this.categories.addAll(List.of(categories));
            return this;
        }

        public Builder<T> addOptions(String ... options) {
            if (options.length == 0) {
                throw new IllegalArgumentException("At least one option must be provided");
            }
            this.suggestions.addAll(List.of(options));
            return this;
        }

        public Builder<T> addOptions(int ... options) {
            return this.addOptions((String[])Arrays.stream(options).mapToObj(Integer::toString).toArray(String[]::new));
        }

        public Builder<T> setClient() {
            this.canBeToggledClientSide = true;
            return this;
        }

        public Builder<T> setLenient() {
            this.strict = false;
            return this;
        }

        public Builder<T> setPlayerCustom() {
            this.isRuleSelf = true;
            return this;
        }

        public Builder<T> setDisplayName(String name) {
            this.displayName = name;
            return this;
        }

        public Builder<T> setDisplayDesc(String desc) {
            this.displayDesc = desc;
            return this;
        }

        public Builder<T> setHidden() {
            this.conditions.add(() -> CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION);
            this.addCategories("Hidden");
            this.isHidden = true;
            return this;
        }

        public Builder<T> setRemoved() {
            this.conditions.addFirst(() -> false);
            this.isRemove = true;
            return this;
        }

        public Builder<T> addValidator(Predicate<T> predicate, Supplier<class_2561> supplier) {
            return this.addValidators(Validator.of(predicate, supplier));
        }

        @SafeVarargs
        public final Builder<T> addValidators(Validator<T> ... validators) {
            this.validators.addAll(List.of(validators));
            return this;
        }

        @SafeVarargs
        public final Builder<T> addObservers(RuleObserver<T> ... observers) {
            this.observers.addAll(List.of(observers));
            return this;
        }

        public RuleContext<T> build() {
            Supplier supplier = () -> new OrgRule<T>(this.type, this.name, this.categories, this.suggestions, this.value, this.canBeToggledClientSide, this.validators, this.observers, this.strict, this.displayName, this.displayDesc);
            return new RuleContext<T>(this.type, this.value, this.name, supplier, this.conditions, this.categories, this.suggestions, this.isRemove, this.isHidden, this.isRuleSelf);
        }
    }
}

