/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.debug.client.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import org.carpetorgaddition.client.command.argument.ClientBlockPosArgumentType;
import org.carpetorgaddition.client.renderer.BoxRenderer;
import org.carpetorgaddition.client.util.ClientUtils;
import org.carpetorgaddition.exception.ProductionEnvironmentError;
import org.carpetorgaddition.wheel.BlockIterator;

public class SelectionAreaCommand {
    private static final ArrayList<SelectionAreaDebugRenderer> RENDERERS = new ArrayList();

    public static void register() {
        ProductionEnvironmentError.assertDevelopmentEnvironment();
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(context -> RENDERERS.forEach(renderer -> renderer.render(context.matrixStack())));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> RENDERERS.clear());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, commandRegistryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"blockIterator").then(ClientCommandManager.argument((String)"from", (ArgumentType)ClientBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"to", (ArgumentType)ClientBlockPosArgumentType.blockPos()).executes(SelectionAreaCommand::render)))));
    }

    private static int render(CommandContext<FabricClientCommandSource> context) {
        ProductionEnvironmentError.assertDevelopmentEnvironment();
        class_2338 from = ClientBlockPosArgumentType.getBlockPos(context, "from");
        class_2338 to = ClientBlockPosArgumentType.getBlockPos(context, "to");
        RENDERERS.add(new SelectionAreaDebugRenderer(new BlockIterator(from, to)));
        return 0;
    }

    public static class SelectionAreaDebugRenderer
    extends BoxRenderer {
        private final ArrayDeque<class_238> deque = new ArrayDeque();
        private long previousTick = this.getGameTime();

        public SelectionAreaDebugRenderer(BlockIterator area) {
            super(area.toBox());
            for (class_2338 blockPos : area) {
                this.deque.push(new class_238(blockPos));
            }
        }

        @Override
        public void render(class_4587 matrixStack) {
            if (this.deque.isEmpty()) {
                return;
            }
            class_238 box = this.deque.peek();
            this.setBox(box);
            if (this.previousTick != this.getGameTime()) {
                this.previousTick = this.getGameTime();
                this.deque.pop();
            }
            super.render(matrixStack);
        }

        private long getGameTime() {
            return ClientUtils.getWorld().method_8510();
        }
    }
}

