/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer.waypoint;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.carpetorgaddition.client.util.ClientUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public abstract class Waypoint {
    private final class_2960 icon;
    private long age;
    private long remaining;
    private class_243 target;
    @NotNull
    protected class_243 lastTarget;
    @NotNull
    protected class_5321<class_1937> registryKey;
    private final boolean persistent;
    protected float tickDelta = 1.0f;
    protected float lastTickDelta = 1.0f;
    private static final long VANISHING_TIME = 4L;
    public static final class_2960 HIGHLIGHT = class_2960.method_60656((String)"textures/map/decorations/red_x.png");
    public static final class_2960 NAVIGATOR = class_2960.method_60656((String)"textures/map/decorations/target_x.png");

    public Waypoint(@NotNull class_5321<class_1937> registryKey, @NotNull class_243 target, class_2960 icon, long duration, boolean persistent) {
        this.registryKey = registryKey;
        this.target = target;
        this.lastTarget = target;
        this.icon = icon;
        this.remaining = duration;
        this.persistent = persistent;
    }

    public Waypoint(class_1937 world, class_243 target, class_2960 icon, long duration, boolean persistent) {
        this((class_5321<class_1937>)world.method_27983(), target, icon, duration, persistent);
    }

    public void render(class_4587 matrixStack, class_4597 consumers, class_4184 camera, class_9779 tickCounter) {
        if (this.isDone()) {
            return;
        }
        class_243 revised = this.getRevisedPos();
        if (revised == null) {
            return;
        }
        float tickDelta = tickCounter.method_60637(false);
        if (this.tickDelta > tickDelta) {
            this.tick();
        }
        this.lastTickDelta = this.tickDelta;
        this.tickDelta = tickDelta;
        class_243 cameraPos = camera.method_19326();
        class_243 offset = revised.method_1020(cameraPos);
        int renderDistance = (Integer)ClientUtils.getGameOptions().method_42503().method_41753() * 16;
        class_243 correction = new class_243(offset.method_10216(), offset.method_10214(), offset.method_10215());
        if (correction.method_1033() > (double)renderDistance) {
            correction = correction.method_1029().method_1021((double)renderDistance);
        }
        matrixStack.method_22903();
        this.transform(matrixStack, camera, correction);
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, -1.0f, -1.0f, 0.0f).method_22913(0.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f, -1.0f, 1.0f, 0.0f).method_22913(0.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f, 1.0f, 1.0f, 0.0f).method_22913(1.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f, 1.0f, -1.0f, 0.0f).method_22913(1.0f, 0.0f);
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.icon);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        tessellator.method_60828();
        if (this.isWatching(camera, revised)) {
            this.drawDistance(matrixStack, consumers, offset, tessellator);
        }
        matrixStack.method_22909();
    }

    protected void transform(class_4587 matrixStack, class_4184 camera, class_243 correction) {
        matrixStack.method_22904(correction.method_10216(), correction.method_10214(), correction.method_10215());
        float scale = this.getScale(correction.method_1033());
        matrixStack.method_22905(scale, scale, scale);
        matrixStack.method_22907(new Quaternionf(-1.0f, 0.0f, 0.0f, 0.0f));
        matrixStack.method_22907(new Quaternionf().rotateY((float)(Math.PI / 180 * (double)(camera.method_19330() - 180.0f))));
        matrixStack.method_22907(new Quaternionf().rotateX((float)(Math.PI / 180 * (double)(-camera.method_19329()))));
    }

    protected void tick() {
        ++this.age;
        if (!this.persistent || this.remaining <= 0L) {
            --this.remaining;
        }
    }

    @Nullable
    protected class_243 getRevisedPos() {
        class_5321 key = ClientUtils.getWorld().method_27983();
        class_243 interpolation = this.getInterpolation();
        if (this.registryKey.equals((Object)key)) {
            return interpolation;
        }
        class_4184 camera = ClientUtils.getCamera();
        if (WorldUtils.isOverworld((class_5321<class_1937>)key) && WorldUtils.isTheNether(this.registryKey)) {
            return new class_243(interpolation.method_10216() * 8.0, camera.method_19326().method_10214(), interpolation.method_10215() * 8.0);
        }
        if (WorldUtils.isTheNether((class_5321<class_1937>)key) && WorldUtils.isOverworld(this.registryKey)) {
            return new class_243(interpolation.method_10216() / 8.0, camera.method_19326().method_10214(), interpolation.method_10215() / 8.0);
        }
        return null;
    }

    protected class_243 getInterpolation() {
        return this.target;
    }

    private float getScale(double distance) {
        if (this.isDone()) {
            return 0.0f;
        }
        float scale = (float)distance / 30.0f;
        scale = Math.max(scale * (1.0f - (float)distance / 40.0f * 0.1f), scale * 0.75f);
        if (this.remaining < 0L) {
            return this.fade(4.0f + ((float)this.remaining - this.tickDelta) + 1.0f, scale);
        }
        if (this.age < 4L) {
            return this.fade((float)this.age + this.tickDelta, scale);
        }
        return scale;
    }

    private float fade(float time, float scale) {
        if (time <= 0.0f) {
            return 0.0f;
        }
        float x = time / 4.0f;
        return scale * x * x;
    }

    private boolean isWatching(class_4184 camera, class_243 target) {
        float f = camera.method_19329() * ((float)Math.PI / 180);
        float g = -camera.method_19330() * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        class_243 vec3d = new class_243((double)(i * j), (double)(-k), (double)(h * j)).method_1029();
        class_243 vec3d2 = new class_243(target.method_10216() - camera.method_19326().method_10216(), target.method_10214() - camera.method_19326().method_10214(), target.method_10215() - camera.method_19326().method_10215());
        double d = vec3d2.method_1033();
        double e = vec3d.method_1026(vec3d2 = vec3d2.method_1029());
        return e > 0.999 - 0.025 / d;
    }

    private void drawDistance(class_4587 matrixStack, class_4597 consumers, class_243 offset, class_289 tessellator) {
        class_327 textRenderer = ClientUtils.getTextRenderer();
        double distance = offset.method_1033();
        String formatted = distance >= 1000.0 ? "%.1fkm".formatted(distance / 1000.0) : "%.1fm".formatted(distance);
        TextBuilder builder = new TextBuilder(formatted);
        if (!this.registryKey.equals((Object)ClientUtils.getWorld().method_27983())) {
            builder.setItalic();
        }
        int width = textRenderer.method_1727(formatted);
        float backgroundOpacity = ClientUtils.getGameOptions().method_19343(0.25f);
        int opacity = (int)(backgroundOpacity * 255.0f) << 24;
        matrixStack.method_22903();
        matrixStack.method_22905(0.15f, 0.15f, 0.15f);
        textRenderer.method_27522(builder.build(), (float)(-width) / 2.0f, 8.0f, -1, false, matrixStack.method_23760().method_23761(), consumers, class_327.class_6415.field_33994, opacity, 1);
        tessellator.method_60828();
        matrixStack.method_22909();
    }

    public void stop() {
        if (this.remaining > 0L) {
            this.remaining = 0L;
        }
    }

    public void discard() {
        if (this.isDone()) {
            return;
        }
        this.remaining = -2147483647L;
    }

    public boolean isDone() {
        return -(this.remaining - 1L) > 4L;
    }

    public class_2960 getIcon() {
        return this.icon;
    }

    public final class_243 getTarget() {
        return this.target;
    }

    public void setTarget(class_5321<class_1937> registryKey, class_243 vec3d) {
        this.target = vec3d;
        this.registryKey = registryKey;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Waypoint that = (Waypoint)o;
        return Objects.equals(this.icon, that.icon) && Objects.equals(this.registryKey, that.registryKey) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        return Objects.hash(this.icon, this.target);
    }

    public void requestServerToStop() {
    }

    public abstract String getName();
}

