/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer.waypoint;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9779;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.client.renderer.waypoint.Waypoint;
import org.carpetorgaddition.client.util.ClientMessageUtils;
import org.carpetorgaddition.client.util.ClientUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class WaypointRenderer {
    private final Map<Object, Waypoint> waypoints = new HashMap<Object, Waypoint>();
    private final class_4184 camera = ClientUtils.getCamera();
    private static WaypointRenderer INSTANCE;

    private WaypointRenderer() {
    }

    @NotNull
    public static WaypointRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WaypointRenderer();
        }
        return INSTANCE;
    }

    private static void destroy() {
        INSTANCE = null;
    }

    public void render(WorldRenderContext context) {
        class_4587 matrixStack = context.matrixStack();
        for (Waypoint waypoint : this.waypoints.values()) {
            try {
                RenderSystem.disableDepthTest();
                class_4597 consumers = context.consumers();
                class_9779 tickCounter = context.tickCounter();
                waypoint.render(matrixStack, consumers, this.camera, tickCounter);
            }
            catch (RuntimeException e) {
                ClientMessageUtils.sendErrorMessage(e, "carpet.client.render.waypoint.error", new Object[0]);
                CarpetOrgAddition.LOGGER.error("An unexpected error occurred while rendering waypoint '{}'", (Object)waypoint.getName(), (Object)e);
                waypoint.discard();
                waypoint.requestServerToStop();
            }
        }
    }

    public Waypoint addOrUpdate(Waypoint waypoint) {
        return this.waypoints.computeIfAbsent(waypoint.getIcon(), key -> waypoint);
    }

    public Optional<Waypoint> addOrModify(Waypoint waypoint) {
        Waypoint oldWaypoint = this.waypoints.put(waypoint.getIcon(), waypoint);
        if (oldWaypoint == null) {
            return Optional.empty();
        }
        this.waypoints.put(new Object(), oldWaypoint);
        return Optional.of(oldWaypoint);
    }

    public void stop(Waypoint waypoint) {
        Waypoint oldWaypoint = this.waypoints.remove(waypoint.getIcon());
        if (oldWaypoint == null) {
            return;
        }
        this.waypoints.put(new Object(), oldWaypoint);
        oldWaypoint.stop();
    }

    public @Unmodifiable List<Waypoint> listRenderers(class_2960 icon) {
        return this.waypoints.values().stream().filter(waypoint -> waypoint.getIcon().equals((Object)icon)).toList();
    }

    static {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> WaypointRenderer.destroy());
        WorldRenderEvents.START.register(context -> WaypointRenderer.getInstance().waypoints.values().removeIf(Waypoint::isDone));
    }
}

