/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.Waypoint;
import org.carpetorgaddition.wheel.WorldFormat;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.Nullable;

public class LocationsCommand
extends AbstractServerCommand {
    public LocationsCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandLocations))).then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> this.addWayPoint((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> this.addWayPoint((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(context -> this.listWayPoint((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(context -> this.listWayPoint((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"filter")))))).then(class_2170.method_9247((String)"supplement").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(LocationsCommand.suggestion()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"comment").executes(context -> this.addIllustrateText((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.string()).executes(context -> this.addIllustrateText((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"comment")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"another_pos").executes(context -> this.addAnotherPos((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"anotherPos", (ArgumentType)class_2262.method_9698()).executes(context -> this.addAnotherPos((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"anotherPos")))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(LocationsCommand.suggestion()).executes(this::deleteWayPoint)))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(LocationsCommand.suggestion()).executes(context -> this.setWayPoint((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> this.setWayPoint((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos"))))))).then(class_2170.method_9247((String)"here").executes(this::sendSelfLocation)));
    }

    public static SuggestionProvider<class_2168> suggestion() {
        return (context, builder) -> {
            WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "waypoint", new String[0]);
            return class_2172.method_9264(worldFormat.toImmutableFileList().stream().map(File::getName).filter(name -> name.endsWith(".json")).map(s -> IOUtils.removeExtension(s, ".json")).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
        };
    }

    private int addWayPoint(CommandContext<class_2168> context, @Nullable class_2338 blockPos) throws CommandSyntaxException {
        MinecraftServer server;
        WorldFormat worldFormat;
        class_3222 player = CommandUtils.getSourcePlayer(context);
        String name = StringArgumentType.getString(context, (String)"name");
        if (IOUtils.isValidFileName(name)) {
            throw CommandUtils.createException("carpet.command.file.name.valid", new Object[0]);
        }
        if (blockPos == null) {
            blockPos = player.method_24515();
        }
        if ((worldFormat = new WorldFormat(server = ((class_2168)context.getSource()).method_9211(), "waypoint", new String[0])).file(name + ".json").exists()) {
            throw CommandUtils.createException("carpet.commands.locations.add.fail.already_exists", name);
        }
        Waypoint waypoint = new Waypoint(blockPos, name, player);
        try {
            waypoint.save();
            MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.locations.add.success", name, WorldUtils.toPosString(blockPos));
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.error("{}\u5728\u5c1d\u8bd5\u5c06\u8def\u5f84\u70b9\u5199\u5165\u672c\u5730\u6587\u4ef6\u65f6\u51fa\u73b0\u610f\u5916\u95ee\u9898:", (Object)FetcherUtils.getPlayerName((class_1657)player), (Object)e);
        }
        return 1;
    }

    private int listWayPoint(CommandContext<class_2168> context, @Nullable String filter) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        WorldFormat worldFormat = new WorldFormat(server, "waypoint", new String[0]);
        List<File> list = worldFormat.toImmutableFileList();
        if (list.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.locations.list.no_waypoint", new Object[0]);
            return 0;
        }
        PageManager pageManager = FetcherUtils.getPageManager(server);
        PagedCollection collection = pageManager.newPagedCollection((class_2168)context.getSource());
        ArrayList<Supplier<class_2561>> messages = new ArrayList<Supplier<class_2561>>();
        int count = 0;
        for (File file : list) {
            String name = file.getName();
            if (filter != null && !name.contains(filter)) continue;
            try {
                Waypoint waypoint = Waypoint.load(server, name);
                messages.add(waypoint::line);
                ++count;
            }
            catch (IOException | NullPointerException e) {
                CarpetOrgAddition.LOGGER.warn("Failed to parse waypoint [{}]", (Object)IOUtils.removeExtension(name), (Object)e);
            }
        }
        if (messages.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.locations.list.no_waypoint", new Object[0]);
            return 0;
        }
        collection.addContent(messages);
        MessageUtils.sendEmptyMessage(context);
        collection.print();
        return count;
    }

    private int addIllustrateText(CommandContext<class_2168> context, @Nullable String comment) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        String name = StringArgumentType.getString(context, (String)"name");
        try {
            Waypoint waypoint = Waypoint.load(server, name);
            boolean remove = false;
            if (comment == null || comment.isEmpty()) {
                comment = null;
                remove = true;
            }
            waypoint.setComment(comment);
            waypoint.save();
            if (remove) {
                MessageUtils.sendMessage(source, "carpet.commands.locations.comment.remove", name);
            } else {
                MessageUtils.sendMessage(source, "carpet.commands.locations.comment.add", comment, name);
            }
        }
        catch (IOException | NullPointerException e) {
            CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u4e3a\u8def\u5f84\u70b9[{}]\u6dfb\u52a0\u8bf4\u660e\u6587\u672c", (Object)name, (Object)e);
            throw CommandUtils.createException("carpet.commands.locations.comment.io", name);
        }
        return 1;
    }

    private int addAnotherPos(CommandContext<class_2168> context, @Nullable class_2338 blockPos) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2168 source = (class_2168)context.getSource();
        if (blockPos == null) {
            blockPos = player.method_24515();
        }
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        String name = StringArgumentType.getString(context, (String)"name");
        try {
            Waypoint waypoint = Waypoint.load(server, name);
            if (!waypoint.canAddAnother()) {
                throw CommandUtils.createException("carpet.commands.locations.another.add.fail", new Object[0]);
            }
            waypoint.setAnotherBlockPos(blockPos);
            waypoint.save();
            MessageUtils.sendMessage(source, "carpet.commands.locations.another.add", new Object[0]);
        }
        catch (IOException | NullPointerException e) {
            CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u89e3\u6790\u8def\u5f84\u70b9[{}]:", (Object)name, (Object)e);
            throw CommandUtils.createException("carpet.commands.locations.another.io", name);
        }
        return 1;
    }

    private int deleteWayPoint(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String name = StringArgumentType.getString(context, (String)"name");
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "waypoint", new String[0]);
        File file = worldFormat.file(name + ".json");
        if (!file.delete()) {
            throw CommandUtils.createException("carpet.commands.locations.remove.fail", name);
        }
        MessageUtils.sendMessage(source, "carpet.commands.locations.remove.success", name);
        return 1;
    }

    private int setWayPoint(CommandContext<class_2168> context, @Nullable class_2338 blockPos) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2168 source = (class_2168)context.getSource();
        if (blockPos == null) {
            blockPos = player.method_24515();
        }
        String fileName = StringArgumentType.getString(context, (String)"name");
        try {
            Waypoint waypoint = Waypoint.load(((class_2168)context.getSource()).method_9211(), fileName);
            waypoint.setBlockPos(blockPos);
            waypoint.save();
            MessageUtils.sendMessage(source, "carpet.commands.locations.set", fileName);
        }
        catch (IOException | NullPointerException e) {
            throw CommandUtils.createException("carpet.commands.locations.set.io", fileName);
        }
        return 1;
    }

    private int sendSelfLocation(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 blockPos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        class_2561 text = switch (WorldUtils.getDimensionId((class_1937)world)) {
            case "minecraft:overworld" -> TextBuilder.translate("carpet.commands.locations.here.overworld", player.method_5476(), TextProvider.blockPos(blockPos, class_124.field_1060), TextProvider.blockPos(MathUtils.getTheNetherPos((class_1297)player), class_124.field_1061));
            case "minecraft:the_nether" -> TextBuilder.translate("carpet.commands.locations.here.the_nether", player.method_5476(), TextProvider.blockPos(blockPos, class_124.field_1061), TextProvider.blockPos(MathUtils.getOverworldPos((class_1297)player), class_124.field_1060));
            case "minecraft:the_end" -> TextBuilder.translate("carpet.commands.locations.here.the_end", player.method_5476(), TextProvider.blockPos(blockPos, class_124.field_1064));
            default -> TextBuilder.translate("carpet.commands.locations.here.default", player.method_5476(), WorldUtils.getDimensionId((class_1937)world), TextProvider.blockPos(blockPos, null));
        };
        MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), text);
        return 1;
    }

    @Override
    public String getDefaultName() {
        return "locations";
    }
}

