/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3988;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.mixin.accessor.MerchantScreenHandlerAccessor;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.wheel.TextBuilder;

public class TradeAction
extends AbstractPlayerAction {
    public static final String INDEX = "index";
    public static final String VOID_TRADE = "void_trade";
    private final int index;
    private final boolean voidTrade;
    private final MutableInt timer = new MutableInt();
    public static final int TRADE_WAIT_TIME = 1;

    public TradeAction(EntityPlayerMPFake fakePlayer, int index, boolean voidTrade) {
        super(fakePlayer);
        this.index = index;
        this.voidTrade = voidTrade;
        this.timer.setValue(1);
    }

    @Override
    protected void tick() {
        class_1703 class_17032 = this.getFakePlayer().field_7512;
        if (class_17032 instanceof class_1728) {
            class_1728 merchantScreenHandler = (class_1728)class_17032;
            if (this.voidTrade) {
                class_3988 merchantEntity;
                MerchantScreenHandlerAccessor accessor = (MerchantScreenHandlerAccessor)merchantScreenHandler;
                class_1915 merchant = accessor.getMerchant();
                if (merchant instanceof class_3988 && this.shouldWait(merchantEntity = (class_3988)merchant)) {
                    this.timer.setValue(1);
                    return;
                }
                if (this.timer.getValue() != 0) {
                    this.timer.decrement();
                    return;
                }
                this.timer.setValue(1);
            }
            if (merchantScreenHandler.method_17438().size() <= this.index) {
                FakePlayerUtils.stopAction(this.getFakePlayer().method_64396(), this.getFakePlayer(), "carpet.commands.playerAction.trade", new Object[0]);
                return;
            }
            this.tryTrade(merchantScreenHandler);
            if (this.voidTrade) {
                this.getFakePlayer().method_7346();
            }
        }
    }

    private void tryTrade(class_1728 screenHandler) {
        class_2168 source = this.getFakePlayer().method_64396();
        int loopCount = 0;
        do {
            if (++loopCount > 1000) {
                throw new InfiniteLoopException();
            }
            class_1914 tradeOffer = (class_1914)screenHandler.method_17438().get(this.index);
            if (tradeOffer.method_8255()) {
                return;
            }
            screenHandler.method_7650(this.index);
            if (this.switchItem(screenHandler, tradeOffer)) {
                class_1735 outputSlot = screenHandler.method_7611(2);
                if (outputSlot.method_7681()) {
                    FakePlayerUtils.compareAndThrow((class_1703)screenHandler, 2, tradeOffer.method_8250(), this.getFakePlayer());
                    if (!CarpetOrgAdditionSettings.villagerInfiniteTrade.get().booleanValue() || CarpetOrgAdditionSettings.fakePlayerMaxItemOperationCount.get() <= 0 || loopCount < CarpetOrgAdditionSettings.fakePlayerMaxItemOperationCount.get()) continue;
                    return;
                }
                FakePlayerUtils.stopAction(source, this.getFakePlayer(), "carpet.commands.playerAction.trade", new Object[0]);
                return;
            }
            return;
        } while (this.voidTrade || CarpetOrgAdditionSettings.villagerInfiniteTrade.get().booleanValue());
    }

    private boolean switchItem(class_1728 merchantScreenHandler, class_1914 tradeOffer) {
        class_1799 firstBuyItem = tradeOffer.method_19272();
        class_1799 secondBuyItem = tradeOffer.method_8247();
        return this.fillTradeSlot(merchantScreenHandler, firstBuyItem, 0) && this.fillTradeSlot(merchantScreenHandler, secondBuyItem, 1);
    }

    private boolean fillTradeSlot(class_1728 merchantScreenHandler, class_1799 buyItem, int slotIndex) {
        class_2371 list = merchantScreenHandler.field_7761;
        class_1735 tradeSlot = merchantScreenHandler.method_7611(slotIndex);
        if (!tradeSlot.method_7677().method_31574(buyItem.method_7909())) {
            FakePlayerUtils.throwItem((class_1703)merchantScreenHandler, slotIndex, this.getFakePlayer());
        }
        if (buyItem.method_7960() || this.slotItemCanTrade(tradeSlot.method_7677(), buyItem)) {
            return true;
        }
        for (int index = 3; index < list.size(); ++index) {
            class_1799 itemStack = ((class_1735)list.get(index)).method_7677();
            Predicate<class_1799> predicate = this.getStackPredicate(buyItem, tradeSlot.method_7677());
            if (!predicate.test(itemStack) || !FakePlayerUtils.withKeepPickupAndMoveItemStack((class_1703)merchantScreenHandler, index, slotIndex, this.getFakePlayer())) continue;
            if (!merchantScreenHandler.method_34255().method_7960()) {
                FakePlayerUtils.pickupCursorStack((class_1703)merchantScreenHandler, index, this.getFakePlayer());
            }
            if (!this.slotItemCanTrade(tradeSlot.method_7677(), buyItem)) continue;
            return true;
        }
        if (CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get().booleanValue()) {
            return this.pickFromShulkerBox(merchantScreenHandler, buyItem, slotIndex, tradeSlot);
        }
        return false;
    }

    private boolean pickFromShulkerBox(class_1728 screenHandler, class_1799 buyItem, int slotIndex, class_1735 tradeSlot) {
        class_2371 list = screenHandler.field_7761;
        for (int index = 3; index < list.size(); ++index) {
            class_1799 contentItemStack;
            int difference = tradeSlot.method_7677().method_7914() - tradeSlot.method_7677().method_7947();
            class_1799 itemStack = ((class_1735)list.get(index)).method_7677();
            Predicate<class_1799> predicate = this.getStackPredicate(buyItem, tradeSlot.method_7677());
            if (!InventoryUtils.isOperableSulkerBox(itemStack) || (contentItemStack = InventoryUtils.pickItemFromShulkerBox(itemStack, predicate, difference)).method_7960()) continue;
            FakePlayerUtils.dropCursorStack((class_1703)screenHandler, this.getFakePlayer());
            screenHandler.method_34254(contentItemStack);
            FakePlayerUtils.pickupCursorStack((class_1703)screenHandler, slotIndex, this.getFakePlayer());
            if (!this.slotItemCanTrade(tradeSlot.method_7677(), buyItem)) continue;
            return true;
        }
        return false;
    }

    private Predicate<class_1799> getStackPredicate(class_1799 buyItem, class_1799 slotItem) {
        Predicate<class_1799> predicate = slotItem.method_7960() ? stack -> buyItem.method_31574(stack.method_7909()) : stack -> class_1799.method_31577((class_1799)slotItem, (class_1799)stack);
        return predicate;
    }

    private boolean shouldWait(class_3988 merchant) {
        class_1923 chunkPos = merchant.method_31476();
        if (FetcherUtils.getWorld((class_1297)merchant).method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
            UUID uuid = merchant.method_5667();
            MinecraftServer server = FetcherUtils.getServer((class_1297)merchant);
            if (server == null) {
                return true;
            }
            for (class_3218 world : server.method_3738()) {
                if (world.method_14190(uuid) == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean slotItemCanTrade(class_1799 slotItem, class_1799 tradeItem) {
        return slotItem.method_7947() >= tradeItem.method_7947() || slotItem.method_7947() >= slotItem.method_7914();
    }

    @Override
    public List<class_2561> info() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add(TextBuilder.translate("carpet.commands.playerAction.info.trade.item", this.getFakePlayer().method_5476(), this.index + 1));
        class_1703 class_17032 = this.getFakePlayer().field_7512;
        if (class_17032 instanceof class_1728) {
            class_1728 merchantScreenHandler = (class_1728)class_17032;
            class_1914 tradeOffer = (class_1914)merchantScreenHandler.method_17438().get(this.index);
            list.add(TextBuilder.combineAll("    ", FakePlayerUtils.getWithCountHoverText(tradeOffer.method_19272()), " ", FakePlayerUtils.getWithCountHoverText(tradeOffer.method_8247()), " -> ", FakePlayerUtils.getWithCountHoverText(tradeOffer.method_8250())));
            if (tradeOffer.method_8255()) {
                list.add(TextBuilder.translate("carpet.commands.playerAction.info.trade.disabled", new Object[0]));
                return list;
            }
            list.add(TextBuilder.translate("carpet.commands.playerAction.info.trade.state", new Object[0]));
            list.add(TextBuilder.combineAll("    ", FakePlayerUtils.getWithCountHoverText(merchantScreenHandler.method_7611(0).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(merchantScreenHandler.method_7611(1).method_7677()), " -> ", FakePlayerUtils.getWithCountHoverText(merchantScreenHandler.method_7611(2).method_7677())));
        } else {
            list.add(TextBuilder.translate("carpet.commands.playerAction.info.trade.no_villager", this.getFakePlayer().method_5476()));
        }
        return list;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty(INDEX, (Number)this.index);
        json.addProperty(VOID_TRADE, Boolean.valueOf(this.voidTrade));
        return json;
    }

    @Override
    public class_2561 getDisplayName() {
        return TextBuilder.translate("carpet.commands.playerAction.action.trade", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.TRADE;
    }
}

