/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.navigator.AbstractNavigator;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class EntityNavigator
extends AbstractNavigator {
    @NotNull
    private class_1297 entity;
    private final boolean isContinue;
    @NotNull
    private class_243 prevPos;
    @NotNull
    private class_1937 prevWorld;

    public EntityNavigator(class_3222 player, class_1297 entity, boolean isContinue) {
        super(player);
        this.entity = Objects.requireNonNull(entity);
        this.isContinue = isContinue;
        this.prevPos = entity.method_33571();
        this.prevWorld = FetcherUtils.getWorld(entity);
    }

    @Override
    public void tick() {
        class_2561 text;
        if (this.isFailure()) {
            MessageUtils.sendMessageToHud((class_1657)this.player, TextBuilder.translate("carpet.commands.navigate.hud.target_death", new Object[0]));
            this.clear();
            return;
        }
        class_1937 world = FetcherUtils.getWorld(this.entity);
        if (FetcherUtils.getWorld(this.player).equals(world)) {
            class_2561 in = TextBuilder.translate("carpet.commands.navigate.hud.in", this.entity.method_5477(), TextProvider.simpleBlockPos(this.entity.method_24515()));
            int distance = MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.entity.method_24515());
            class_243 eyePos = this.entity.method_33571();
            text = this.getHUDText(eyePos, in, distance);
        } else {
            text = TextBuilder.translate("carpet.commands.navigate.hud.in", this.entity.method_5477(), TextBuilder.combineAll(TextProvider.dimension(FetcherUtils.getWorld(this.entity)), TextProvider.simpleBlockPos(this.entity.method_24515())));
        }
        MessageUtils.sendMessageToHud((class_1657)this.player, text);
        this.syncWaypoint(false);
        this.prevPos = this.entity.method_33571();
        this.prevWorld = FetcherUtils.getWorld(this.entity);
    }

    @Override
    protected WaypointUpdateS2CPacket createPacket() {
        return new WaypointUpdateS2CPacket(this.entity.method_33571(), FetcherUtils.getWorld(this.entity));
    }

    @Override
    protected boolean updateRequired() {
        return !this.prevPos.equals((Object)this.entity.method_33571()) || !this.prevWorld.equals(FetcherUtils.getWorld(this.entity));
    }

    @Override
    protected boolean isArrive() {
        if (this.isContinue) {
            return false;
        }
        if (FetcherUtils.getWorld(this.player).equals(FetcherUtils.getWorld(this.entity)) && MathUtils.getBlockDistance(this.player.method_24515(), this.entity.method_24515()) <= 8.0) {
            MessageUtils.sendMessageToHud((class_1657)this.player, TextBuilder.translate("carpet.commands.navigate.hud.reach", new Object[0]));
            this.clear();
            return true;
        }
        return false;
    }

    private boolean isFailure() {
        class_1297 class_12972 = this.entity;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3222.class, class_1309.class, class_1297.class}, (Object)class_12973, n)) {
            case 0 -> {
                class_3222 corpse = (class_3222)class_12973;
                if (corpse.method_31481()) {
                    UUID uuid = corpse.method_5667();
                    Optional<class_3222> optional = GenericUtils.getPlayer(this.server, uuid);
                    if (optional.isEmpty()) {
                        yield true;
                    }
                    this.entity = (class_1297)optional.get();
                }
                yield false;
            }
            case 1 -> {
                class_1309 corpse = (class_1309)class_12973;
                if (corpse.method_29504() || this.isFailure((class_1297)corpse)) {
                    yield true;
                }
                yield false;
            }
            default -> {
                class_1297 corpse = class_12973;
                yield this.isFailure(corpse);
            }
        };
    }

    private boolean isFailure(class_1297 corpse) {
        class_1297.class_5529 removalReason = corpse.method_35049();
        if (removalReason != null && removalReason.method_31486()) {
            return true;
        }
        UUID uuid = corpse.method_5667();
        Optional<class_1297> optional = GenericUtils.getEntity(this.server, uuid);
        optional.ifPresent(value -> {
            this.entity = value;
        });
        return false;
    }

    @Override
    public EntityNavigator copy(class_3222 player) {
        return new EntityNavigator(player, this.entity, this.isContinue);
    }
}

