/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_8915;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.util.MessageUtils;

public abstract class ServerTask
implements Thread.UncaughtExceptionHandler {
    protected final class_2168 source;
    private long executionTime;
    private long tickTaskStartTime = -1L;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() + 1, Runtime.getRuntime().availableProcessors() + 1, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), this::ofPlatformThread);
    private boolean remove = false;

    public ServerTask(class_2168 source) {
        this.source = source;
        this.executor.allowCoreThreadTimeOut(true);
    }

    protected abstract void tick();

    protected abstract boolean stopped();

    public final boolean execute(class_8915 tickManager) {
        if (this.remove) {
            return true;
        }
        try {
            if (tickManager.method_54751() || this.constantSpeed()) {
                this.tickTaskStartTime = System.currentTimeMillis();
                this.tick();
                this.executionTime += this.getTickExecutionTime();
                this.tickTaskStartTime = -1L;
                return this.stopped();
            }
            return false;
        }
        catch (TaskExecutionException e) {
            e.disposal();
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.error("{} encountered an unexpected error while executing the task", (Object)this.getLogName(), (Object)e);
        }
        return true;
    }

    protected void checkTimeout() {
        long time = this.getMaxExecutionTime();
        if (time == -1L) {
            return;
        }
        if (this.getExecutionTime() > time) {
            throw new TaskExecutionException(this::timeoutHandler);
        }
    }

    protected long getExecutionTime() {
        if (this.tickTaskStartTime == -1L) {
            return this.executionTime;
        }
        return this.executionTime + this.getTickExecutionTime();
    }

    private long getTickExecutionTime() {
        if (this.tickTaskStartTime == -1L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.tickTaskStartTime;
    }

    protected long getMaxExecutionTime() {
        return -1L;
    }

    protected long getMaxTimeSlice() {
        return -1L;
    }

    protected boolean isTimeRemaining() {
        long slice = this.getMaxTimeSlice();
        if (slice == -1L) {
            return true;
        }
        return this.getTickExecutionTime() < slice;
    }

    protected boolean isTimeExpired() {
        return !this.isTimeRemaining();
    }

    protected void timeoutHandler() {
        MessageUtils.sendErrorMessage(this.source, "carpet.command.task.timeout", new Object[0]);
    }

    public String getLogName() {
        return this.getClass().getSimpleName();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean constantSpeed() {
        return true;
    }

    public void markRemove() {
        this.remove = true;
    }

    protected void submit(Runnable task) {
        this.executor.submit(task);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        CarpetOrgAddition.LOGGER.warn("An unexpected error occurred: ", e);
    }

    private Thread ofPlatformThread(Runnable runnable) {
        return Thread.ofPlatform().daemon().name(this.getClass().getSimpleName() + "-Thread").uncaughtExceptionHandler(this).unstarted(runnable);
    }
}

