/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule.validator;

import carpet.api.settings.CarpetRule;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.carpetorgaddition.rule.RuleUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.jetbrains.annotations.NotNull;

public interface Validator<T> {
    public boolean validate(T var1);

    @NotNull
    public class_2561 errorMessage();

    default public void notifyFailure(class_2168 source, CarpetRule<T> currentRule, String providedValue) {
        class_2561 name = RuleUtils.simpleTranslationName(currentRule);
        MessageUtils.sendErrorMessage(source, "carpet.rule.validate.invalid_value", name, providedValue);
        MessageUtils.sendErrorMessage(source, this.errorMessage());
    }

    public static <T> Validator<T> of(final Predicate<T> predicate, final Supplier<class_2561> supplier) {
        return new Validator<T>(){

            @Override
            public boolean validate(T newValue) {
                return predicate.test(newValue);
            }

            @Override
            @NotNull
            public class_2561 errorMessage() {
                return (class_2561)supplier.get();
            }
        };
    }
}

