/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.logger;

import java.util.HashMap;
import org.carpetorgaddition.client.renderer.WorldRendererManager;
import org.carpetorgaddition.client.renderer.beaconbox.BeaconBoxRenderer;
import org.carpetorgaddition.client.renderer.villagerpoi.VillagerPoiRenderer;
import org.carpetorgaddition.network.s2c.LoggerUpdateS2CPacket;

public class ClientLogger {
    private static final HashMap<String, String> subscriptions = new HashMap();

    private static void put(String logger, String option) {
        subscriptions.put(logger, option);
    }

    private static void remove(String logger) {
        subscriptions.remove(logger);
        ClientLogger.onRemove(logger);
    }

    public static void onPacketReceive(LoggerUpdateS2CPacket packet) {
        if (packet.isRemove()) {
            ClientLogger.remove(packet.logName());
        } else {
            ClientLogger.put(packet.logName(), packet.option());
        }
    }

    private static void onRemove(String logger) {
        switch (logger) {
            case "beaconRange": {
                WorldRendererManager.remove(BeaconBoxRenderer.class);
                break;
            }
            case "villager": {
                WorldRendererManager.remove(VillagerPoiRenderer.class);
                break;
            }
        }
    }
}

