/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.config.CustomCommandConfig;

public abstract class AbstractCommand {
    public final void register() {
        String[] commands = this.getCustomNames();
        if (commands.length < 1) {
            CarpetOrgAddition.LOGGER.warn("{} command [/{}] cannot be registered with a custom name. The default name is being used instead.", (Object)this.getEnvironment(), (Object)this.getDefaultName());
            this.register(this.getDefaultName());
        } else {
            for (String name : commands) {
                this.register(name);
            }
        }
    }

    protected abstract String getEnvironment();

    public abstract void register(String var1);

    public String[] getCustomNames() {
        return CustomCommandConfig.getInstance().getCommand(this.getDefaultName());
    }

    public String getAvailableName() {
        return this.getCustomNames()[0];
    }

    public abstract String getDefaultName();
}

