/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.rule;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.mixin.rule.LivingEntityMixin;
import org.carpetorgaddition.rule.RuleUtils;
import org.carpetorgaddition.util.CommandUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin {
    @Unique
    private final class_1657 thisPlayer = (class_1657)this;

    protected PlayerEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1702 method_7344();

    @Shadow
    public abstract boolean method_7325();

    @Inject(method={"canConsume"}, at={@At(value="HEAD")}, cancellable=true)
    private void canEat(boolean ignoreHunger, CallbackInfoReturnable<Boolean> cir) {
        if (CarpetOrgAdditionSettings.healthNotFullCanEat && (double)this.thisPlayer.method_6032() < (double)this.thisPlayer.method_6063() - 0.3 && this.method_7344().method_7589() <= 5.0f) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void interact(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (this.method_7325()) {
            return;
        }
        switch (CarpetOrgAdditionSettings.quickSettingFakePlayerCraft) {
            case FALSE: {
                break;
            }
            case SNEAKING: {
                if (!this.thisPlayer.method_5715()) break;
            }
            case TRUE: {
                if (this.openQuickCraftGui(entity)) {
                    return;
                }
                cir.setReturnValue((Object)class_1269.field_5812);
            }
        }
    }

    @Unique
    private boolean openQuickCraftGui(class_1297 entity) {
        Optional<String> optional = this.getOpenQuickCraftGuiCommand(this.thisPlayer);
        if (optional.isEmpty()) {
            return true;
        }
        if (entity instanceof EntityPlayerMPFake) {
            class_3222 player;
            boolean hasPermission;
            EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)entity;
            class_1657 class_16572 = this.thisPlayer;
            if (class_16572 instanceof class_3222 && (hasPermission = CommandHelper.canUseCommand((class_2168)(player = (class_3222)class_16572).method_64396(), (Object)CarpetOrgAdditionSettings.commandPlayerAction))) {
                CommandUtils.execute(player, optional.get().formatted(fakePlayer.method_5477().getString()));
            }
        }
        return false;
    }

    @Unique
    private Optional<String> getOpenQuickCraftGuiCommand(class_1657 player) {
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7960()) {
            return Optional.empty();
        }
        if (itemStack.method_31574(class_1802.field_8465)) {
            return Optional.of("/playerAction %s craft gui");
        }
        if (itemStack.method_31574(class_1802.field_16305)) {
            return Optional.of("/playerAction %s stonecutting gui");
        }
        return Optional.empty();
    }

    @Inject(method={"getBlockInteractionRange"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBlockInteractionRange(CallbackInfoReturnable<Double> cir) {
        if (this.thisPlayer.method_37908().field_9236 && !CarpetOrgAdditionSettings.maxBlockPlaceDistanceSyncClient) {
            return;
        }
        if (RuleUtils.isDefaultDistance()) {
            return;
        }
        cir.setReturnValue((Object)RuleUtils.getPlayerMaxInteractionDistance());
    }

    @Inject(method={"getEntityInteractionRange"}, at={@At(value="HEAD")}, cancellable=true)
    private void getEntityInteractionRange(CallbackInfoReturnable<Double> cir) {
        if (CarpetOrgAdditionSettings.maxBlockPlaceDistanceReferToEntity) {
            cir.setReturnValue((Object)RuleUtils.getPlayerMaxInteractionDistance());
        }
    }

    @WrapOperation(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V")})
    private void drop(class_1661 inventory, Operation<Void> original) {
        if (CarpetOrgAdditionSettings.playerDropsNotDespawning) {
            for (List list : ImmutableList.of((Object)inventory.field_7547, (Object)inventory.field_7548, (Object)inventory.field_7544)) {
                for (int i = 0; i < list.size(); ++i) {
                    class_1799 itemStack = (class_1799)list.get(i);
                    if (itemStack.method_7960()) continue;
                    class_1542 itemEntity = inventory.field_7546.method_7329(itemStack, true, false);
                    list.set(i, class_1799.field_8037);
                    if (itemEntity == null) continue;
                    itemEntity.method_35190();
                }
            }
        } else {
            original.call(new Object[]{inventory});
        }
    }

    @Inject(method={"getBlockBreakingSpeed"}, at={@At(value="HEAD")})
    private void getBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> cir) {
        if (CarpetOrgAdditionSettings.applyToolEffectsImmediately) {
            this.onPlayerBreakBlock();
        }
    }
}

