/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.express;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.periodic.express.ExpressManager;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.provider.CommandProvider;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.Counter;
import org.carpetorgaddition.util.wheel.WorldFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Express
implements Comparable<Express> {
    private final String sender;
    private final String recipient;
    private final class_1799 express;
    private boolean cancel = false;
    private final int id;
    private final MinecraftServer server;
    private final LocalDateTime time;
    private final WorldFormat worldFormat;
    public static final String EXPRESS = "express";

    public Express(MinecraftServer server, class_3222 sender, class_3222 recipient, int id) throws CommandSyntaxException {
        this.server = server;
        this.sender = sender.method_5477().getString();
        this.recipient = recipient.method_5477().getString();
        class_1799 mainHandStack = sender.method_6047();
        if (mainHandStack.method_7960()) {
            class_1799 offHandStack = sender.method_6079();
            if (offHandStack.method_7960()) {
                throw CommandUtils.createException("carpet.commands.mail.structure", new Object[0]);
            }
            this.express = offHandStack.method_51164();
        } else {
            this.express = mainHandStack.method_51164();
        }
        this.id = id;
        this.time = LocalDateTime.now();
        this.worldFormat = new WorldFormat(server, EXPRESS, new String[0]);
    }

    public Express(MinecraftServer server, class_3222 sender, class_3222 recipient, class_1799 itemStack, int id) {
        this.server = server;
        this.sender = sender.method_5477().getString();
        this.recipient = recipient.method_5477().getString();
        this.express = itemStack;
        this.id = id;
        this.time = LocalDateTime.now();
        this.worldFormat = new WorldFormat(server, EXPRESS, new String[0]);
    }

    private Express(MinecraftServer server, String sender, String recipient, class_1799 express, int id, LocalDateTime time) {
        this.server = server;
        this.sender = sender;
        this.recipient = recipient;
        this.express = express;
        this.id = id;
        this.time = time;
        this.worldFormat = new WorldFormat(server, EXPRESS, new String[0]);
    }

    public void sending() {
        class_3324 playerManager = this.server.method_3760();
        class_3222 senderPlayer = playerManager.method_14566(this.sender);
        class_3222 recipientPlayer = playerManager.method_14566(this.recipient);
        if (senderPlayer == null) {
            CarpetOrgAddition.LOGGER.error("\u5feb\u9012\u7531\u4e0d\u5b58\u5728\u7684\u73a9\u5bb6\u53d1\u51fa");
            return;
        }
        if (recipientPlayer == null) {
            CarpetOrgAddition.LOGGER.error("\u5411\u4e0d\u5b58\u5728\u7684\u73a9\u5bb6\u53d1\u9001\u5feb\u9012");
            return;
        }
        class_5250 cancelText = TextProvider.clickRun(CommandProvider.cancelExpress(this.getId()));
        Object[] senderArray = new Object[]{recipientPlayer.method_5476(), this.express.method_7947(), this.express.method_7954(), cancelText};
        MessageUtils.sendMessage(senderPlayer, (class_2561)TextUtils.translate("carpet.commands.mail.sending.sender", senderArray));
        class_5250 receiveText = TextProvider.clickRun(CommandProvider.receiveExpress(this.getId()));
        Object[] recipientArray = new Object[]{senderPlayer.method_5476(), this.express.method_7947(), this.express.method_7954(), receiveText};
        MessageUtils.sendMessage(recipientPlayer, (class_2561)TextUtils.translate("carpet.commands.mail.sending.recipient", recipientArray));
        Express.playXpOrbPickupSound(recipientPlayer);
        CarpetOrgAddition.LOGGER.info("{}\u5411{}\u53d1\u9001\u4e86{}\u4e2a{}", new Object[]{this.sender, this.recipient, this.express.method_7947(), this.express.method_7964().getString()});
    }

    public void receive() throws IOException {
        class_3324 playerManager = this.server.method_3760();
        class_3222 player = playerManager.method_14566(this.recipient);
        if (player == null) {
            CarpetOrgAddition.LOGGER.error("\u63a5\u6536\u5feb\u9012\u7684\u73a9\u5bb6\u4e0d\u5b58\u5728");
            return;
        }
        if (this.cancel) {
            MessageUtils.sendMessage(player, (class_2561)TextUtils.translate("carpet.commands.mail.receive.cancel", new Object[0]));
            return;
        }
        int count = this.express.method_7947();
        class_1799 copy = this.express.method_7972();
        Counter<class_1792> counter = new Counter<class_1792>();
        switch (this.insertStack(player).ordinal()) {
            case 0: {
                MessageUtils.sendMessage(player, (class_2561)TextUtils.translate("carpet.commands.mail.receive.success", count, copy.method_7954()));
                counter.add(copy.method_7909(), count);
                Supplier<class_2561> message = () -> ExpressManager.getReceiveNotice(player, counter);
                this.ifItExistsSendIt(this.sender, message);
                Express.playItemPickupSound(player);
                break;
            }
            case 1: {
                int surplusCount = this.express.method_7947();
                MessageUtils.sendMessage(player, (class_2561)TextUtils.translate("carpet.commands.mail.receive.partial_reception", count - surplusCount, surplusCount));
                counter.add(copy.method_7909(), count - surplusCount);
                Supplier<class_2561> message = () -> ExpressManager.getReceiveNotice(player, counter);
                this.ifItExistsSendIt(this.sender, message);
                Express.playItemPickupSound(player);
                break;
            }
            case 2: {
                MessageUtils.sendMessage(player, (class_2561)TextUtils.translate("carpet.commands.mail.receive.insufficient_capacity", new Object[0]));
            }
        }
    }

    public void cancel() throws IOException {
        class_3324 playerManager = this.server.method_3760();
        class_3222 player = playerManager.method_14566(this.sender);
        if (player == null) {
            CarpetOrgAddition.LOGGER.error("\u64a4\u56de\u5feb\u9012\u7684\u73a9\u5bb6\u4e0d\u5b58\u5728");
            return;
        }
        int count = this.express.method_7947();
        class_1799 copy = this.express.method_7972();
        switch (this.insertStack(player).ordinal()) {
            case 0: {
                MessageUtils.sendMessage(player, (class_2561)TextUtils.translate("carpet.commands.mail.cancel.success", count, copy.method_7954()));
                Express.playItemPickupSound(player);
                break;
            }
            case 1: {
                int surplusCount = this.express.method_7947();
                MessageUtils.sendMessage(player, (class_2561)TextUtils.translate("carpet.commands.mail.cancel.partial_reception", count - surplusCount, surplusCount));
                Express.playItemPickupSound(player);
                break;
            }
            case 2: {
                MessageUtils.sendMessage(player, (class_2561)TextUtils.translate("carpet.commands.mail.cancel.insufficient_capacity", new Object[0]));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Supplier<class_2561> message = () -> TextUtils.toGrayItalic(TextUtils.translate("carpet.commands.mail.cancel.notice", player.method_5476()));
        this.ifItExistsSendIt(this.recipient, message);
        this.cancel = true;
    }

    public static void playItemPickupSound(class_3222 player) {
        WorldUtils.playSound(player, class_3417.field_15197, class_3419.field_15248);
    }

    public static void playXpOrbPickupSound(class_3222 recipientPlayer) {
        WorldUtils.playSound(recipientPlayer, class_3417.field_14627, class_3419.field_15248);
    }

    public InsertResult receiveEach() throws IOException {
        class_3222 player = this.server.method_3760().method_14566(this.recipient);
        if (player == null) {
            CarpetOrgAddition.LOGGER.error("\u627e\u4e0d\u5230\u63a5\u6536\u5feb\u9012\u7684\u73a9\u5bb6\uff0c\u6b63\u5728\u505c\u6b62\u63a5\u6536");
            throw new NullPointerException();
        }
        return this.insertStack(player);
    }

    public InsertResult cancelEach() throws IOException {
        class_3222 player = this.server.method_3760().method_14566(this.sender);
        if (player == null) {
            CarpetOrgAddition.LOGGER.error("\u627e\u4e0d\u5230\u64a4\u56de\u5feb\u9012\u7684\u73a9\u5bb6\uff0c\u6b63\u5728\u505c\u6b62\u64a4\u56de");
            throw new NullPointerException();
        }
        return this.insertStack(player);
    }

    private InsertResult insertStack(class_3222 player) throws IOException {
        int count = this.express.method_7947();
        player.method_31548().method_7394(this.express);
        if (count == this.express.method_7947()) {
            return InsertResult.FAIL;
        }
        if (this.express.method_7960()) {
            this.delete();
            return InsertResult.COMPLETE;
        }
        this.save();
        return InsertResult.PART;
    }

    private void ifItExistsSendIt(String playerName, Supplier<class_2561> message) {
        class_3222 player = this.server.method_3760().method_14566(playerName);
        if (player == null) {
            return;
        }
        MessageUtils.sendMessage(player, message.get());
    }

    public void checkRecipientPermission() {
        class_3324 playerManager = this.server.method_3760();
        class_3222 recipientPlayer = playerManager.method_14566(this.recipient);
        if (recipientPlayer == null) {
            return;
        }
        class_3222 senderPlayer = playerManager.method_14566(this.sender);
        Express.checkRecipientPermission(senderPlayer, recipientPlayer);
    }

    public static void checkRecipientPermission(@Nullable class_3222 senderPlayer, class_3222 recipientPlayer) {
        if (CommandHelper.canUseCommand((class_2168)recipientPlayer.method_64396(), (Object)CarpetOrgAdditionSettings.commandMail)) {
            return;
        }
        if (senderPlayer == null) {
            return;
        }
        class_5250 message = TextUtils.toGrayItalic(TextUtils.translate("carpet.commands.mail.sending.permission", new Object[0]));
        MessageUtils.sendMessage(senderPlayer, (class_2561)message);
    }

    public void save() throws IOException {
        class_2507.method_10630((class_2487)this.writeNbt(this.server), (Path)this.worldFormat.file(this.getId() + ".nbt").toPath());
    }

    public void delete() {
        File file = this.worldFormat.file(this.getId() + ".nbt");
        if (file.delete()) {
            return;
        }
        CarpetOrgAddition.LOGGER.warn("\u672a\u80fd\u6210\u529f\u5220\u9664\u540d\u4e3a{}\u7684\u6587\u4ef6", (Object)file);
    }

    public boolean isComplete() {
        return this.express.method_7960();
    }

    public class_2487 writeNbt(MinecraftServer server) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("sender", this.sender);
        nbt.method_10582("recipient", this.recipient);
        nbt.method_10556("cancel", this.cancel);
        nbt.method_10569("id", this.id);
        int[] args = new int[]{this.time.getYear(), this.time.getMonthValue(), this.time.getDayOfMonth(), this.time.getHour(), this.time.getMinute(), this.time.getSecond()};
        nbt.method_10539("time", args);
        nbt.method_10566("item", this.express.method_57376((class_7225.class_7874)server.method_30611(), (class_2520)new class_2487()));
        nbt.method_10569("data_version", 1);
        return nbt;
    }

    public static Express readNbt(MinecraftServer server, class_2487 nbt) {
        String sender = nbt.method_10558("sender");
        String recipient = nbt.method_10558("recipient");
        boolean cancel = nbt.method_10577("cancel");
        class_1799 stack = class_1799.method_57360((class_7225.class_7874)server.method_30611(), (class_2520)nbt.method_10562("item")).orElse(class_1799.field_8037);
        int id = nbt.method_10550("id");
        int[] times = nbt.method_10561("time");
        LocalDateTime localDateTime = LocalDateTime.of(times[0], times[1], times[2], times[3], times[4], times[5]);
        Express express = new Express(server, sender, recipient, stack, id, localDateTime);
        express.cancel = cancel;
        return express;
    }

    public int getId() {
        return this.id;
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public class_5250 getTime() {
        return TextUtils.translate("carpet.command.time.format", this.time.getYear(), this.time.getMonthValue(), this.time.getDayOfMonth(), this.time.getHour(), this.time.getMinute(), this.time.getSecond());
    }

    public class_1799 getExpress() {
        return this.express;
    }

    public boolean isSender(class_3222 player) {
        return Objects.equals(this.sender, player.method_5477().getString());
    }

    public boolean isRecipient(class_3222 player) {
        return Objects.equals(this.recipient, player.method_5477().getString());
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean equals(Object obj) {
        if (this.isComplete()) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Express other = (Express)obj;
            if (other.isComplete()) {
                return false;
            }
            return this.id == other.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int compareTo(@NotNull Express o) {
        return this.id - o.id;
    }

    public static enum InsertResult {
        COMPLETE,
        PART,
        FAIL;

    }
}

