/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.express;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.express.Express;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.provider.CommandProvider;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.Counter;
import org.carpetorgaddition.util.wheel.TextBuilder;
import org.carpetorgaddition.util.wheel.WorldFormat;

public class ExpressManager {
    private final TreeSet<Express> expresses = new TreeSet();
    private final WorldFormat worldFormat;
    private final MinecraftServer server;

    public ExpressManager(MinecraftServer server) {
        this.server = server;
        this.worldFormat = new WorldFormat(server, "express", new String[0]);
        for (File file : this.worldFormat.toImmutableFileList()) {
            class_2487 nbt;
            try {
                nbt = class_2507.method_10633((Path)file.toPath());
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.warn("\u4ece\u6587\u4ef6{}\u8bfb\u53d6\u5feb\u9012\u4fe1\u606f\u5931\u8d25", (Object)file, (Object)e);
                continue;
            }
            if (nbt == null) continue;
            Express express = Express.readNbt(server, nbt);
            if (express.isComplete()) {
                express.delete();
                continue;
            }
            this.expresses.add(express);
        }
    }

    public void promptToReceive(class_3222 player) {
        List<Express> list = this.expresses.stream().filter(express -> express.isRecipient(player)).filter(express -> !express.isCancel()).toList();
        if (list.isEmpty()) {
            return;
        }
        for (Express express2 : list) {
            class_5250 clickRun = TextProvider.clickRun(CommandProvider.receiveExpress(express2.getId()));
            class_1799 stack = express2.getExpress();
            MessageUtils.sendMessage(player, "carpet.commands.mail.prompt_receive", stack.method_7947(), stack.method_7954(), clickRun);
        }
    }

    public void tick() {
        this.expresses.removeIf(Express::isComplete);
    }

    public void put(Express express) throws IOException {
        this.put(express, true);
    }

    public void putNoMessage(Express express) throws IOException {
        this.put(express, false);
    }

    private void put(Express express, boolean message) throws IOException {
        if (express.getExpress().method_7960()) {
            CarpetOrgAddition.LOGGER.info("\u5c1d\u8bd5\u53d1\u9001\u4e00\u4e2a\u7a7a\u6c14\u7269\u54c1\uff0c\u5df2\u5ffd\u7565");
            return;
        }
        this.expresses.add(express);
        if (message) {
            express.sending();
            express.checkRecipientPermission();
        }
        class_2507.method_10630((class_2487)express.writeNbt(this.server), (Path)this.worldFormat.file(express.getId() + ".nbt").toPath());
    }

    public Stream<Express> stream() {
        return this.expresses.stream();
    }

    public int receiveAll(class_3222 player) throws IOException, CommandSyntaxException {
        List<Express> list = this.stream().filter(express -> express.isRecipient(player)).toList();
        if (list.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.mail.receive.all.non_existent", new Object[0]);
        }
        int total = 0;
        int receive = 0;
        HashMap hashMap = new HashMap();
        for (Express express2 : list) {
            int count = express2.getExpress().method_7947();
            class_1792 item = express2.getExpress().method_7909();
            total += count;
            Express.InsertResult each = express2.receiveEach();
            int result = switch (each) {
                default -> throw new MatchException(null, null);
                case Express.InsertResult.COMPLETE -> count;
                case Express.InsertResult.PART -> count - express2.getExpress().method_7947();
                case Express.InsertResult.FAIL -> 0;
            };
            Counter counter = (Counter)hashMap.get(express2.getSender());
            if (counter == null) {
                Counter<class_1792> value = new Counter<class_1792>();
                value.add(item, result);
                hashMap.put(express2.getSender(), value);
            } else {
                counter.add(item, result);
            }
            receive += result;
        }
        if (receive == 0) {
            MessageUtils.sendMessage(player, "carpet.commands.mail.receive.insufficient_capacity", new Object[0]);
        } else {
            if (receive == total) {
                MessageUtils.sendMessage(player, "carpet.commands.mail.receive.success", total, TextProvider.ITEM);
            } else {
                MessageUtils.sendMessage(player, "carpet.commands.mail.receive.partial_reception", receive, total - receive);
            }
            Express.playItemPickupSound(player);
            class_3324 playerManager = player.field_13995.method_3760();
            for (Map.Entry entry : hashMap.entrySet()) {
                class_5250 message = ExpressManager.getReceiveNotice(player, (Counter)entry.getValue());
                class_3222 playerEntity = playerManager.method_14566((String)entry.getKey());
                if (playerEntity == null) continue;
                MessageUtils.sendMessage(playerEntity, (class_2561)message);
            }
        }
        return receive;
    }

    public int cancelAll(class_3222 player) throws IOException, CommandSyntaxException {
        List<Express> list = this.stream().filter(express -> express.isSender(player)).toList();
        if (list.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.mail.cancel.all.non_existent", new Object[0]);
        }
        int total = 0;
        int cancel = 0;
        HashSet<String> players = new HashSet<String>();
        for (Express express2 : list) {
            players.add(express2.getRecipient());
            int count = express2.getExpress().method_7947();
            total += count;
            Express.InsertResult each = express2.cancelEach();
            cancel += (switch (each) {
                default -> throw new MatchException(null, null);
                case Express.InsertResult.COMPLETE -> count;
                case Express.InsertResult.PART -> count - express2.getExpress().method_7947();
                case Express.InsertResult.FAIL -> 0;
            });
        }
        if (cancel == 0) {
            MessageUtils.sendMessage(player, "carpet.commands.mail.cancel.insufficient_capacity", new Object[0]);
        } else {
            if (cancel == total) {
                MessageUtils.sendMessage(player, "carpet.commands.mail.cancel.success", total, TextProvider.ITEM);
            } else {
                MessageUtils.sendMessage(player, "carpet.commands.mail.cancel.partial_reception", cancel, total - cancel);
            }
            Express.playItemPickupSound(player);
            class_5250 message = TextUtils.toGrayItalic(TextUtils.translate("carpet.commands.mail.cancel.notice", player.method_5476()));
            for (String name : players) {
                class_3324 playerManager = player.field_13995.method_3760();
                class_3222 receivePlayer = playerManager.method_14566(name);
                if (receivePlayer == null) continue;
                MessageUtils.sendMessage(receivePlayer, (class_2561)message);
            }
        }
        return cancel;
    }

    public static class_5250 getReceiveNotice(class_3222 player, Counter<class_1792> counter) {
        TextBuilder builder = new TextBuilder();
        for (class_1792 item : counter) {
            builder.append((class_2561)TextUtils.appendAll(item.method_63680(), "*", counter.getCount(item)));
        }
        class_5250 translate = TextUtils.translate("carpet.commands.mail.sending.notice", player.method_5476());
        class_5250 message = TextUtils.toGrayItalic(translate);
        return TextUtils.hoverText((class_2561)message, (class_2561)builder.toParagraph());
    }

    public Optional<Express> binarySearch(int id) {
        List list = this.expresses.stream().toList();
        int left = 0;
        int right = list.size() - 1;
        while (left <= right) {
            int mid = left + right >>> 1;
            int currentId = ((Express)list.get(mid)).getId();
            if (currentId < id) {
                left = mid + 1;
                continue;
            }
            if (currentId > id) {
                right = mid - 1;
                continue;
            }
            return Optional.of((Express)list.get(mid));
        }
        return Optional.empty();
    }

    public int generateNumber() {
        if (this.expresses.isEmpty()) {
            return 1;
        }
        if (this.expresses.last().getId() == this.expresses.size()) {
            return this.expresses.size() + 1;
        }
        int number = 0;
        for (Express express : this.expresses) {
            if (++number == express.getId()) continue;
            return number;
        }
        throw new IllegalStateException();
    }
}

