/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.periodic.fakeplayer.action.StopAction;
import org.carpetorgaddition.util.GenericFetcherUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.inventory.AutoGrowInventory;

public class FakePlayerUtils {
    public static final int EMPTY_SPACE_SLOT_INDEX = -999;
    public static final int PICKUP_LEFT_CLICK = 0;
    public static final int PICKUP_RIGHT_CLICK = 1;
    public static final int THROW_Q = 0;
    public static final int THROW_CTRL_Q = 1;
    public static final int MAX_LOOP_COUNT = 1200;
    private static final boolean GCA_LOADED = FabricLoader.getInstance().isModLoaded("gca");

    private FakePlayerUtils() {
    }

    public static void dropItem(EntityPlayerMPFake player, class_1799 itemStack) {
        player.method_7329(itemStack.method_51164(), false, false);
    }

    public static void throwItem(class_1703 screenHandler, int slotIndex, EntityPlayerMPFake player) {
        screenHandler.method_7593(slotIndex, 1, class_1713.field_7795, (class_1657)player);
    }

    public static void stopAction(class_2168 source, EntityPlayerMPFake fakePlayer, String key, Object ... obj) {
        GenericFetcherUtils.getFakePlayerActionManager(fakePlayer).setAction(new StopAction(fakePlayer));
        MessageUtils.broadcastMessage(source.method_9211(), (class_2561)TextUtils.appendAll(fakePlayer.method_5476(), ": ", TextUtils.translate(key, obj)));
    }

    public static class_1799 quickMove(class_1703 screenHandler, int slotIndex, EntityPlayerMPFake player) {
        return screenHandler.method_7601((class_1657)player, slotIndex);
    }

    public static void pickupAndThrow(class_1703 screenHandler, int slotIndex, EntityPlayerMPFake player) {
        screenHandler.method_7593(slotIndex, 0, class_1713.field_7790, (class_1657)player);
        screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)player);
    }

    public static boolean withKeepPickupAndMoveItemStack(class_1703 screenHandler, int fromIndex, int toIndex, EntityPlayerMPFake player) {
        class_1799 itemStack = screenHandler.method_7611(fromIndex).method_7677();
        if (CarpetOrgAdditionSettings.fakePlayerCraftKeepItem && itemStack.method_7947() == 1 && itemStack.method_7914() > 1) {
            return false;
        }
        if (!screenHandler.method_34255().method_7960()) {
            screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)player);
        }
        screenHandler.method_7593(fromIndex, 0, class_1713.field_7790, (class_1657)player);
        if (CarpetOrgAdditionSettings.fakePlayerCraftKeepItem && screenHandler.method_34255().method_7914() > 1) {
            screenHandler.method_7593(fromIndex, 1, class_1713.field_7790, (class_1657)player);
        }
        screenHandler.method_7593(toIndex, 0, class_1713.field_7790, (class_1657)player);
        return true;
    }

    public static void pickupAndMoveItemStack(class_1703 screenHandler, int fromIndex, int toIndex, EntityPlayerMPFake player) {
        if (!screenHandler.method_34255().method_7960()) {
            screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)player);
        }
        screenHandler.method_7593(fromIndex, 0, class_1713.field_7790, (class_1657)player);
        screenHandler.method_7593(toIndex, 0, class_1713.field_7790, (class_1657)player);
    }

    public static void pickupAndMoveHalfItemStack(class_1703 screenHandler, int fromIndex, int toIndex, EntityPlayerMPFake player) {
        if (!screenHandler.method_34255().method_7960()) {
            screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)player);
        }
        screenHandler.method_7593(fromIndex, 1, class_1713.field_7790, (class_1657)player);
        screenHandler.method_7593(toIndex, 0, class_1713.field_7790, (class_1657)player);
    }

    public static void loopThrowItem(class_1703 screenHandler, int slotIndex, EntityPlayerMPFake player) {
        InventoryUtils.assertEmptyStack(screenHandler.method_34255());
        class_1735 slot = screenHandler.method_7611(slotIndex);
        class_1792 item = slot.method_7677().method_7909();
        while (true) {
            class_1799 itemStack;
            if ((itemStack = slot.method_7677()).method_7960()) {
                return;
            }
            if (!itemStack.method_31574(item) || !slot.method_7674((class_1657)player)) break;
            screenHandler.method_7593(slotIndex, 0, class_1713.field_7795, (class_1657)player);
        }
    }

    public static void compareAndThrow(class_1703 screenHandler, int slotIndex, class_1799 itemStack, EntityPlayerMPFake player) {
        InventoryUtils.assertEmptyStack(screenHandler.method_34255());
        class_1735 slot = screenHandler.method_7611(slotIndex);
        while (slot.method_7681() && class_1799.method_31577((class_1799)itemStack, (class_1799)slot.method_7677()) && slot.method_7674((class_1657)player)) {
            screenHandler.method_7593(slotIndex, 0, class_1713.field_7795, (class_1657)player);
        }
    }

    public static void collectItem(class_1703 screenHandler, int slotIndex, AutoGrowInventory inventory, EntityPlayerMPFake fakePlayer) {
        class_1735 slot;
        InventoryUtils.assertEmptyStack(screenHandler.method_34255(), () -> "\u5149\u6807\u4e0a\u7269\u54c1\u975e\u7a7a");
        class_1792 item = screenHandler.method_7611(slotIndex).method_7677().method_7909();
        while ((slot = screenHandler.method_7611(slotIndex)).method_7681() && slot.method_7674((class_1657)fakePlayer) && item == slot.method_7677().method_7909()) {
            screenHandler.method_7593(slotIndex, 0, class_1713.field_7790, (class_1657)fakePlayer);
            inventory.addStack(screenHandler.method_34255());
            screenHandler.method_34254(class_1799.field_8037);
        }
    }

    public static void dropCursorStack(class_1703 screenHandler, EntityPlayerMPFake fakePlayer) {
        class_1799 itemStack = screenHandler.method_34255();
        if (itemStack.method_7960()) {
            return;
        }
        screenHandler.method_7593(-999, 0, class_1713.field_7790, (class_1657)fakePlayer);
    }

    public static void swapSlotItem(class_1703 screenHandler, int index1, int index2, EntityPlayerMPFake fakePlayer) {
        screenHandler.method_7593(index1, 0, class_1713.field_7790, (class_1657)fakePlayer);
        screenHandler.method_7593(index2, 0, class_1713.field_7790, (class_1657)fakePlayer);
        screenHandler.method_7593(index1, 0, class_1713.field_7790, (class_1657)fakePlayer);
    }

    public static void pickupCursorStack(class_1703 screenHandler, int index, EntityPlayerMPFake fakePlayer) {
        screenHandler.method_7593(index, 0, class_1713.field_7790, (class_1657)fakePlayer);
    }

    public static boolean isGcaItem(class_1799 itemStack) {
        if (GCA_LOADED) {
            class_9279 component = (class_9279)itemStack.method_57824(class_9334.field_49628);
            if (component == null) {
                return false;
            }
            return component.method_57461().method_10580("GcaClear") != null;
        }
        return false;
    }

    public static boolean replenishment(EntityPlayerMPFake fakePlayer, Predicate<class_1799> predicate) {
        return FakePlayerUtils.replenishment(fakePlayer, class_1268.field_5808, predicate);
    }

    public static boolean replenishment(EntityPlayerMPFake fakePlayer, class_1268 hand, Predicate<class_1799> predicate) {
        if (predicate.test(fakePlayer.method_5998(hand))) {
            return true;
        }
        class_1723 screenHandler = fakePlayer.field_7498;
        int headSlot = hand == class_1268.field_5808 ? 36 + fakePlayer.method_31548().field_7545 : 45;
        for (int i = 9; i < 45; ++i) {
            if (i == headSlot || !predicate.test(screenHandler.method_7611(i).method_7677())) continue;
            FakePlayerUtils.swapSlotItem((class_1703)screenHandler, i, headSlot, fakePlayer);
            return true;
        }
        return false;
    }

    public static void look(EntityPlayerMPFake fakePlayer, class_2350 direction) {
        EntityPlayerActionPack actionPack = ((ServerPlayerInterface)fakePlayer).getActionPack();
        actionPack.look(direction);
    }

    public static void swapHand(EntityPlayerMPFake fakePlayer) {
        class_1799 temp = fakePlayer.method_5998(class_1268.field_5810);
        fakePlayer.method_6122(class_1268.field_5810, fakePlayer.method_5998(class_1268.field_5808));
        fakePlayer.method_6122(class_1268.field_5808, temp);
    }

    public static class_5250 getWithCountHoverText(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return TextUtils.hoverText(class_2561.method_43470((String)"[A]"), (class_2561)TextUtils.appendAll(class_1802.field_8162.method_63680()), class_124.field_1063);
        }
        String capitalizeFirstLetter = FakePlayerUtils.getInitial(itemStack);
        return TextUtils.hoverText(class_2561.method_43470((String)capitalizeFirstLetter), (class_2561)TextUtils.appendAll(itemStack.method_7909().method_63680(), "*" + itemStack.method_7947()), null);
    }

    public static String getInitial(class_1799 itemStack) {
        String name = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        String[] split = name.split(":");
        int index = split.length == 1 ? 0 : 1;
        return "[" + Character.toUpperCase(split[index].charAt(0)) + "]";
    }

    public static boolean shouldStop(int craftCount) {
        if (CarpetOrgAdditionSettings.fakePlayerMaxCraftCount < 0) {
            return false;
        }
        return craftCount >= CarpetOrgAdditionSettings.fakePlayerMaxCraftCount;
    }

    public static void stopCraftAction(class_2168 source, EntityPlayerMPFake playerMPFake) {
        FakePlayerUtils.stopAction(source, playerMPFake, "carpet.commands.playerAction.craft", new Object[0]);
    }
}

