/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.BedrockAction;
import org.carpetorgaddition.periodic.fakeplayer.action.CraftingTableCraftAction;
import org.carpetorgaddition.periodic.fakeplayer.action.EmptyTheContainerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.FillTheContainerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.FishingAction;
import org.carpetorgaddition.periodic.fakeplayer.action.InventoryCraftAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ItemCategorizeAction;
import org.carpetorgaddition.periodic.fakeplayer.action.PlantAction;
import org.carpetorgaddition.periodic.fakeplayer.action.RenameAction;
import org.carpetorgaddition.periodic.fakeplayer.action.StonecuttingAction;
import org.carpetorgaddition.periodic.fakeplayer.action.StopAction;
import org.carpetorgaddition.periodic.fakeplayer.action.TradeAction;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;

public enum ActionSerializeType {
    STOP(json -> new StopAction(null)),
    CATEGORIZE(json -> {
        String item = json.get("item").getAsString();
        ItemStackPredicate predicate = ItemStackPredicate.parse(item);
        JsonArray thisVecArray = json.get("thisVec").getAsJsonArray();
        class_243 thisVec = new class_243(thisVecArray.get(0).getAsDouble(), thisVecArray.get(1).getAsDouble(), thisVecArray.get(2).getAsDouble());
        JsonArray otherVecArray = json.get("otherVec").getAsJsonArray();
        class_243 otherVec = new class_243(otherVecArray.get(0).getAsDouble(), otherVecArray.get(1).getAsDouble(), otherVecArray.get(2).getAsDouble());
        return new ItemCategorizeAction(null, predicate, thisVec, otherVec);
    }),
    EMPTY_THE_CONTAINER(json -> {
        String item = json.get("item").getAsString();
        ItemStackPredicate predicate = ItemStackPredicate.parse(item);
        return new EmptyTheContainerAction(null, predicate);
    }),
    FILL_THE_CONTAINER(json -> {
        boolean dropOther = !json.has("dropOther") || json.get("dropOther").getAsBoolean();
        String item = json.get("item").getAsString();
        ItemStackPredicate predicate = ItemStackPredicate.parse(item);
        return new FillTheContainerAction(null, predicate, dropOther);
    }),
    CRAFTING_TABLE_CRAFT(json -> {
        ItemStackPredicate[] predicates = new ItemStackPredicate[9];
        for (int i = 0; i < predicates.length; ++i) {
            String item = json.get(String.valueOf(i)).getAsString();
            predicates[i] = ItemStackPredicate.parse(item);
        }
        return new CraftingTableCraftAction(null, predicates);
    }),
    INVENTORY_CRAFT(json -> {
        ItemStackPredicate[] predicates = new ItemStackPredicate[4];
        for (int i = 0; i < predicates.length; ++i) {
            String item = json.get(String.valueOf(i)).getAsString();
            predicates[i] = ItemStackPredicate.parse(item);
        }
        return new InventoryCraftAction(null, predicates);
    }),
    RENAME(json -> {
        class_1792 item = ItemStackPredicate.stringAsItem(json.get("item").getAsString());
        String newName = json.get("new_name").getAsString();
        return new RenameAction(null, item, newName);
    }),
    STONECUTTING(json -> {
        class_1792 item = ItemStackPredicate.stringAsItem(json.get("item").getAsString());
        int index = json.get("button").getAsInt();
        return new StonecuttingAction(null, item, index);
    }),
    TRADE(json -> {
        int index = json.get("index").getAsInt();
        boolean voidTrade = json.get("void_trade").getAsBoolean();
        return new TradeAction(null, index, voidTrade);
    }),
    FISHING(json -> new FishingAction(null)),
    PLANT(json -> new PlantAction(null)),
    BEDROCK(json -> {
        JsonArray from = json.getAsJsonArray("from");
        JsonArray to = json.getAsJsonArray("to");
        class_2338 minPos = new class_2338(from.get(0).getAsInt(), from.get(1).getAsInt(), from.get(2).getAsInt());
        class_2338 maxPos = new class_2338(to.get(0).getAsInt(), to.get(1).getAsInt(), to.get(2).getAsInt());
        return new BedrockAction(null, minPos, maxPos);
    });

    private final String serializedName;
    private final Function<JsonObject, AbstractPlayerAction> deserializer;

    private ActionSerializeType(Function<JsonObject, AbstractPlayerAction> deserializer) {
        this.deserializer = deserializer;
        this.serializedName = this.name().toLowerCase(Locale.ROOT);
    }

    public AbstractPlayerAction deserialize(JsonObject json) {
        return this.deserializer.apply(json);
    }

    public String getSerializedName() {
        return this.serializedName;
    }
}

