/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2665;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.BlockExcavator;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.periodic.fakeplayer.action.bedrock.BedrockBreakingContext;
import org.carpetorgaddition.periodic.fakeplayer.action.bedrock.BreakingState;
import org.carpetorgaddition.periodic.fakeplayer.action.bedrock.StepResult;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.util.GenericFetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.wheel.SelectionArea;
import org.jetbrains.annotations.NotNull;

public class BedrockAction
extends AbstractPlayerAction
implements Iterable<BedrockBreakingContext> {
    private final LinkedHashSet<BedrockBreakingContext> contexts = new LinkedHashSet();
    private final SelectionArea selectionArea;
    private BedrockBreakingContext currentContext;

    public BedrockAction(EntityPlayerMPFake fakePlayer, class_2338 from, class_2338 to) {
        super(fakePlayer);
        this.selectionArea = new SelectionArea(from, to);
    }

    @Override
    public void tick() {
        if (this.tickCurrent()) {
            return;
        }
        class_1937 world = this.fakePlayer.method_37908();
        this.removeIf(context -> {
            if (context.getState() == BreakingState.COMPLETE) {
                return true;
            }
            if (world.method_8320(context.getBedrockPos()).method_27852(class_2246.field_9987)) {
                return !this.fakePlayer.method_56093(context.getBedrockPos(), 0.0);
            }
            return context.getState() != BreakingState.CLEAN_PISTON;
        });
        double range = this.fakePlayer.method_55754();
        class_238 box = new class_238(this.fakePlayer.method_24515()).method_1014(Math.min(range, 10.0));
        SelectionArea area = new SelectionArea(box);
        for (class_2338 blockPos : area) {
            if (!world.method_8320(blockPos).method_27852(class_2246.field_9987) || !this.fakePlayer.method_56093(blockPos, 0.0) || !this.inSelectionArea(blockPos)) continue;
            this.add(new BedrockBreakingContext(blockPos));
        }
        for (BedrockBreakingContext context2 : this) {
            if (context2 == this.currentContext || !this.tick(context2)) continue;
            return;
        }
    }

    private boolean tickCurrent() {
        if (this.currentContext == null) {
            return false;
        }
        if (this.contexts.contains(this.currentContext)) {
            return this.tick(this.currentContext);
        }
        this.currentContext = null;
        return false;
    }

    private boolean tick(BedrockBreakingContext context) {
        int loopCount = 0;
        block4: while (true) {
            if (++loopCount > 10) {
                throw new InfiniteLoopException();
            }
            StepResult stepResult = this.start(context);
            switch (stepResult) {
                case COMPLETION: {
                    break block4;
                }
                case TICK_COMPLETION: {
                    this.currentContext = context;
                    return true;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        return false;
    }

    private StepResult start(BedrockBreakingContext context) {
        class_2338 bedrockPos = context.getBedrockPos();
        switch (context.getState()) {
            case PLACE_THE_PISTON_FACING_UP: {
                if (this.hasMaterial()) {
                    StepResult stepResult = this.placePiston(bedrockPos);
                    if (stepResult == StepResult.CONTINUE) {
                        context.nextStep();
                        break;
                    }
                    return stepResult;
                }
                return StepResult.TICK_COMPLETION;
            }
            case PLACE_AND_ACTIVATE_THE_LEVER: {
                StepResult stepResult = this.placeAndActivateTheLever(context);
                if (stepResult != StepResult.CONTINUE) {
                    return stepResult;
                }
                context.nextStep();
                return StepResult.COMPLETION;
            }
            case PISTON_BREAK_BEDROCK: {
                StepResult stepResult = this.pistonBreakBedrock(context);
                switch (stepResult) {
                    case COMPLETION: {
                        context.nextStep();
                        return StepResult.COMPLETION;
                    }
                    case TICK_COMPLETION: {
                        return StepResult.TICK_COMPLETION;
                    }
                    case FAIL: {
                        context.fail();
                        return StepResult.COMPLETION;
                    }
                }
                throw new IllegalStateException();
            }
            case CLEAN_PISTON: {
                if (this.cleanPiston(bedrockPos.method_10084())) {
                    context.nextStep();
                    break;
                }
                return StepResult.TICK_COMPLETION;
            }
            default: {
                return StepResult.COMPLETION;
            }
        }
        return StepResult.CONTINUE;
    }

    private boolean hasMaterial() {
        int pistonCount = 0;
        int levelCount = 0;
        ArrayList list = new ArrayList(this.fakePlayer.method_31548().field_7547);
        list.addAll(this.fakePlayer.method_31548().field_7544);
        for (class_1799 itemStack : list) {
            if (itemStack.method_31574(class_1802.field_8249)) {
                pistonCount += itemStack.method_7947();
            } else if (itemStack.method_31574(class_1802.field_8865)) {
                levelCount += itemStack.method_7947();
            }
            if (pistonCount < 2 || levelCount < 1) continue;
            return true;
        }
        return false;
    }

    private StepResult placePiston(class_2338 bedrockPos) {
        class_1937 world = this.fakePlayer.method_37908();
        class_2338 up = bedrockPos.method_10086(1);
        class_2680 blockState = world.method_8320(up);
        BlockExcavator blockExcavator = GenericFetcherUtils.getBlockExcavator(this.fakePlayer);
        boolean isPiston = false;
        if (!this.isReplaceableBlock(blockState)) {
            if (blockState.method_27852(class_2246.field_10560)) {
                isPiston = true;
            } else {
                if (this.canMine(blockState, world, up)) {
                    return this.tickBreakBlock(blockExcavator, up);
                }
                return StepResult.COMPLETION;
            }
        }
        up = bedrockPos.method_10086(2);
        blockState = world.method_8320(up);
        if (isPiston && blockState.method_27852(class_2246.field_10379) && blockState.method_11654((class_2769)class_2671.field_10927) == class_2350.field_11036) {
            return StepResult.CONTINUE;
        }
        if (blockState.method_26215() || blockState.method_26223() == class_3619.field_15971) {
            if (isPiston) {
                return StepResult.CONTINUE;
            }
            if (this.placePiston(bedrockPos, class_2350.field_11036).method_23665()) {
                return StepResult.CONTINUE;
            }
            return StepResult.COMPLETION;
        }
        if (this.canMine(blockState, world, up)) {
            return this.tickBreakBlock(blockExcavator, up);
        }
        return StepResult.COMPLETION;
    }

    private boolean canMine(class_2680 blockState, class_1937 world, class_2338 blockPos) {
        if (blockState.method_26215()) {
            return true;
        }
        boolean isPiston = blockState.method_27852(class_2246.field_10560);
        if (isPiston && ((class_2350)blockState.method_11654((class_2769)class_2665.field_10927)).method_10166() != class_2350.class_2351.field_11052) {
            return true;
        }
        if (isPiston && !world.method_8320(blockPos.method_10074()).method_27852(class_2246.field_9987)) {
            return true;
        }
        if (blockState.method_27852(class_2246.field_10363)) {
            return blockState.method_11654((class_2769)class_2401.field_11007) != class_2738.field_12471;
        }
        if (isPiston || blockState.method_27852(class_2246.field_10379)) {
            return false;
        }
        return blockState.method_26214((class_1922)world, blockPos) != -1.0f && BlockExcavator.canBreak(this.fakePlayer, blockPos);
    }

    private StepResult placeAndActivateTheLever(BedrockBreakingContext context) {
        class_2338 bedrockPos = context.getBedrockPos();
        class_1937 world = this.fakePlayer.method_37908();
        class_3225 interactionManager = this.fakePlayer.field_13974;
        class_2350 direction = null;
        for (class_2350 value : MathUtils.HORIZONTAL) {
            class_2338 offset = bedrockPos.method_10093(value);
            class_2680 blockState = world.method_8320(offset);
            if (this.isReplaceableBlock(blockState)) {
                direction = value;
                continue;
            }
            BlockExcavator blockExcavator = GenericFetcherUtils.getBlockExcavator(this.fakePlayer);
            if (blockState.method_27852(class_2246.field_10363)) {
                if (blockState.method_11654((class_2769)class_2341.field_11007) != class_2738.field_12471) {
                    return this.tickBreakBlock(blockExcavator, offset);
                }
                if (bedrockPos.equals((Object)offset.method_10079((class_2350)blockState.method_11654((class_2769)class_2401.field_11177), -1))) {
                    if (context.getLeverPos() == null) {
                        context.setLeverPos(offset);
                        if (((Boolean)blockState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) continue;
                        this.interactionLever(offset);
                        continue;
                    }
                    return this.tickBreakBlock(blockExcavator, offset);
                }
                class_2338 supportBlockPos = offset.method_10079((class_2350)blockState.method_11654((class_2769)class_2401.field_11177), -1);
                if (world.method_8320(supportBlockPos).method_27852(class_2246.field_9987) && this.inSelectionArea(supportBlockPos)) continue;
                return this.tickBreakBlock(blockExcavator, offset);
            }
            if (!this.canMine(blockState, world, offset)) continue;
            return this.tickBreakBlock(blockExcavator, offset);
        }
        if (context.getLeverPos() != null) {
            return StepResult.CONTINUE;
        }
        if (direction == null) {
            return StepResult.COMPLETION;
        }
        class_2338 offset = bedrockPos.method_10093(direction);
        class_2680 blockState = world.method_8320(offset.method_10074());
        if (blockState.method_27852(class_2246.field_10560) && blockState.method_11654((class_2769)class_2665.field_10927) == class_2350.field_11036) {
            return StepResult.COMPLETION;
        }
        if (blockState.method_27852(class_2246.field_10008)) {
            return StepResult.COMPLETION;
        }
        FakePlayerUtils.replenishment(this.fakePlayer, class_1268.field_5810, stack -> stack.method_31574(class_1802.field_8865));
        FakePlayerUtils.look(this.fakePlayer, direction.method_10153());
        class_3965 hitResult = new class_3965(bedrockPos.method_46558(), direction, bedrockPos, false);
        interactionManager.method_14262((class_3222)this.fakePlayer, world, this.fakePlayer.method_6079(), class_1268.field_5810, hitResult);
        this.interactionLever(offset);
        context.setLeverPos(offset);
        return StepResult.CONTINUE;
    }

    private boolean isReplaceableBlock(class_2680 blockState) {
        if (blockState.method_26215()) {
            return true;
        }
        if (blockState.method_26164(class_3481.field_44471)) {
            if (blockState.method_27852(class_2246.field_10477)) {
                return (Integer)blockState.method_11654((class_2769)class_2488.field_11518) == 1;
            }
            return true;
        }
        return false;
    }

    private StepResult pistonBreakBedrock(BedrockBreakingContext context) {
        class_2338 bedrockPos = context.getBedrockPos();
        class_2338 up = bedrockPos.method_10084();
        class_1937 world = this.fakePlayer.method_37908();
        class_2680 blockState = world.method_8320(up);
        if (blockState.method_27852(class_2246.field_10560) && ((Boolean)blockState.method_11654((class_2769)class_2665.field_12191)).booleanValue()) {
            BlockExcavator blockExcavator = GenericFetcherUtils.getBlockExcavator(this.fakePlayer);
            this.switchTool(blockState, world, up);
            int currentTime = blockExcavator.computingRemainingMiningTime(up);
            if (currentTime == 1) {
                class_2338 leverPos = context.getLeverPos();
                class_2680 leverState = world.method_8320(leverPos);
                if (leverState.method_27852(class_2246.field_10363)) {
                    if (((Boolean)leverState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                        this.interactionLever(leverPos);
                    }
                    this.closeTheSurroundingLevers(up);
                    context.setLeverPos(null);
                    this.breakBlock(blockExcavator, up, false);
                    if (this.placePiston(bedrockPos, class_2350.field_11033).method_23665()) {
                        return StepResult.COMPLETION;
                    }
                }
                return StepResult.COMPLETION;
            }
            this.breakBlock(blockExcavator, up, false);
            return StepResult.TICK_COMPLETION;
        }
        return StepResult.FAIL;
    }

    private void closeTheSurroundingLevers(class_2338 pistonPos) {
        class_2338 down;
        class_2680 downBlockState;
        class_2338 offset;
        class_1937 world = this.fakePlayer.method_37908();
        Consumer<class_2338> consumer = blockPos -> {
            class_2680 blockState = world.method_8320(blockPos);
            if (blockState.method_26215()) {
                return;
            }
            if (blockState.method_27852(class_2246.field_10363) && ((Boolean)blockState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                this.interactionLever((class_2338)blockPos);
            }
        };
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            offset = pistonPos.method_10093(direction);
            consumer.accept(offset);
            for (class_2350 value : MathUtils.HORIZONTAL) {
                consumer.accept(offset.method_10093(value));
            }
        }
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            offset = pistonPos.method_10084().method_10093(direction);
            consumer.accept(offset);
            for (class_2350 value : MathUtils.HORIZONTAL) {
                consumer.accept(offset.method_10093(value));
            }
        }
        consumer.accept(pistonPos.method_10086(2));
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            consumer.accept(pistonPos.method_10086(2).method_10093(direction));
        }
        class_2338 up = pistonPos.method_10086(3);
        class_2680 upBlockState = world.method_8320(up);
        if (upBlockState.method_27852(class_2246.field_10363) && ((Boolean)upBlockState.method_11654((class_2769)class_2401.field_11265)).booleanValue() && upBlockState.method_11654((class_2769)class_2401.field_11007) == class_2738.field_12475) {
            this.interactionLever(up);
        }
        if ((downBlockState = world.method_8320(down = pistonPos.method_10087(2))).method_27852(class_2246.field_10363) && ((Boolean)downBlockState.method_11654((class_2769)class_2401.field_11265)).booleanValue() && downBlockState.method_11654((class_2769)class_2401.field_11007) == class_2738.field_12473) {
            this.interactionLever(down);
        }
    }

    private boolean cleanPiston(class_2338 blockPos) {
        BlockExcavator blockExcavator = GenericFetcherUtils.getBlockExcavator(this.fakePlayer);
        class_2680 blockState = this.fakePlayer.method_37908().method_8320(blockPos);
        if (blockState.method_26215()) {
            return true;
        }
        if (blockState.method_27852(class_2246.field_10008)) {
            return false;
        }
        if (blockState.method_27852(class_2246.field_10560)) {
            return this.breakBlock(blockExcavator, blockPos, true);
        }
        return true;
    }

    private StepResult tickBreakBlock(BlockExcavator blockExcavator, class_2338 blockPos) {
        return this.breakBlock(blockExcavator, blockPos, true) ? StepResult.COMPLETION : StepResult.TICK_COMPLETION;
    }

    private boolean breakBlock(BlockExcavator blockExcavator, class_2338 blockPos, boolean switchTool) {
        EntityPlayerMPFake player = blockExcavator.getPlayer();
        class_1937 world = player.method_37908();
        class_2680 blockState = world.method_8320(blockPos);
        if (switchTool) {
            this.switchTool(blockState, world, blockPos);
        }
        return blockExcavator.mining(blockPos, class_2350.field_11033, false);
    }

    private void switchTool(class_2680 blockState, class_1937 world, class_2338 blockPos) {
        boolean replenishment = FakePlayerUtils.replenishment(this.fakePlayer, itemStack -> {
            if (this.fakePlayer.method_7337()) {
                return itemStack.method_7909().method_7885(blockState, world, blockPos, (class_1657)this.fakePlayer);
            }
            if (itemStack.method_7960()) {
                return false;
            }
            if (this.isDamaged((class_1799)itemStack)) {
                return false;
            }
            return itemStack.method_7924(blockState) > 1.0f;
        });
        if (replenishment) {
            return;
        }
        FakePlayerUtils.replenishment(this.fakePlayer, itemStack -> !this.isDamaged((class_1799)itemStack));
    }

    private boolean isDamaged(class_1799 itemStack) {
        return itemStack.method_7963() && itemStack.method_7936() - itemStack.method_7919() <= 10 && EnchantmentUtils.canRepairWithXp(itemStack);
    }

    private class_1269 placePiston(class_2338 bedrockPos, class_2350 direction) {
        class_3225 interactionManager = this.fakePlayer.field_13974;
        FakePlayerUtils.look(this.fakePlayer, direction.method_10153());
        FakePlayerUtils.replenishment(this.fakePlayer, class_1268.field_5810, itemStack -> itemStack.method_31574(class_1802.field_8249));
        class_3965 hitResult = new class_3965(class_243.method_26410((class_2382)bedrockPos, (double)1.0), direction, bedrockPos.method_10084(), false);
        return interactionManager.method_14262((class_3222)this.fakePlayer, this.fakePlayer.method_37908(), this.fakePlayer.method_6079(), class_1268.field_5810, hitResult);
    }

    private void interactionLever(class_2338 leverPos) {
        class_3225 interactionManager = this.fakePlayer.field_13974;
        class_3965 hitResult = new class_3965(leverPos.method_46558(), class_2350.field_11036, leverPos, false);
        interactionManager.method_14262((class_3222)this.fakePlayer, this.fakePlayer.method_37908(), this.fakePlayer.method_6047(), class_1268.field_5808, hitResult);
    }

    public void add(BedrockBreakingContext context) {
        this.contexts.add(context);
    }

    public void removeIf(Predicate<BedrockBreakingContext> predicate) {
        this.contexts.removeIf(predicate);
    }

    public boolean inSelectionArea(class_2338 blockPos) {
        return this.selectionArea.contains(blockPos);
    }

    public boolean isEmpty() {
        return this.contexts.isEmpty();
    }

    @Override
    public ArrayList<class_5250> info() {
        return Lists.newArrayList((Object[])new class_5250[]{TextUtils.translate("carpet.commands.playerAction.info.bedrock", this.fakePlayer.method_5476())});
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        class_2338 minBlockPos = this.selectionArea.getMinBlockPos();
        JsonArray from = new JsonArray();
        from.add((Number)minBlockPos.method_10263());
        from.add((Number)minBlockPos.method_10264());
        from.add((Number)minBlockPos.method_10260());
        json.add("from", (JsonElement)from);
        class_2338 maxBlockPos = this.selectionArea.getMaxBlockPos();
        JsonArray to = new JsonArray();
        to.add((Number)maxBlockPos.method_10263());
        to.add((Number)maxBlockPos.method_10264());
        to.add((Number)maxBlockPos.method_10260());
        json.add("to", (JsonElement)to);
        return json;
    }

    @Override
    public class_5250 getDisplayName() {
        return TextUtils.translate("carpet.commands.playerAction.action.bedrock", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.BEDROCK;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    @NotNull
    public Iterator<BedrockBreakingContext> iterator() {
        return this.contexts.iterator();
    }
}

