/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.StopAction;
import org.carpetorgaddition.util.GenericFetcherUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.jetbrains.annotations.NotNull;

public class FakePlayerActionManager {
    private final EntityPlayerMPFake fakePlayer;
    @NotNull
    private AbstractPlayerAction action;

    public FakePlayerActionManager(EntityPlayerMPFake fakePlayer) {
        this.fakePlayer = fakePlayer;
        this.action = new StopAction(this.fakePlayer);
    }

    public void tick() {
        try {
            this.action.execute();
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.error("{}\u5728\u6267\u884c\u201c{}\u201d\u65f6\u9047\u5230\u610f\u5916\u9519\u8bef:", new Object[]{this.fakePlayer.method_5477().getString(), this.getAction().getClass().getSimpleName(), e});
            MessageUtils.broadcastErrorMessage(this.fakePlayer.field_13995, e, "carpet.commands.playerAction.exception.runtime", this.fakePlayer.method_5476(), this.getAction().getDisplayName());
            this.stop();
        }
    }

    public void setActionFromOldPlayer(EntityPlayerMPFake oldPlayer) {
        FakePlayerActionManager actionManager = GenericFetcherUtils.getFakePlayerActionManager(oldPlayer);
        this.setAction(actionManager.getAction());
        this.action.setFakePlayer(this.fakePlayer);
    }

    @NotNull
    public AbstractPlayerAction getAction() {
        return this.action;
    }

    public void setAction(@NotNull AbstractPlayerAction action) {
        this.action = action;
    }

    public void stop() {
        this.setAction(new StopAction(this.fakePlayer));
    }
}

