/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import carpet.api.settings.CarpetRule;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.wheel.WorldFormat;

public class RuleSelfManager {
    public static final HashMap<String, CarpetRule<?>> RULES = new HashMap();
    private final HashMap<String, HashSet<String>> disabledRules = new HashMap();
    private final File file;
    private boolean changed = false;

    public RuleSelfManager(MinecraftServer server) {
        WorldFormat worldFormat = new WorldFormat(server, null, new String[0]);
        this.file = worldFormat.file("ruleself", "json");
    }

    public boolean isEnabled(class_3222 player, String rule) {
        if (this.disabledRules.isEmpty()) {
            return true;
        }
        HashSet<String> rules = this.disabledRules.get(player.method_5477().getString());
        if (rules == null) {
            return true;
        }
        return !rules.contains(rule);
    }

    public boolean setEnabled(class_3222 player, String rule, boolean enabled) {
        boolean changed;
        String playerName = player.method_5477().getString();
        HashSet<String> rules = this.disabledRules.get(playerName);
        if (rules == null) {
            if (enabled) {
                return false;
            }
            HashSet<String> value = new HashSet<String>();
            value.add(rule);
            this.disabledRules.put(playerName, value);
            this.changed = true;
            return true;
        }
        boolean bl = changed = enabled ? rules.remove(rule) : rules.add(rule);
        if (changed) {
            this.changed = true;
        }
        if (rules.isEmpty()) {
            this.disabledRules.remove(playerName);
        }
        return changed;
    }

    public void onServerSave() {
        this.save();
    }

    public void save() {
        if (this.changed) {
            try {
                JsonObject json = new JsonObject();
                json.addProperty("data_version", (Number)1);
                JsonObject ruleSelfJson = this.createRuleSelfJson();
                json.add("ruleself", (JsonElement)ruleSelfJson);
                IOUtils.saveJson(this.file, json);
            }
            catch (IOException e) {
                IOUtils.loggerError(e);
            }
        }
    }

    private JsonObject createRuleSelfJson() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, HashSet<String>> entry : this.disabledRules.entrySet()) {
            JsonArray array = new JsonArray();
            HashSet<String> value = entry.getValue();
            for (String rule : value) {
                array.add(rule);
            }
            json.add(entry.getKey(), (JsonElement)array);
        }
        return json;
    }

    public void load() {
        if (this.file.isFile()) {
            try {
                JsonObject json = IOUtils.loadJson(this.file);
                JsonObject ruleself = json.get("ruleself").getAsJsonObject();
                for (Map.Entry entry : ruleself.entrySet()) {
                    HashSet<String> rules = new HashSet<String>();
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        rules.add(element.getAsString());
                    }
                    this.disabledRules.put((String)entry.getKey(), rules);
                }
            }
            catch (IOException e) {
                IOUtils.loggerError(e);
            }
        }
    }
}

