/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import carpet.api.settings.CarpetRule;
import carpet.utils.Translations;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_5250;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.TextUtils;
import org.jetbrains.annotations.Nullable;

public class RuleUtils {
    public static boolean canUpdateSuppression(@Nullable String blockName) {
        if ("false".equalsIgnoreCase(CarpetOrgAdditionSettings.CCEUpdateSuppression)) {
            return false;
        }
        if (blockName == null) {
            return false;
        }
        if ("true".equalsIgnoreCase(CarpetOrgAdditionSettings.CCEUpdateSuppression)) {
            return "\u66f4\u65b0\u6291\u5236\u5668".equals(blockName) || "updateSuppression".equalsIgnoreCase(blockName);
        }
        return Objects.equals(CarpetOrgAdditionSettings.CCEUpdateSuppression.toLowerCase(), blockName.toLowerCase());
    }

    public static boolean isDefaultDistance() {
        return CarpetOrgAdditionSettings.maxBlockPlaceDistance == -1.0;
    }

    public static double getPlayerMaxInteractionDistance() {
        double distance = CarpetOrgAdditionSettings.maxBlockPlaceDistance;
        if (distance < 0.0) {
            return 6.0;
        }
        return Math.min(distance, 256.0);
    }

    public static <T> T shulkerBoxStackableWrap(Supplier<T> supplier) {
        boolean changed = CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.get();
        try {
            CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.set(false);
            T t = supplier.get();
            return t;
        }
        finally {
            CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.set(changed);
        }
    }

    public static class_5250 simpleTranslationName(CarpetRule<?> rule) {
        String value = String.format("%s.rule.%s.name", rule.settingsManager().identifier(), rule.name());
        if (Translations.hasTranslation((String)value)) {
            return TextUtils.hoverText(TextUtils.translate(value, new Object[0]), rule.name());
        }
        return TextUtils.createText(rule.name());
    }
}

