/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;

public class Counter<E>
implements Iterable<E> {
    private final HashMap<E, Integer> counter = new HashMap();

    public void add(E element) {
        this.add(element, 1);
    }

    public void decrement(E element) {
        this.add(element, -1);
    }

    public void add(E element, int count) {
        Integer i = this.counter.get(element);
        this.counter.put(element, i == null ? count : i + count);
    }

    public void set(E element, int count) {
        this.counter.put(element, count);
    }

    public int getCount(E element) {
        Integer i = this.counter.get(element);
        return i == null ? 0 : i;
    }

    public int size() {
        return this.counter.size();
    }

    public boolean isEmpty() {
        return this.counter.isEmpty();
    }

    public boolean hasElement(E element) {
        return this.getCount(element) > 0;
    }

    public Stream<E> stream() {
        return this.counter.keySet().stream();
    }

    public List<class_3545<E, Integer>> sort() {
        return this.stream().sorted(Comparator.comparingInt(element -> -this.getCount(element))).map(e -> new class_3545(e, (Object)this.getCount(e))).toList();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<Map.Entry<E, Integer>> iterator;
            {
                this.iterator = Counter.this.counter.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                return this.iterator.next().getKey();
            }
        };
    }

    public String toString() {
        return this.counter.toString();
    }

    public static abstract class Wrapper<T> {
        private final T value;

        public Wrapper(T value) {
            this.value = value;
        }

        public final T getValue() {
            return this.value;
        }

        public final boolean equals(Object obj) {
            if (obj instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)obj;
                return this.valueEquals(this.value, wrapper.value);
            }
            return false;
        }

        public final int hashCode() {
            return this.valueHashCode(this.value);
        }

        public abstract boolean valueEquals(T var1, Object var2);

        public abstract int valueHashCode(T var1);

        public String toString() {
            return this.value.toString();
        }
    }
}

