/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.network.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import org.carpetorgaddition.network.codec.JsonObjectCodec;
import org.carpetorgaddition.util.GenericUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectSearchTaskCodecs {
    public static final JsonObjectCodec<ItemSearchContext> ITEM_SEARCH_CODEC = new JsonObjectCodec<ItemSearchContext>(){

        @Override
        public JsonObject encode(ItemSearchContext value) {
            JsonObject json = new JsonObject();
            json.addProperty("range", (Number)value.range);
            JsonArray array = ObjectSearchTaskCodecs.createItemArray(value.list());
            json.add("items", (JsonElement)array);
            return json;
        }

        @Override
        public ItemSearchContext decode(JsonObject json) {
            int range = json.get("range").getAsInt();
            JsonArray array = json.get("items").getAsJsonArray();
            List<class_1792> list = array.asList().stream().map(JsonElement::getAsString).map(GenericUtils::getItem).toList();
            return new ItemSearchContext(range, list);
        }
    };
    public static final JsonObjectCodec<OfflinePlayerItemSearchContext> OFFLINE_PLAYER_SEARCH_CODEC = new JsonObjectCodec<OfflinePlayerItemSearchContext>(){

        @Override
        public JsonObject encode(OfflinePlayerItemSearchContext value) {
            JsonObject json = new JsonObject();
            JsonArray array = ObjectSearchTaskCodecs.createItemArray(value.list());
            json.add("items", (JsonElement)array);
            return json;
        }

        @Override
        public OfflinePlayerItemSearchContext decode(JsonObject json) {
            List<class_1792> list = json.get("items").getAsJsonArray().asList().stream().map(JsonElement::getAsString).map(GenericUtils::getItem).toList();
            return new OfflinePlayerItemSearchContext(list);
        }
    };
    public static final JsonObjectCodec<BlockSearchContext> BLOCK_SEARCH_CODEC = new JsonObjectCodec<BlockSearchContext>(){

        @Override
        public JsonObject encode(BlockSearchContext value) {
            class_2248 block;
            String id;
            JsonObject json = new JsonObject();
            json.addProperty("range", (Number)value.range);
            JsonArray array = new JsonArray();
            List<class_2248> list = value.list;
            int len = 0;
            Iterator<class_2248> iterator = list.iterator();
            while (iterator.hasNext() && (len += (id = GenericUtils.getIdAsString(block = iterator.next())).length()) < 2000) {
                array.add(id);
            }
            json.add("blocks", (JsonElement)array);
            return json;
        }

        @Override
        public BlockSearchContext decode(JsonObject json) {
            int range = json.get("range").getAsInt();
            List<class_2248> list = json.get("blocks").getAsJsonArray().asList().stream().map(JsonElement::getAsString).map(GenericUtils::getBlock).toList();
            return new BlockSearchContext(range, list);
        }
    };
    public static final JsonObjectCodec<TradeItemSearchContext> TRADE_ITEM_SEARCH_CODEC = new JsonObjectCodec<TradeItemSearchContext>(){

        @Override
        public JsonObject encode(TradeItemSearchContext value) {
            JsonObject json = new JsonObject();
            json.addProperty("range", (Number)value.range());
            JsonArray array = ObjectSearchTaskCodecs.createItemArray(value.list());
            json.add("items", (JsonElement)array);
            return json;
        }

        @Override
        public TradeItemSearchContext decode(JsonObject json) {
            int range = json.get("range").getAsInt();
            List<class_1792> list = json.get("items").getAsJsonArray().asList().stream().map(JsonElement::getAsString).map(GenericUtils::getItem).toList();
            return new TradeItemSearchContext(range, list);
        }
    };

    @NotNull
    private static JsonArray createItemArray(List<class_1792> list) {
        class_1792 item;
        String id;
        JsonArray array = new JsonArray();
        int len = 0;
        Iterator<class_1792> iterator = list.iterator();
        while (iterator.hasNext() && (len += (id = GenericUtils.getIdAsString(item = iterator.next())).length()) < 2000) {
            array.add(id);
        }
        return array;
    }

    public record TradeItemSearchContext(int range, List<class_1792> list) {
    }

    public record BlockSearchContext(int range, List<class_2248> list) {
    }

    public record OfflinePlayerItemSearchContext(List<class_1792> list) {
    }

    public record ItemSearchContext(int range, List<class_1792> list) {
    }
}

