/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.carpetorgaddition.exception.ForceReturnException;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.BlockRegion;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.predicate.BlockStatePredicate;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class BlockSearchTask
extends ServerTask {
    protected final class_3218 world;
    private final BlockRegion blockRegion;
    protected final class_2168 source;
    protected final class_2338 sourcePos;
    private Iterator<class_2338> iterator;
    private FindState findState;
    private long startTime;
    private int tickCount;
    private final BlockStatePredicate predicate;
    private final Set<class_2338> blockPosCache = Collections.newSetFromMap(new WeakHashMap());
    private int count = 0;
    private final ArrayList<Result> results = new ArrayList();
    private final PagedCollection pagedCollection;

    public BlockSearchTask(class_3218 world, class_2338 sourcePos, BlockRegion blockRegion, class_2168 source, BlockStatePredicate predicate) {
        this.world = world;
        this.sourcePos = sourcePos;
        this.blockRegion = blockRegion;
        this.source = source;
        this.predicate = predicate;
        this.findState = FindState.SEARCH;
        this.tickCount = 0;
        PageManager pageManager = FetcherUtils.getPageManager(source.method_9211());
        this.pagedCollection = pageManager.newPagedCollection(this.source);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void tick() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void searchBlock() {
        if (this.iterator == null) {
            this.iterator = this.blockRegion.iterator();
        }
        while (this.iterator.hasNext()) {
            if (this.timeout()) {
                return;
            }
            class_2338 blockPos = this.iterator.next();
            if (this.blockPosCache.contains(blockPos)) continue;
            try {
                this.iterate(blockPos);
            }
            catch (ForceReturnException e) {
                return;
            }
        }
        this.findState = FindState.SORT;
    }

    private void iterate(class_2338 begin) {
        HashMap group = new HashMap();
        class_2338.method_49925((class_2338)begin, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, MathUtils::allDirection, blockPos -> {
            if (this.timeout()) {
                throw ForceReturnException.INSTANCE;
            }
            if (this.predicate.test((class_1937)this.world, (class_2338)blockPos) && this.blockPosCache.add((class_2338)blockPos) && this.blockRegion.contains((class_2338)blockPos)) {
                class_2248 block = this.world.method_8320(blockPos).method_26204();
                Set set = group.computeIfAbsent(block, ignore -> new HashSet());
                if (set.add(blockPos)) {
                    ++this.count;
                    if (this.count > 30000) {
                        Runnable function = () -> MessageUtils.sendErrorMessage(this.source, "carpet.commands.finder.block.too_much_blocks", this.predicate.getDisplayName());
                        throw new TaskExecutionException(function);
                    }
                }
                return class_2338.class_10384.field_55165;
            }
            return class_2338.class_10384.field_55167;
        });
        for (Map.Entry entry : group.entrySet()) {
            this.results.add(new Result((class_2248)entry.getKey(), (Set)entry.getValue()));
        }
    }

    private void sort() {
        if (this.results.isEmpty()) {
            class_2561 name = this.predicate.getDisplayName();
            MessageUtils.sendMessage(this.source, "carpet.commands.finder.block.not_found_block", name);
            this.findState = FindState.END;
            return;
        }
        this.results.sort((o1, o2) -> {
            int compare = Integer.compare(o1.set.size(), o2.set.size());
            if (compare == 0) {
                return MathUtils.compareBlockPos(this.sourcePos, o1.centerPos(), o2.centerPos());
            }
            return -compare;
        });
        this.findState = FindState.FEEDBACK;
    }

    protected void sendFeedback() {
        class_2561 name = this.predicate.getDisplayName();
        MessageUtils.sendEmptyMessage(this.source);
        MessageUtils.sendMessage(this.source, "carpet.commands.finder.block.find", this.count, name);
        this.pagedCollection.addContent(this.results);
        CommandUtils.handlingException(this.pagedCollection::print, this.source);
        this.findState = FindState.END;
    }

    private boolean timeout() {
        return System.currentTimeMillis() - this.startTime > 200L;
    }

    @Override
    public boolean stopped() {
        return this.findState == FindState.END;
    }

    private class_2561 getResultMessage(class_2248 block, Set<class_2338> set) {
        class_2338 center = MathUtils.calculateTheGeometricCenter(set);
        TextBuilder builder = TextBuilder.of("carpet.commands.finder.block.feedback", TextProvider.blockPos(center), set.size(), block.method_9518());
        return builder.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            return Objects.equals(this.source.method_44023(), ((BlockSearchTask)obj).source.method_44023());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.source.method_44023());
    }

    @Override
    public String getLogName() {
        return "\u65b9\u5757\u67e5\u627e";
    }

    public static enum FindState {
        SEARCH,
        SORT,
        FEEDBACK,
        END;

    }

    public class Result
    implements Supplier<class_2561> {
        private final class_2338 center;
        private final class_2248 block;
        private final Set<class_2338> set;

        private Result(class_2248 block, Set<class_2338> set) {
            this.center = MathUtils.calculateTheGeometricCenter(set);
            this.block = block;
            this.set = set;
        }

        @Override
        public class_2561 get() {
            return BlockSearchTask.this.getResultMessage(this.block, this.set);
        }

        public class_2338 centerPos() {
            return this.center;
        }
    }
}

