/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2293;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.task.search.BlockSearchTask;
import org.carpetorgaddition.periodic.task.search.ItemSearchTask;
import org.carpetorgaddition.periodic.task.search.MayAffectWorldEaterBlockSearchTask;
import org.carpetorgaddition.periodic.task.search.OfflinePlayerSearchTask;
import org.carpetorgaddition.periodic.task.search.TradeEnchantedBookSearchTask;
import org.carpetorgaddition.periodic.task.search.TradeItemSearchTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.BlockEntityIterator;
import org.carpetorgaddition.wheel.BlockIterator;
import org.carpetorgaddition.wheel.ItemStackPredicate;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.permission.PermissionLevel;
import org.carpetorgaddition.wheel.permission.PermissionManager;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class FinderCommand
extends AbstractServerCommand {
    public static final int MAXIMUM_STATISTICAL_COUNT = 30000;
    public static final long MAX_FIND_TIME = 200L;
    public static final int MAX_TICK_COUNT = 50;
    public static final class_2561 VILLAGER = TextBuilder.translate("entity.minecraft.villager", new Object[0]);
    public static final String TIME_OUT = "carpet.commands.finder.timeout";

    public FinderCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandFinder))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"block").requires((Predicate)PermissionManager.register("finder.block", PermissionLevel.PASS))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"blockState", (ArgumentType)class_2257.method_9653((class_7157)this.access)).executes(context -> this.blockFinder((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.blockFinder((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))).then(class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"to").then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(this::areaBlockSearch)))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"item").requires((Predicate)PermissionManager.register("finder.item", PermissionLevel.PASS))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"itemStack", (ArgumentType)class_2293.method_9801((class_7157)this.access)).executes(context -> this.searchItem((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.searchItem((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"to").then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(this::areaItemFinder))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"offline_player").requires((Predicate)PermissionManager.register("finder.item.from.offline_player", PermissionLevel.PASS))).executes(this::searchItemFromOfflinePlayer)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trade").requires((Predicate)PermissionManager.register("finder.trade", PermissionLevel.PASS))).then(class_2170.method_9247((String)"item").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"itemStack", (ArgumentType)class_2293.method_9801((class_7157)this.access)).executes(context -> this.searchTradeItem((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.searchTradeItem((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))))).then(class_2170.method_9247((String)"enchanted_book").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)this.access, (class_5321)class_7924.field_41265)).executes(context -> this.searchEnchantedBookTrade((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.searchEnchantedBookTrade((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"worldEater").requires(((Predicate<class_2168>)source -> CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION).and(PermissionManager.registerHiddenCommand("finder.worldEater", PermissionLevel.PASS)))).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(this::mayAffectWorldEater)))));
    }

    private SuggestionProvider<class_2168> suggestionDefaultDistance() {
        return (context, builder) -> class_2172.method_9253((String[])new String[]{"64", "128", "256"}, (SuggestionsBuilder)builder);
    }

    private int searchItem(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        class_2338 sourceBlockPos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        ItemSearchTask task = new ItemSearchTask((class_1937)world, predicate, new BlockEntityIterator((class_1937)world, sourceBlockPos, range), context);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int areaItemFinder(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        class_3218 world = FetcherUtils.getWorld(player);
        BlockEntityIterator blockEntityIterator = new BlockEntityIterator((class_1937)world, from, to);
        ItemSearchTask task = new ItemSearchTask((class_1937)world, predicate, blockEntityIterator, context);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int searchItemFromOfflinePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        MinecraftServer server = FetcherUtils.getServer(player);
        File[] files = server.method_27050(class_5218.field_24182).toFile().listFiles();
        if (files == null) {
            throw CommandUtils.createException("carpet.commands.finder.item.offline_player.unable_read_files", new Object[0]);
        }
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        OfflinePlayerSearchTask task = new OfflinePlayerSearchTask((class_2168)context.getSource(), predicate, player, files);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int blockFinder(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2247 argument = class_2257.method_9655(context, (String)"blockState");
        class_2338 sourceBlockPos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockIterator blockIterator = new BlockIterator((class_1937)world, sourceBlockPos, range);
        ArgumentBlockPredicate predicate = new ArgumentBlockPredicate(argument);
        BlockSearchTask task = new BlockSearchTask(world, sourceBlockPos, blockIterator, context, predicate);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int mayAffectWorldEater(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        class_2338 sourceBlockPos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockIterator blockIterator = new BlockIterator(from, to);
        BlockBlockPredicate predicate = new BlockBlockPredicate();
        MayAffectWorldEaterBlockSearchTask task = new MayAffectWorldEaterBlockSearchTask(world, sourceBlockPos, blockIterator, context, predicate);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 0;
    }

    private int areaBlockSearch(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        class_2247 argument = class_2257.method_9655(context, (String)"blockState");
        BlockIterator blockIterator = new BlockIterator(from, to);
        ArgumentBlockPredicate predicate = new ArgumentBlockPredicate(argument);
        BlockSearchTask task = new BlockSearchTask(FetcherUtils.getWorld(player), player.method_24515(), blockIterator, context, predicate);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int searchTradeItem(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        class_2338 sourcePos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockIterator area = new BlockIterator((class_1937)world, sourcePos, range);
        TradeItemSearchTask task = new TradeItemSearchTask((class_1937)world, area, sourcePos, predicate, context);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int searchEnchantedBookTrade(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_1887 enchantment = (class_1887)class_7733.method_45612(context, (String)"enchantment").comp_349();
        class_2338 sourcePos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockIterator area = new BlockIterator((class_1937)world, sourcePos, range);
        TradeEnchantedBookSearchTask task = new TradeEnchantedBookSearchTask((class_1937)world, area, sourcePos, context, enchantment);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    public static class_2561 showCount(class_1799 itemStack, int count, boolean inTheShulkerBox) {
        TextBuilder builder = new TextBuilder(TextProvider.itemCount(count, itemStack.method_7914()));
        return inTheShulkerBox ? builder.setItalic().build() : builder.build();
    }

    @Override
    public String getDefaultName() {
        return "finder";
    }

    public record ArgumentBlockPredicate(class_2247 argument) implements BlockPredicate
    {
        @Override
        public boolean test(class_3218 world, class_2338 pos) {
            return this.argument.method_35758(world, pos);
        }

        @Override
        public class_2561 getName() {
            return this.argument.method_9494().method_26204().method_9518();
        }
    }

    public static interface BlockPredicate {
        public boolean test(class_3218 var1, class_2338 var2);

        public class_2561 getName();
    }

    public static class BlockBlockPredicate
    implements BlockPredicate {
        @Override
        public boolean test(class_3218 world, class_2338 pos) {
            boolean hasWater;
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_27852(class_2246.field_9987) || blockState.method_26215() || blockState.method_26204() instanceof class_2404) {
                return false;
            }
            if (blockState.method_26223() == class_3619.field_15971) {
                return false;
            }
            if (blockState.method_26204().method_9520() > 17.0f) {
                return true;
            }
            boolean blockPiston = blockState.method_26204() instanceof class_2237 || blockState.method_26223() == class_3619.field_15972;
            boolean bl = hasWater = !blockState.method_26227().method_15769();
            if (blockPiston && hasWater) {
                return true;
            }
            return hasWater && this.canPush(world, pos);
        }

        private boolean canPush(class_3218 world, class_2338 pos) {
            for (int i = 1; i <= 8; ++i) {
                class_2680 blockState = world.method_8320(pos.method_10087(i));
                class_3619 pistonBehavior = blockState.method_26223();
                if (pistonBehavior == class_3619.field_15972) {
                    return true;
                }
                if (pistonBehavior != class_3619.field_15971) continue;
                return false;
            }
            return true;
        }

        @Override
        public class_2561 getName() {
            return TextBuilder.translate("carpet.commands.finder.may_affect_world_eater_block.name", new Object[0]);
        }
    }
}

