/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.BlockIterator;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class BlockSearchTask
extends ServerTask {
    protected final class_3218 world;
    private final BlockIterator blockIterator;
    protected final CommandContext<class_2168> context;
    private final class_2338 sourcePos;
    private Iterator<class_2338> iterator;
    private FindState findState;
    private long startTime;
    private int tickCount;
    private final FinderCommand.BlockPredicate blockPredicate;
    private final ArrayList<Result> results = new ArrayList();
    private final PagedCollection pagedCollection;

    public BlockSearchTask(class_3218 world, class_2338 sourcePos, BlockIterator blockIterator, CommandContext<class_2168> context, FinderCommand.BlockPredicate blockPredicate) {
        this.world = world;
        this.sourcePos = sourcePos;
        this.blockIterator = blockIterator;
        this.context = context;
        this.blockPredicate = blockPredicate;
        this.findState = FindState.SEARCH;
        this.tickCount = 0;
        PageManager pageManager = FetcherUtils.getPageManager(((class_2168)context.getSource()).method_9211());
        this.pagedCollection = pageManager.newPagedCollection((class_2168)this.context.getSource());
    }

    /*
     * Exception decompiling
     */
    @Override
    public void tick() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void searchBlock() {
        if (this.iterator == null) {
            this.iterator = this.blockIterator.iterator();
        }
        while (this.iterator.hasNext()) {
            int chunkZ;
            if (this.timeout()) {
                return;
            }
            class_2338 blockPos = this.iterator.next();
            int chunkX = class_4076.method_18675((int)blockPos.method_10263());
            if (!this.world.method_8393(chunkX, chunkZ = class_4076.method_18675((int)blockPos.method_10260()))) continue;
            if (this.blockPredicate.test(this.world, blockPos)) {
                this.results.add(new Result(this.sourcePos, blockPos));
            }
            if (this.results.size() <= 30000) continue;
            Runnable function = () -> MessageUtils.sendErrorMessage(this.context, "carpet.commands.finder.block.too_much_blocks", this.blockPredicate.getName());
            throw new TaskExecutionException(function);
        }
        this.findState = FindState.SORT;
    }

    private void sort() {
        if (this.results.isEmpty()) {
            class_2561 name = this.blockPredicate.getName();
            MessageUtils.sendMessage((class_2168)this.context.getSource(), "carpet.commands.finder.block.not_found_block", name);
            this.findState = FindState.END;
            return;
        }
        this.results.sort((o1, o2) -> MathUtils.compareBlockPos(this.sourcePos, o1.blockPos(), o2.blockPos()));
        this.findState = FindState.FEEDBACK;
    }

    protected void sendFeedback() {
        int count = this.results.size();
        class_2561 name = this.blockPredicate.getName();
        MessageUtils.sendEmptyMessage(this.context);
        MessageUtils.sendMessage((class_2168)this.context.getSource(), "carpet.commands.finder.block.find", count, name);
        this.pagedCollection.addContent(this.results);
        CommandUtils.handlingException(this.pagedCollection::print, this.context);
        this.findState = FindState.END;
    }

    private boolean timeout() {
        return System.currentTimeMillis() - this.startTime > 200L;
    }

    @Override
    public boolean stopped() {
        return this.findState == FindState.END;
    }

    protected class_2561 getResultMessage(class_2338 sourcteBlockPos, class_2338 blockPos) {
        return TextBuilder.translate("carpet.commands.finder.block.feedback", MathUtils.getBlockIntegerDistance(sourcteBlockPos, blockPos), TextProvider.blockPos(blockPos, class_124.field_1060));
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            return Objects.equals(((class_2168)this.context.getSource()).method_44023(), ((class_2168)((BlockSearchTask)obj).context.getSource()).method_44023());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(((class_2168)this.context.getSource()).method_44023());
    }

    @Override
    public String getLogName() {
        return "\u65b9\u5757\u67e5\u627e";
    }

    public static enum FindState {
        SEARCH,
        SORT,
        FEEDBACK,
        END;

    }

    public class Result
    implements Supplier<class_2561> {
        private final class_2338 sourcteBlockPos;
        private final class_2338 blockPos;

        private Result(class_2338 sourcteBlockPos, class_2338 blockPos) {
            this.sourcteBlockPos = sourcteBlockPos;
            this.blockPos = blockPos;
        }

        @Override
        public class_2561 get() {
            return BlockSearchTask.this.getResultMessage(this.sourcteBlockPos, this.blockPos);
        }

        public class_2338 blockPos() {
            return this.blockPos;
        }
    }
}

