/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.exception.FileOperationException;
import org.jetbrains.annotations.Contract;

public class IOUtils {
    public static final String JSON_EXTENSION = ".json";
    public static final String NBT_EXTENSION = ".nbt";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIGURE_DIRECTORY = FabricLoader.getInstance().getConfigDir().resolve(CarpetOrgAddition.MOD_NAME_LOWER_CASE);
    public static final String INVALID_FILENAME_CHARS = "\\/:*?\"<>|";
    public static final String[] WINDOWS_RESERVED_NAME = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    public static final File USERCACHE_JSON = FabricLoader.getInstance().getGameDir().resolve("usercache.json").toFile();

    private IOUtils() {
    }

    public static BufferedReader toReader(File file) throws IOException {
        return Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
    }

    public static BufferedWriter toWriter(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory: " + String.valueOf(parent));
        }
        return Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void write(File file, JsonObject json) throws IOException {
        String jsonString = GSON.toJson((Object)json, JsonObject.class);
        IOUtils.write(file, jsonString);
    }

    public static void write(File file, String content) throws IOException {
        File parent = file.getParentFile();
        if (parent == null) {
            throw new IOException("File parent directory is null: " + file.getAbsolutePath());
        }
        Files.createDirectories(parent.toPath(), new FileAttribute[0]);
        File tempFile = Files.createTempFile(parent.toPath(), IOUtils.removeExtension(file) + "-", ".tmp", new FileAttribute[0]).toFile();
        boolean hasOriginalFile = file.exists();
        File backupFile = Paths.get(file.getParent(), file.getName() + ".bak").toFile();
        try {
            IOUtils.writeStringToFile(tempFile, content);
            if (hasOriginalFile) {
                Files.deleteIfExists(backupFile.toPath());
                Files.move(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            try {
                Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                if (backupFile.exists()) {
                    Files.move(backupFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                throw e;
            }
            Files.deleteIfExists(backupFile.toPath());
        }
        catch (IOException e) {
            if (hasOriginalFile && backupFile.exists()) {
                try {
                    Files.move(backupFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException recoveryError) {
                    e.addSuppressed(recoveryError);
                }
            }
            Files.deleteIfExists(tempFile.toPath());
            throw e;
        }
    }

    private static void writeStringToFile(File file, String content) throws IOException {
        try (BufferedWriter writer = IOUtils.toWriter(file);){
            writer.write(content);
        }
    }

    public static JsonObject loadJson(File file) throws IOException {
        return IOUtils.loadJson(file, JsonObject.class);
    }

    public static <T> T loadJson(File file, Class<T> type) throws IOException {
        BufferedReader reader;
        try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
            Object object = GSON.fromJson((Reader)reader, type);
            return (T)object;
        }
    }

    public static void copyFile(File original, File copy) {
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(original));
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(copy));
            try (BufferedInputStream bufferedInputStream = input;
                 BufferedOutputStream bufferedOutputStream = output;){
                int len;
                byte[] bytes = new byte[8192];
                while ((len = input.read(bytes)) != -1) {
                    output.write(bytes, 0, len);
                }
            }
        }
        catch (IOException e) {
            throw new FileOperationException(e);
        }
    }

    public static void backupFile(File file) {
        File backup = new File(file.getParent(), "backup_" + System.currentTimeMillis() + "_" + file.getName());
        if (backup.exists()) {
            throw new IllegalStateException("The backup file already exists");
        }
        IOUtils.copyFile(file, backup);
    }

    public static boolean jsonHasElement(JsonObject json, String ... elements) {
        for (String element : elements) {
            if (json.has(element)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFileName(String fileName) {
        if (fileName.startsWith(".")) {
            return true;
        }
        int index = fileName.indexOf(".");
        String substring = (index == -1 ? fileName : fileName.substring(0, index)).toUpperCase(Locale.ROOT);
        for (String str : WINDOWS_RESERVED_NAME) {
            if (!Objects.equals(str, substring)) continue;
            return true;
        }
        for (int i = 0; i < INVALID_FILENAME_CHARS.length(); ++i) {
            char c = INVALID_FILENAME_CHARS.charAt(i);
            if (!fileName.contains(String.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    public static File configFile(String fileName) {
        return CONFIGURE_DIRECTORY.resolve(fileName).toFile();
    }

    @Contract(value="_,_,!null,_ -> !null")
    public static <T> T getJsonElement(JsonObject json, String key, T defaultValue, Class<T> type) {
        JsonElement element = json.get(key);
        if (element == null) {
            return defaultValue;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return type.cast(element.getAsBoolean());
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return type.cast(element.getAsByte());
        }
        if (type == Short.TYPE || type == Short.class) {
            return type.cast(element.getAsShort());
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return type.cast(element.getAsInt());
        }
        if (type == Long.TYPE || type == Long.class) {
            return type.cast(element.getAsLong());
        }
        if (type == Float.TYPE || type == Float.class) {
            return type.cast(Float.valueOf(element.getAsFloat()));
        }
        if (type == Double.TYPE || type == Double.class) {
            return type.cast(element.getAsDouble());
        }
        if (type == String.class) {
            return type.cast(element.getAsString());
        }
        if (JsonObject.class.isAssignableFrom(type)) {
            return type.cast(element.getAsJsonObject());
        }
        if (JsonArray.class.isAssignableFrom(type)) {
            return type.cast(element.getAsJsonArray());
        }
        throw new IllegalArgumentException();
    }

    public static <T> Optional<T> getJsonElement(JsonObject json, String key, Class<T> type) {
        return Optional.ofNullable(IOUtils.getJsonElement(json, key, null, type));
    }

    @Deprecated(forRemoval=true)
    public static String removeJsonExtension(String fileName) {
        if (fileName.endsWith(JSON_EXTENSION)) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public static String removeExtension(File file) {
        return IOUtils.removeExtension(file.getName());
    }

    public static String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public static String removeExtension(String fileName, String extension) {
        String extensionNameLowerCase;
        String fineNameLowerCase = fileName.toLowerCase(Locale.ROOT);
        if (fineNameLowerCase.endsWith(extensionNameLowerCase = ((String)(extension.startsWith(".") ? extension : "." + extension)).toLowerCase(Locale.ROOT))) {
            return IOUtils.removeExtension(fileName);
        }
        return fileName;
    }

    @Deprecated(forRemoval=true)
    public static void removeFile(File file) {
        if (file.delete()) {
            return;
        }
        throw new FileOperationException("Unable to delete file %s".formatted(file.toString()));
    }

    @Deprecated(forRemoval=true)
    public static void renameFile(File file, String name) {
        if (file.renameTo(new File(file.getParent(), name))) {
            return;
        }
        throw new FileOperationException("Unable to rename file %s".formatted(file.toString()));
    }

    public static void deprecatedFile(File file) {
        if (file.renameTo(new File(file.getParent(), "deprecated_" + System.currentTimeMillis() + "_" + file.getName()))) {
            return;
        }
        throw new FileOperationException("Unable to rename file %s".formatted(file.toString()));
    }

    public static void loggerError(IOException e) {
        CarpetOrgAddition.LOGGER.error("IO error occurred:", (Throwable)e);
    }

    public static boolean containsIdenticalFile(File directory, File file) {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files == null) {
                return false;
            }
            for (File current : files) {
                if (!IOUtils.equalsForSameNamedFiles(file, current)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsForSameNamedFiles(File file1, File file2) {
        if (Objects.equals(file1.getName(), file2.getName())) {
            return IOUtils.equals(file1, file2);
        }
        return false;
    }

    public static boolean equals(File file1, File file2) {
        if (file1.length() != file2.length()) {
            return false;
        }
        return IOUtils.equals(file1.toPath(), file2.toPath());
    }

    public static boolean equals(Path path1, Path path2) {
        try {
            return Files.mismatch(path1, path2) == -1L;
        }
        catch (IOException e) {
            return false;
        }
    }
}

