/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.WorldFormat;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;

public class RuntimeCommand
extends AbstractServerCommand {
    public RuntimeCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"memory").then(class_2170.method_9247((String)"jvm").executes(this::showJvmMemory))).then(class_2170.method_9247((String)"physical").executes(this::showPhysicalMemory))).then(class_2170.method_9247((String)"gc").executes(this::triggerGc)))).then(class_2170.method_9247((String)"server").then(class_2170.method_9247((String)"openfolder").executes(this::openFolder)))).then(class_2170.method_9247((String)"test").then(class_2170.method_9247((String)"io").then(class_2170.method_9244((String)"content", (ArgumentType)StringArgumentType.greedyString()).executes(this::writeContent)))));
    }

    private int showJvmMemory(CommandContext<class_2168> context) {
        Runtime runtime = Runtime.getRuntime();
        long usedSize = runtime.totalMemory() - runtime.freeMemory();
        class_2561 used = this.displayMemory(usedSize);
        class_2561 total = this.displayMemory(runtime.totalMemory());
        class_2561 max = this.displayMemory(runtime.maxMemory());
        MessageUtils.sendEmptyMessage(context);
        MessageUtils.sendMessage(context, "carpet.commands.runtime.memory.jvm", new Object[0]);
        MessageUtils.sendMessage(context, "carpet.commands.runtime.memory.jvm.used", used);
        MessageUtils.sendMessage(context, "carpet.commands.runtime.memory.jvm.total", total);
        MessageUtils.sendMessage(context, "carpet.commands.runtime.memory.jvm.max", max);
        return (int)usedSize;
    }

    private int showPhysicalMemory(CommandContext<class_2168> context) {
        SystemInfo info = new SystemInfo();
        GlobalMemory memory = info.getHardware().getMemory();
        long usedSize = memory.getTotal() - memory.getAvailable();
        class_2561 total = this.displayMemory(memory.getTotal());
        class_2561 used = this.displayMemory(usedSize);
        MessageUtils.sendEmptyMessage(context);
        MessageUtils.sendMessage(context, "carpet.commands.runtime.memory.physical", new Object[0]);
        MessageUtils.sendMessage(context, "carpet.commands.runtime.memory.physical.total", total);
        MessageUtils.sendMessage(context, "carpet.commands.runtime.memory.physical.used", used);
        return (int)usedSize;
    }

    private int triggerGc(CommandContext<class_2168> context) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        runtime.gc();
        long size = runtime.freeMemory() - l;
        class_2561 free = this.displayMemory(size);
        MessageUtils.sendMessage(context, "carpet.commands.runtime.gc", free);
        class_2561 prompt = TextBuilder.of("carpet.commands.runtime.gc.prompt", new Object[0]).setGrayItalic().build();
        MessageUtils.sendMessage((class_2168)context.getSource(), prompt);
        return (int)size;
    }

    private int openFolder(CommandContext<class_2168> context) {
        class_156.method_668().method_60932(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188));
        return 1;
    }

    private class_2561 displayMemory(long size) {
        DecimalFormat format = new DecimalFormat("#.00");
        String mb = format.format((double)size / 1024.0 / 1024.0);
        TextBuilder builder = new TextBuilder("%s MB".formatted(mb)).setHover("carpet.command.data.unit.byte", size).setColor(class_124.field_1080);
        return builder.build();
    }

    private int writeContent(CommandContext<class_2168> context) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        WorldFormat worldFormat = new WorldFormat(server, "debug", "io");
        File file = worldFormat.file("FileWriteTest.txt");
        String content = StringArgumentType.getString(context, (String)"content");
        try {
            IOUtils.write(file, content);
        }
        catch (IOException e) {
            IOUtils.loggerError(e);
        }
        return content.length();
    }

    @Override
    public String getDefaultName() {
        return "runtime";
    }

    @Override
    public boolean shouldRegister() {
        return CarpetOrgAddition.isDebugDevelopment();
    }
}

