/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.config.AbstractConfig;
import org.carpetorgaddition.config.CustomCommandConfig;
import org.carpetorgaddition.config.HiddenFunctionConfig;
import org.carpetorgaddition.util.IOUtils;
import org.jetbrains.annotations.NotNull;

public class GlobalConfigs {
    private final File configFile = IOUtils.CONFIGURE_DIRECTORY.resolve("carpet-org-addition.json").toFile();
    private final HashMap<Class<?>, AbstractConfig<?>> configurations = new HashMap();
    private final JsonObject json;
    private static volatile GlobalConfigs INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static GlobalConfigs getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<GlobalConfigs> clazz = GlobalConfigs.class;
        synchronized (GlobalConfigs.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new GlobalConfigs();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private GlobalConfigs() {
        if (this.configFile.isFile()) {
            JsonObject json;
            try {
                json = IOUtils.loadJson(this.configFile);
            }
            catch (IOException e) {
                json = this.initJsonObject();
            }
            this.json = json;
        } else {
            this.json = this.initJsonObject();
        }
        this.register();
    }

    private JsonObject initJsonObject() {
        CarpetOrgAddition.LOGGER.info("Initializing configuration file");
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)2);
        return json;
    }

    public <E extends JsonElement, C extends AbstractConfig<E>> void load(C config) {
        JsonElement element = this.json.get(config.getKey());
        try {
            config.load((JsonElement)element);
        }
        catch (RuntimeException e) {
            IOUtils.backupFile(this.configFile);
            this.json.add(config.getKey(), config.getJsonValue());
            CarpetOrgAddition.LOGGER.warn("Global config partially corrupted - resetting damaged section", (Throwable)e);
        }
    }

    public void save() {
        try {
            for (AbstractConfig<?> configuration : this.configurations.values()) {
                if (!configuration.shouldBeSaved()) continue;
                this.json.add(configuration.getKey(), configuration.getJsonValue());
            }
            IOUtils.write(this.configFile, this.json);
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.error("An unexpected error occurred while saving the global configuration file for {}", (Object)CarpetOrgAddition.MOD_NAME, (Object)e);
        }
    }

    private void register() {
        this.register(new CustomCommandConfig(this));
        this.register(new HiddenFunctionConfig(this));
    }

    private void register(AbstractConfig<?> config) {
        this.configurations.put(config.getClass(), config);
        this.load(config);
    }

    private <T extends AbstractConfig<?>> T getConfig(Class<T> key) {
        AbstractConfig<?> config = this.configurations.get(key);
        return (T)((AbstractConfig)key.cast(config));
    }

    public boolean isEnableHiddenFunction() {
        return this.getConfig(HiddenFunctionConfig.class).isEnable();
    }

    public String[] getCommand(String command) {
        return this.getConfig(CustomCommandConfig.class).getCommand(command);
    }
}

