/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.logger;

import carpet.logging.HUDLogger;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3989;
import net.minecraft.class_3990;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.logger.LoggerRegister;
import org.carpetorgaddition.logger.Loggers;
import org.carpetorgaddition.logger.WanderingTraderSpawnLogger;
import org.carpetorgaddition.mixin.accessor.carpet.LoggerAccessor;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3990.class})
public class WanderingTraderManagerMixin {
    @Shadow
    private int field_17729;
    @Shadow
    private int field_17728;
    @Shadow
    private int field_17730;

    @Inject(method={"spawn"}, at={@At(value="HEAD")})
    private void updataLogger(class_3218 world, boolean spawnMonsters, CallbackInfo ci) {
        if (world.method_64395().method_8355(class_1928.field_21832)) {
            int countdown = ((this.field_17729 == 0 ? 1200 : this.field_17729) - (1200 - this.field_17728)) / 20;
            WanderingTraderSpawnLogger.setSpawnCountdown(new WanderingTraderSpawnLogger.SpawnCountdown(countdown, this.field_17730));
            return;
        }
        WanderingTraderSpawnLogger.setSpawnCountdown(null);
    }

    @WrapOperation(method={"trySpawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/WanderingTraderEntity;setPositionTarget(Lnet/minecraft/util/math/BlockPos;I)V")})
    private void broadcastSpawnSuccess(class_3989 trader, class_2338 pos, int i, Operation<Void> original) {
        original.call(new Object[]{trader, pos, i});
        if (LoggerRegister.wanderingTrader && WanderingTraderSpawnLogger.spawnCountdownNonNull()) {
            MinecraftServer server = FetcherUtils.getServer((class_1297)trader);
            if (server == null) {
                return;
            }
            HUDLogger logger = Loggers.getWanderingTraderLogger();
            Set<Map.Entry<String, String>> entries = ((LoggerAccessor)logger).getSubscribedOnlinePlayers().entrySet();
            class_2561 blockPos = TextProvider.blockPos(trader.method_24515(), class_124.field_1060);
            class_2561 message = TextBuilder.translate("carpet.logger.wanderingTrader.message", blockPos);
            for (Map.Entry<String, String> entry : entries) {
                class_3222 player = server.method_3760().method_14566(entry.getKey());
                if (player == null) continue;
                boolean canNavigate = CommandUtils.canUseCommand(player.method_64396(), CarpetOrgAdditionSettings.commandNavigate);
                if (canNavigate) {
                    class_2561 button = TextBuilder.of("carpet.logger.wanderingTrader.message.navigate", new Object[0]).setCommand(CommandProvider.navigateToUuidEntity(trader.method_5667())).setHover(TextBuilder.translate("carpet.logger.wanderingTrader.message.navigate.hover", trader.method_5477())).setColor(class_124.field_1075).build();
                    class_2561 canNavigateMessage = TextBuilder.translate("carpet.logger.wanderingTrader.message.click", blockPos, button);
                    MessageUtils.sendMessage(player, canNavigateMessage);
                } else {
                    MessageUtils.sendMessage(player, message);
                }
                WorldUtils.playSound(FetcherUtils.getWorld((class_1297)trader), player.method_24515(), trader.method_18010(), trader.method_5634());
            }
        }
    }
}

