/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import carpet.fakes.ServerPlayerInterface;
import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.dataupdate.DataUpdater;
import org.carpetorgaddition.dataupdate.player.FakePlayerSerializeDataUpdater;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.fakeplayer.EntityPlayerActionPackSerial;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerStartupAction;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerActionSerializer;
import org.carpetorgaddition.periodic.task.FakePlayerStartupActionTask;
import org.carpetorgaddition.periodic.task.ServerTaskManager;
import org.carpetorgaddition.periodic.task.schedule.DelayedLoginTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.TextJoiner;
import org.carpetorgaddition.wheel.WorldFormat;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakePlayerSerializer
implements Comparable<FakePlayerSerializer> {
    private final String fakePlayerName;
    @NotNull
    private String comment = "";
    @NotNull
    private final class_243 playerPos;
    private final float yaw;
    private final float pitch;
    @NotNull
    private final String dimension;
    @NotNull
    private final class_1934 gameMode;
    private final boolean flying;
    private final boolean sneaking;
    private boolean autologin = false;
    @NotNull
    private final EntityPlayerActionPackSerial interactiveAction;
    @NotNull
    private final FakePlayerActionSerializer autoAction;
    private final HashSet<@Nullable String> groups = new HashSet();
    private final EnumMap<FakePlayerStartupAction, Integer> startups = new EnumMap(FakePlayerStartupAction.class);
    private boolean isChanged = false;
    private final File file;

    public FakePlayerSerializer(EntityPlayerMPFake fakePlayer) {
        this.fakePlayerName = FetcherUtils.getPlayerName((class_1657)fakePlayer);
        this.playerPos = FetcherUtils.getFootPos((class_1297)fakePlayer);
        this.yaw = fakePlayer.method_36454();
        this.pitch = fakePlayer.method_36455();
        this.dimension = WorldUtils.getDimensionId((class_1937)FetcherUtils.getWorld((class_3222)fakePlayer));
        this.gameMode = fakePlayer.field_13974.method_14257();
        this.flying = fakePlayer.method_31549().field_7479;
        this.sneaking = fakePlayer.method_5715();
        this.interactiveAction = new EntityPlayerActionPackSerial(((ServerPlayerInterface)fakePlayer).getActionPack());
        this.autoAction = new FakePlayerActionSerializer(fakePlayer);
        this.file = new WorldFormat(FetcherUtils.getServer((class_3222)fakePlayer), "player_data", new String[0]).file(this.fakePlayerName, "json");
    }

    public FakePlayerSerializer(EntityPlayerMPFake fakePlayer, FakePlayerSerializer serializer) {
        this(fakePlayer);
        this.groups.addAll(serializer.getGroups());
        this.startups.putAll(serializer.startups);
        this.autologin = serializer.autologin;
        this.setComment(serializer.comment);
        this.isChanged = true;
    }

    public FakePlayerSerializer(EntityPlayerMPFake fakePlayer, String comment) {
        this(fakePlayer);
        this.setComment(comment);
    }

    public FakePlayerSerializer(File file) throws IOException {
        JsonElement startup;
        JsonObject json = IOUtils.loadJson(file);
        int version = DataUpdater.getVersion(json);
        if (version < 2) {
            FakePlayerSerializeDataUpdater dataUpdater = new FakePlayerSerializeDataUpdater();
            json = dataUpdater.update(json, version);
        }
        this.fakePlayerName = file.getName().split("\\.")[0];
        JsonObject pos = json.get("pos").getAsJsonObject();
        this.playerPos = new class_243(pos.get("x").getAsDouble(), pos.get("y").getAsDouble(), pos.get("z").getAsDouble());
        JsonObject direction = json.get("direction").getAsJsonObject();
        this.yaw = direction.get("yaw").getAsFloat();
        this.pitch = direction.get("pitch").getAsFloat();
        this.dimension = json.get("dimension").getAsString();
        this.gameMode = class_1934.method_8385((String)json.get("gamemode").getAsString());
        this.flying = json.get("flying").getAsBoolean();
        this.sneaking = json.get("sneaking").getAsBoolean();
        this.autologin = IOUtils.getJsonElement(json, "autologin", false, Boolean.class);
        JsonElement element = json.get("annotation");
        this.comment = element == null ? "" : element.getAsString();
        this.interactiveAction = json.has("hand_action") ? new EntityPlayerActionPackSerial(json.get("hand_action").getAsJsonObject()) : EntityPlayerActionPackSerial.NO_ACTION;
        if (json.has("script_action")) {
            JsonObject scriptJson = json.get("script_action").getAsJsonObject();
            this.autoAction = new FakePlayerActionSerializer(scriptJson);
        } else {
            this.autoAction = FakePlayerActionSerializer.NO_ACTION;
        }
        if (json.has("group")) {
            JsonArray array = json.getAsJsonArray("group");
            for (JsonElement group : array) {
                if (group.isJsonNull()) continue;
                this.groups.add(group.getAsString());
            }
        }
        if ((startup = json.get("startup")) != null && startup.isJsonArray()) {
            JsonArray array = startup.getAsJsonArray();
            for (JsonElement jsonElement : array) {
                JsonObject object = jsonElement.getAsJsonObject();
                int delay = object.has("delay") ? object.get("delay").getAsInt() : 1;
                String action = object.get("action").getAsString();
                Optional<FakePlayerStartupAction> optional = FakePlayerStartupAction.fromString(action);
                if (optional.isEmpty()) continue;
                this.startups.put(optional.get(), delay);
            }
        }
        this.file = file;
    }

    public void save() {
        try {
            IOUtils.write(this.file, this.toJson());
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.warn("Failed to successfully save player data", (Throwable)e);
        }
        this.isChanged = false;
    }

    public void spawn(MinecraftServer server) throws CommandSyntaxException {
        if (server.method_3760().method_14566(this.fakePlayerName) != null) {
            throw CommandUtils.createException("carpet.commands.playerManager.spawn.player_exist", new Object[0]);
        }
        class_2168 source = server.method_3739();
        ServerTaskManager taskManager = ServerComponentCoordinator.getCoordinator(server).getServerTaskManager();
        Consumer<EntityPlayerMPFake> consumer = fakePlayer -> {
            fakePlayer.method_5660(this.sneaking);
            this.interactiveAction.startAction((EntityPlayerMPFake)fakePlayer);
            this.autoAction.clearPlayer();
            this.autoAction.startAction((EntityPlayerMPFake)fakePlayer);
            for (Map.Entry<FakePlayerStartupAction, Integer> entry : this.startups.entrySet()) {
                FakePlayerStartupActionTask task = new FakePlayerStartupActionTask(source, (EntityPlayerMPFake)fakePlayer, entry.getKey(), entry.getValue());
                CommandUtils.handlingException(() -> taskManager.addTask(task), source);
            }
        };
        GenericUtils.createFakePlayer(this.fakePlayerName, server, this.playerPos, this.yaw, this.pitch, WorldUtils.getWorld(this.dimension), this.gameMode, this.flying, consumer);
    }

    public class_2561 info() {
        TextJoiner joiner = new TextJoiner();
        String pos = MathUtils.numberToTwoDecimalString(this.playerPos.method_10216()) + " " + MathUtils.numberToTwoDecimalString(this.playerPos.method_10214()) + " " + MathUtils.numberToTwoDecimalString(this.playerPos.method_10215());
        joiner.append("carpet.commands.playerManager.info.pos", pos);
        joiner.append("carpet.commands.playerManager.info.direction", MathUtils.numberToTwoDecimalString(this.yaw), MathUtils.numberToTwoDecimalString(this.pitch));
        joiner.append("carpet.commands.playerManager.info.dimension", TextProvider.dimension(this.dimension));
        joiner.append("carpet.commands.playerManager.info.gamemode", this.gameMode.method_8383());
        joiner.append("carpet.commands.playerManager.info.flying", TextProvider.getBoolean(this.flying));
        joiner.append("carpet.commands.playerManager.info.sneaking", TextProvider.getBoolean(this.sneaking));
        joiner.append("carpet.commands.playerManager.info.autologin", TextProvider.getBoolean(this.autologin));
        if (this.interactiveAction.hasAction()) {
            joiner.append(this.interactiveAction.toText());
        }
        if (this.autoAction.hasAction()) {
            joiner.append(this.autoAction.toText());
        }
        if (!this.startups.isEmpty()) {
            joiner.append("carpet.commands.playerManager.info.startup", new Object[0]);
            joiner.enter(() -> {
                for (Map.Entry<FakePlayerStartupAction, Integer> entry : this.startups.entrySet()) {
                    joiner.append(entry.getKey().getDisplayName());
                    int delay = entry.getValue();
                    if (delay <= 1) continue;
                    joiner.enter("carpet.commands.playerManager.info.startup.delay", delay);
                }
            });
        }
        if (this.hasComment()) {
            joiner.append("carpet.commands.playerManager.info.comment", this.comment);
        }
        return joiner.join();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)2);
        JsonObject pos = new JsonObject();
        pos.addProperty("x", (Number)this.playerPos.field_1352);
        pos.addProperty("y", (Number)this.playerPos.field_1351);
        pos.addProperty("z", (Number)this.playerPos.field_1350);
        json.add("pos", (JsonElement)pos);
        JsonObject direction = new JsonObject();
        direction.addProperty("yaw", (Number)Float.valueOf(this.yaw));
        direction.addProperty("pitch", (Number)Float.valueOf(this.pitch));
        json.add("direction", (JsonElement)direction);
        json.addProperty("dimension", this.dimension);
        json.addProperty("gamemode", this.gameMode.method_8381());
        json.addProperty("flying", Boolean.valueOf(this.flying));
        json.addProperty("sneaking", Boolean.valueOf(this.sneaking));
        json.addProperty("autologin", Boolean.valueOf(this.autologin));
        json.addProperty("annotation", this.getComment());
        json.add("hand_action", (JsonElement)this.interactiveAction.toJson());
        json.add("script_action", (JsonElement)this.autoAction.toJson());
        JsonArray groups = new JsonArray();
        for (String group : this.groups) {
            if (group == null) continue;
            groups.add(group);
        }
        json.add("group", (JsonElement)groups);
        JsonArray startup = new JsonArray();
        for (Map.Entry<FakePlayerStartupAction, Integer> entry : this.startups.entrySet()) {
            JsonObject action = new JsonObject();
            action.addProperty("delay", (Number)entry.getValue());
            action.addProperty("action", entry.getKey().toString());
            startup.add((JsonElement)action);
        }
        json.add("startup", (JsonElement)startup);
        return json;
    }

    public void setComment(@Nullable String comment) {
        this.comment = comment == null ? "" : comment;
        this.isChanged = true;
    }

    public void setAutologin(boolean autologin) {
        this.autologin = autologin;
        this.isChanged = true;
    }

    public void addToGroup(String group) {
        this.groups.add(group);
        this.isChanged = true;
    }

    public boolean removeFromGroup(String group) {
        boolean remove = this.groups.remove(group);
        this.isChanged = true;
        return remove;
    }

    public String getFakePlayerName() {
        return this.fakePlayerName;
    }

    public class_2561 getDisplayName() {
        return new TextBuilder(this.fakePlayerName).setHover(this.info()).build();
    }

    public Supplier<class_2561> toTextSupplier() {
        return this::toText;
    }

    private class_2561 toText() {
        class_2561 loginHover = TextBuilder.translate("carpet.commands.playerManager.click.online", new Object[0]);
        class_2561 logoutHover = TextBuilder.translate("carpet.commands.playerManager.click.offline", new Object[0]);
        String name = this.getFakePlayerName();
        String logonCommand = CommandProvider.playerManagerSpawn(name);
        String logoutCommand = CommandProvider.killFakePlayer(name);
        class_2561 login = new TextBuilder("[\u2191]").setCommand(logonCommand).setHover(loginHover).setColor(class_124.field_1060).build();
        class_2561 logout = new TextBuilder("[\u2193]").setCommand(logoutCommand).setHover(logoutHover).setColor(class_124.field_1061).build();
        class_2561 info = new TextBuilder("[?]").setHover(this.info()).setColor(class_124.field_1080).build();
        TextJoiner joiner = new TextJoiner();
        joiner.then(login).literal().then(logout).literal().then(info).literal().literal(name);
        if (this.hasComment()) {
            TextBuilder builder = new TextBuilder("    // " + this.getComment());
            builder.setGrayItalic();
            joiner.then(builder.build());
        }
        return joiner.join();
    }

    public static void autoLogin(MinecraftServer server) {
        ServerTaskManager manager = ServerComponentCoordinator.getCoordinator(server).getServerTaskManager();
        try {
            List<FakePlayerSerializer> list = FetcherUtils.getFakePlayerSerializationManager(server).list();
            int count = server.method_3788();
            for (FakePlayerSerializer serializer : list) {
                if (!serializer.autologin) continue;
                manager.addTask(new DelayedLoginTask(server, server.method_3739(), serializer, 1L){

                    @Override
                    public void tick() {
                        try {
                            CarpetOrgAdditionSettings.hiddenLoginMessages.setExternal(true);
                            super.tick();
                        }
                        finally {
                            CarpetOrgAdditionSettings.hiddenLoginMessages.setExternal(false);
                        }
                    }
                });
                if (++count < server.method_3802() - 1) continue;
                CarpetOrgAddition.LOGGER.warn("The number of server players is about to reach its limit");
                break;
            }
        }
        catch (CommandSyntaxException | RuntimeException e) {
            CarpetOrgAddition.LOGGER.error("\u73a9\u5bb6\u81ea\u52a8\u767b\u5f55\u51fa\u73b0\u610f\u5916\u9519\u8bef", e);
        }
    }

    public boolean hasComment() {
        return !this.comment.isEmpty();
    }

    @NotNull
    public String getComment() {
        return this.comment;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public Set<String> getGroups() {
        return this.groups.isEmpty() ? Collections.singleton(null) : Collections.unmodifiableSet(this.groups);
    }

    public void addStartupFunction(FakePlayerStartupAction action, int delay) {
        if (delay == -1) {
            this.startups.remove(action);
        } else {
            this.startups.put(action, delay);
        }
        this.isChanged = true;
    }

    public boolean equals(Object obj) {
        return this == obj || this.getClass() == obj.getClass() && this.fakePlayerName.equals(((FakePlayerSerializer)obj).fakePlayerName);
    }

    public int hashCode() {
        return this.fakePlayerName.hashCode();
    }

    @Override
    public int compareTo(@NotNull FakePlayerSerializer o) {
        return this.fakePlayerName.compareTo(o.fakePlayerName);
    }

    public boolean remove() {
        return this.file.delete();
    }
}

