/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.TextJoiner;
import org.carpetorgaddition.wheel.inventory.AutoGrowInventory;
import org.carpetorgaddition.wheel.predicate.ItemStackPredicate;

public class CraftingTableCraftAction
extends AbstractPlayerAction {
    private final ItemStackPredicate[] predicates = new ItemStackPredicate[9];

    public CraftingTableCraftAction(EntityPlayerMPFake fakePlayer, ItemStackPredicate[] predicates) {
        super(fakePlayer);
        if (predicates.length != 9) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(predicates, 0, this.predicates, 0, this.predicates.length);
    }

    public static class_1799 getCraftOutput(ItemStackPredicate[] predicates, int widthHeight, EntityPlayerMPFake fakePlayer) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (ItemStackPredicate predicate : predicates) {
            Optional<class_1792> optional = predicate.getConvert();
            if (optional.isEmpty()) {
                return class_1799.field_8037;
            }
            list.add(optional.get().method_7854());
        }
        class_9694 input = class_9694.method_59986((int)widthHeight, (int)widthHeight, list);
        class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
        Optional optional = FetcherUtils.getServer((class_3222)fakePlayer).method_3772().method_8132(class_3956.field_17545, (class_9695)input, (class_1937)world);
        return optional.map(arg_0 -> CraftingTableCraftAction.lambda$getCraftOutput$0(input, (class_1937)world, arg_0)).orElse(class_1799.field_8037);
    }

    @Override
    protected void tick() {
        class_1703 class_17032 = this.getFakePlayer().field_7512;
        if (class_17032 instanceof class_1714) {
            class_1714 craftingScreenHandler = (class_1714)class_17032;
            AutoGrowInventory inventory = new AutoGrowInventory();
            this.craftingTableCraft(inventory, craftingScreenHandler);
            for (class_1799 itemStack : inventory) {
                this.getFakePlayer().method_7329(itemStack, false, true);
            }
        }
    }

    private void craftingTableCraft(AutoGrowInventory inventory, class_1714 craftingScreenHandler) {
        int successCount;
        block12: {
            block13: {
                int craftCount = 0;
                int loopCount = 0;
                do {
                    if (++loopCount > 1200) {
                        throw new InfiniteLoopException();
                    }
                    successCount = 0;
                    block1: for (int index = 1; index <= 9; ++index) {
                        ItemStackPredicate predicate = this.predicates[index - 1];
                        class_1735 slot = craftingScreenHandler.method_7611(index);
                        if (slot.method_7681()) {
                            class_1799 itemStack = slot.method_7677();
                            if (predicate.test(itemStack)) {
                                ++successCount;
                                continue;
                            }
                            FakePlayerUtils.throwItem((class_1703)craftingScreenHandler, index, this.getFakePlayer());
                            continue;
                        }
                        if (predicate.isEmpty()) {
                            ++successCount;
                            continue;
                        }
                        int size = craftingScreenHandler.field_7761.size();
                        for (int inventoryIndex = 10; inventoryIndex < size; ++inventoryIndex) {
                            class_1799 contentItemStack;
                            class_1799 itemStack = craftingScreenHandler.method_7611(inventoryIndex).method_7677();
                            if (predicate.test(itemStack)) {
                                if (FakePlayerUtils.withKeepPickupAndMoveItemStack((class_1703)craftingScreenHandler, inventoryIndex, index, this.getFakePlayer())) {
                                    ++successCount;
                                    continue block1;
                                }
                            } else if (CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get().booleanValue() && InventoryUtils.isOperableSulkerBox(itemStack) && !(contentItemStack = InventoryUtils.pickItemFromShulkerBox(itemStack, predicate)).method_7960()) {
                                FakePlayerUtils.dropCursorStack((class_1703)craftingScreenHandler, this.getFakePlayer());
                                craftingScreenHandler.method_34254(contentItemStack);
                                FakePlayerUtils.pickupCursorStack((class_1703)craftingScreenHandler, index, this.getFakePlayer());
                                ++successCount;
                                continue block1;
                            }
                            if (index != 9 || inventoryIndex != size - 1) continue;
                            return;
                        }
                    }
                    if (successCount != 9) break block12;
                    if (!craftingScreenHandler.method_7611(0).method_7681()) break block13;
                    FakePlayerUtils.collectItem((class_1703)craftingScreenHandler, 0, inventory, this.getFakePlayer());
                } while (!FakePlayerUtils.shouldStop(++craftCount));
                return;
            }
            FakePlayerUtils.stopCraftAction(this.getFakePlayer().method_64396(), this.getFakePlayer());
            return;
        }
        if (successCount > 9) {
            throw new IllegalStateException(FetcherUtils.getPlayerName((class_1657)this.getFakePlayer()) + "\u627e\u5230\u6b63\u786e\u5408\u6210\u6750\u6599\u7684\u6b21\u6570\u4e3a" + successCount + "\uff0c\u6b63\u5e38\u4e0d\u5e94\u8be5\u8d85\u8fc79");
        }
    }

    @Override
    public List<class_2561> info() {
        TextJoiner joiner = new TextJoiner();
        joiner.unsetBullet();
        joiner.setIndent(4);
        class_1799 craftOutput = CraftingTableCraftAction.getCraftOutput(this.predicates, 3, this.getFakePlayer());
        class_2561 itemText = craftOutput.method_7960() ? TextBuilder.translate("carpet.command.item.item", new Object[0]) : craftOutput.method_7909().method_63680();
        joiner.append("carpet.commands.playerAction.info.craft.result", this.getFakePlayer().method_5476(), itemText);
        joiner.enter(() -> this.addCraftRecipe(joiner, craftOutput));
        class_1703 class_17032 = this.getFakePlayer().field_7512;
        if (class_17032 instanceof class_1714) {
            class_1714 currentScreenHandler = (class_1714)class_17032;
            joiner.append("carpet.commands.playerAction.info.craft.state", this.getFakePlayer().method_5476());
            joiner.enter(() -> this.addCraftGridState(currentScreenHandler, joiner));
        } else {
            joiner.append("carpet.commands.playerAction.info.craft.no_crafting_table", this.getFakePlayer().method_5476(), class_1802.field_8465.method_63680());
        }
        return joiner.collect();
    }

    private void addCraftRecipe(TextJoiner joiner, class_1799 craftOutput) {
        joiner.newline().then(this.predicates[0].getInitialUpperCase()).literal().then(this.predicates[1].getInitialUpperCase()).literal().then(this.predicates[2].getInitialUpperCase());
        joiner.newline().then(this.predicates[3].getInitialUpperCase()).literal().then(this.predicates[4].getInitialUpperCase()).literal().then(this.predicates[5].getInitialUpperCase());
        if (!craftOutput.method_7960()) {
            joiner.literal(" -> ").then(FakePlayerUtils.getWithCountHoverText(craftOutput));
        }
        joiner.newline().then(this.predicates[6].getInitialUpperCase()).literal().then(this.predicates[7].getInitialUpperCase()).literal().then(this.predicates[8].getInitialUpperCase());
    }

    private void addCraftGridState(class_1714 screenHandler, TextJoiner joiner) {
        joiner.newline().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(1).method_7677())).literal().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(2).method_7677())).literal().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(3).method_7677()));
        joiner.newline().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(4).method_7677())).literal().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(5).method_7677())).literal().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(6).method_7677())).literal(" -> ").then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(0).method_7677()));
        joiner.newline().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(7).method_7677())).literal().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(8).method_7677())).literal().then(FakePlayerUtils.getWithCountHoverText(screenHandler.method_7611(9).method_7677()));
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (int i = 0; i < this.predicates.length; ++i) {
            json.addProperty(String.valueOf(i), this.predicates[i].toString());
        }
        return json;
    }

    @Override
    public class_2561 getDisplayName() {
        return TextBuilder.translate("carpet.commands.playerAction.action.crafting_table_craft", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.CRAFTING_TABLE_CRAFT;
    }

    private static /* synthetic */ class_1799 lambda$getCraftOutput$0(class_9694 input, class_1937 world, class_8786 recipe) {
        return ((class_3955)recipe.comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)world.method_30349());
    }
}

