/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.inventory;

import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.minecraft.class_11560;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessor;
import org.jetbrains.annotations.NotNull;

public class FabricPlayerAccessManager {
    private final MinecraftServer server;
    private final Map<class_11560, Set<class_3222>> viewers = new ConcurrentHashMap<class_11560, Set<class_3222>>();
    private final Map<class_11560, FabricPlayerAccessor> accessors = new ConcurrentHashMap<class_11560, FabricPlayerAccessor>();
    private final Queue<FabricPlayerAccessorEntry> queue = Queues.newConcurrentLinkedQueue();
    private volatile long lastProcessingTime = System.currentTimeMillis();
    private static final long MAX_TICK_TACK_TIME = 25L;
    private static final long HEALTH_CHECK_TIMEOUT_MS = 8000L;
    private static final long AWAIT_TIMEOUT_MS = 1000L;

    public FabricPlayerAccessManager(MinecraftServer server) {
        this.server = server;
    }

    public void tick() {
        if (this.queue.isEmpty()) {
            return;
        }
        this.server.execute(this::createFabricPlayerAccessor);
    }

    public FabricPlayerAccessor getOrCreate(GameProfile gameProfile) {
        return this.getOrCreate(new class_11560(gameProfile));
    }

    public FabricPlayerAccessor getOrCreate(class_11560 entry) {
        return this.accessors.computeIfAbsent(entry, profile -> new FabricPlayerAccessor(this.server, (class_11560)profile, this));
    }

    @NotNull
    public FabricPlayerAccessor getOrCreateBlocking(class_11560 playerConfigEntry) {
        return this.accessors.computeIfAbsent(playerConfigEntry, __ -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFabricPlayerAccessor() {
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() - time <= 25L) {
            FabricPlayerAccessorEntry entry = this.queue.poll();
            if (entry == null) {
                return;
            }
            Lock lock = entry.getLock();
            Condition condition = entry.getCondition();
            try {
                lock.lock();
                try {
                    entry.createAccessor();
                }
                catch (RuntimeException e) {
                    entry.setException(e);
                }
                finally {
                    condition.signalAll();
                }
            }
            finally {
                lock.unlock();
            }
            this.lastProcessingTime = System.currentTimeMillis();
        }
        return;
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    public Set<class_3222> getViewers(class_11560 entry) {
        Set<class_3222> set = this.viewers.get(entry);
        return set == null ? Set.of() : set;
    }

    public void addViewers(class_11560 entry, Set<class_3222> viewers) {
        this.viewers.put(entry, viewers);
    }

    public void removeAccessor(class_11560 entry) {
        this.accessors.remove(entry);
    }

    public void removeViewer(class_11560 entry) {
        this.viewers.remove(entry);
    }

    private /* synthetic */ FabricPlayerAccessor lambda$getOrCreateBlocking$1(class_11560 playerConfigEntry) {
        return new FabricPlayerAccessor(this.server, playerConfigEntry, this);
    }

    public static class FabricPlayerAccessorEntry {
        private final Supplier<FabricPlayerAccessor> supplier;
        private final AtomicReference<FabricPlayerAccessor> accessor;
        private final AtomicReference<RuntimeException> exception;
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();

        private FabricPlayerAccessorEntry(Supplier<FabricPlayerAccessor> supplier) {
            this.supplier = supplier;
            this.accessor = new AtomicReference();
            this.exception = new AtomicReference();
        }

        private void createAccessor() {
            this.accessor.set(this.supplier.get());
        }

        private void setException(RuntimeException exception) {
            this.exception.set(exception);
        }

        private FabricPlayerAccessor getAccessor() {
            return this.accessor.get();
        }

        private RuntimeException getException() {
            return this.exception.get();
        }

        private Lock getLock() {
            return this.lock;
        }

        private Condition getCondition() {
            return this.condition;
        }
    }
}

