/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.traverser;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.traverser.WorldTraverser;
import org.jetbrains.annotations.NotNull;

public class BlockPosTraverser
extends WorldTraverser<class_2338> {
    protected BlockPosTraverser(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public BlockPosTraverser(class_1937 world, class_2338 sourcePos, int range) {
        super(world, sourcePos, range);
    }

    public BlockPosTraverser(class_2338 from, class_2338 to) {
        super(from, to);
    }

    public BlockPosTraverser(class_238 box) {
        super(box);
    }

    public BlockPosTraverser clamp(class_1937 world) {
        int minY = Math.max(this.minY, WorldUtils.getMinArchitectureAltitude(world));
        int maxY = Math.min(this.maxY, WorldUtils.getMaxArchitectureAltitude(world));
        return new BlockPosTraverser(this.minX, minY, this.minZ, this.maxX, maxY, this.maxZ);
    }

    @Override
    @NotNull
    public Iterator<class_2338> iterator() {
        return new Iterator<class_2338>(){
            private int iterations = 0;
            private final int maxIterations = BlockPosTraverser.this.size();
            private final int startX;
            private final int startY;
            private final int startZ;
            private final int finalX;
            private final int finalY;
            private final int finalZ;
            private int currentX;
            private int currentY;
            private int currentZ;
            {
                this.startX = BlockPosTraverser.this.minX;
                this.startY = BlockPosTraverser.this.minY;
                this.startZ = BlockPosTraverser.this.minZ;
                this.finalX = BlockPosTraverser.this.maxX;
                this.finalY = BlockPosTraverser.this.maxY;
                this.finalZ = BlockPosTraverser.this.maxZ;
                this.currentX = this.startX;
                this.currentY = this.startY;
                this.currentZ = this.startZ;
            }

            @Override
            public boolean hasNext() {
                return this.iterations < this.maxIterations;
            }

            @Override
            public class_2338 next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.iterations;
                ++this.currentX;
                if (this.currentX > this.finalX) {
                    this.currentX = this.startX;
                    ++this.currentY;
                    if (this.currentY > this.finalY) {
                        this.currentY = this.startY;
                        ++this.currentZ;
                        if (this.currentZ > this.finalZ) {
                            return BlockPosTraverser.this.getMaxBlockPos();
                        }
                    }
                }
                return new class_2338(this.currentX, this.currentY, this.currentZ);
            }
        };
    }
}

