/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.network.s2c.WaypointClearS2CPacket;
import org.carpetorgaddition.periodic.PlayerComponentCoordinator;
import org.carpetorgaddition.periodic.navigator.AbstractNavigator;
import org.carpetorgaddition.periodic.navigator.BlockPosNavigator;
import org.carpetorgaddition.periodic.navigator.EntityNavigator;
import org.carpetorgaddition.periodic.navigator.HasNamePosNavigator;
import org.carpetorgaddition.periodic.navigator.WaypointNavigator;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.Waypoint;
import org.jetbrains.annotations.Nullable;

public class NavigatorManager {
    @Nullable
    private AbstractNavigator navigator;
    private boolean isUpdated = false;
    private final class_3222 player;

    public NavigatorManager(class_3222 player) {
        this.player = player;
    }

    public void tick() {
        if (this.navigator == null) {
            return;
        }
        try {
            if (this.navigator.isArrive()) {
                this.clearNavigator();
            } else {
                if (this.isUpdated) {
                    this.isUpdated = false;
                    this.navigator.onStart();
                }
                this.navigator.tick();
            }
        }
        catch (RuntimeException e) {
            MessageUtils.sendErrorMessage(this.player.method_64396(), e, "carpet.commands.navigate.exception", new Object[0]);
            CarpetOrgAddition.LOGGER.error("\u5bfc\u822a\u5668\u6ca1\u6709\u6309\u7167\u9884\u671f\u5de5\u4f5c", (Throwable)e);
            this.clearNavigator();
        }
    }

    @Nullable
    public AbstractNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(class_1297 entity, boolean isContinue) {
        this.setNavigator(new EntityNavigator(this.player, entity, isContinue));
    }

    public void setNavigator(Waypoint waypoint) {
        this.setNavigator(new WaypointNavigator(this.player, waypoint));
    }

    public void setNavigator(class_2338 blockPos, class_1937 world) {
        this.setNavigator(new BlockPosNavigator(this.player, blockPos, world));
    }

    public void setNavigator(class_2338 blockPos, class_1937 world, class_2561 name) {
        this.setNavigator(new HasNamePosNavigator(this.player, blockPos, world, name));
    }

    private void setNavigator(@Nullable AbstractNavigator navigator) {
        ServerPlayNetworking.send((class_3222)this.player, (class_8710)WaypointClearS2CPacket.INSTANCE);
        this.navigator = navigator;
        this.isUpdated = true;
    }

    public void clearNavigator() {
        this.setNavigator((AbstractNavigator)null);
        ServerPlayNetworking.send((class_3222)this.player, (class_8710)WaypointClearS2CPacket.INSTANCE);
    }

    public void setNavigatorFromOldPlayer(class_3222 oldPlayer) {
        NavigatorManager manager = PlayerComponentCoordinator.getManager(oldPlayer).getNavigatorManager();
        AbstractNavigator navigator = manager.getNavigator();
        this.navigator = navigator == null ? null : navigator.copy(this.player);
    }
}

