/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.carpetorgaddition.CarpetOrgAdditionExtension;
import org.carpetorgaddition.config.GlobalConfigs;
import org.carpetorgaddition.debug.DebugRuleRegistrar;
import org.carpetorgaddition.network.NetworkS2CPacketRegister;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.wheel.Counter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarpetOrgAddition
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CarpetOrgAddition");
    public static final String MOD_ID = "carpet-org-addition";
    public static final ModMetadata METADATA = ((ModContainer)FabricLoader.getInstance().getModContainer("carpet-org-addition").orElseThrow()).getMetadata();
    public static final String MOD_NAME = METADATA.getName();
    public static final String VERSION = METADATA.getVersion().getFriendlyString();
    public static final String MOD_NAME_LOWER_CASE = MOD_NAME.replace(" ", "").toLowerCase(Locale.ROOT);
    public static final String BUILD_TIMESTAMP = METADATA.getCustomValue("buildTimestamp").getAsString();
    public static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(s -> s.contains("jdwp"));
    public static final boolean LITHIUM = FabricLoader.getInstance().isModLoaded("lithium");
    public static final boolean CARPET_TIS_ADDITION = FabricLoader.getInstance().isModLoaded("carpet-tis-addition");
    public static final boolean ENABLE_HIDDEN_FUNCTION = GlobalConfigs.isEnableHiddenFunction();

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)new CarpetOrgAdditionExtension());
        NetworkS2CPacketRegister.register();
        if (ENABLE_HIDDEN_FUNCTION) {
            LOGGER.info("Hidden feature enabled");
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.runs();
        }
        if (CarpetOrgAddition.isDebugDevelopment()) {
            DebugRuleRegistrar.getInstance().registrar();
            LOGGER.info("Build timestamp: {}", (Object)BUILD_TIMESTAMP);
        }
    }

    private void runs() {
        File file = Path.of("startlog.txt", new String[0]).toAbsolutePath().toFile();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try {
            int total = 0;
            Counter<Object> counter = new Counter<Object>();
            if (file.isFile()) {
                List<String> list = Files.readAllLines(file.toPath());
                for (String str : list) {
                    String[] split;
                    if (str.isEmpty() || (split = str.split("=")).length != 2) continue;
                    LocalDate localDate = LocalDate.parse(split[0], formatter);
                    int count = Integer.parseInt(split[1]);
                    counter.add(localDate, count);
                    total += count;
                }
            }
            LocalDate now = LocalDate.now();
            ++total;
            counter.add(now);
            int count = counter.getCount(now);
            LOGGER.info("The game has been launched {} times today", (Object)count);
            List list = counter.keySet().stream().sorted().toList();
            StringJoiner joiner = new StringJoiner("\n");
            for (LocalDate date : list) {
                joiner.add(date.format(formatter) + "=" + counter.getCount(date));
            }
            IOUtils.write(file, joiner.toString());
            String earliest = ((LocalDate)list.getFirst()).format(formatter);
            LOGGER.info("The game has been launched a total of {} times since {}", (Object)total, (Object)earliest);
        }
        catch (IOException e) {
            LOGGER.warn("An unexpected error occurred while recording the number of game launches", (Throwable)e);
        }
    }

    public static boolean isDebugDevelopment() {
        return IS_DEBUG && FabricLoader.getInstance().isDevelopmentEnvironment();
    }
}

