/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.inventory;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_11560;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessor;

public class FabricPlayerAccessManager {
    private final MinecraftServer server;
    private final Map<class_11560, Set<class_3222>> viewers = new ConcurrentHashMap<class_11560, Set<class_3222>>();
    private final Map<class_11560, FabricPlayerAccessor> accessors = new ConcurrentHashMap<class_11560, FabricPlayerAccessor>();

    public FabricPlayerAccessManager(MinecraftServer server) {
        this.server = server;
    }

    public FabricPlayerAccessor getOrCreate(GameProfile gameProfile) {
        return this.getOrCreate(new class_11560(gameProfile));
    }

    public FabricPlayerAccessor getOrCreate(class_11560 entry) {
        return this.accessors.computeIfAbsent(entry, profile -> new FabricPlayerAccessor(this.server, (class_11560)profile, this));
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    public Set<class_3222> getViewers(class_11560 entry) {
        Set<class_3222> set = this.viewers.get(entry);
        return set == null ? Set.of() : set;
    }

    public void addViewers(class_11560 entry, Set<class_3222> viewers) {
        this.viewers.put(entry, viewers);
    }

    public void removeAccessor(class_11560 entry) {
        this.accessors.remove(entry);
    }

    public void removeViewer(class_11560 entry) {
        this.viewers.remove(entry);
    }
}

