/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2252;
import net.minecraft.class_2262;
import net.minecraft.class_2293;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.task.search.BlockSearchTask;
import org.carpetorgaddition.periodic.task.search.ItemSearchTask;
import org.carpetorgaddition.periodic.task.search.OfflinePlayerSearchTask;
import org.carpetorgaddition.periodic.task.search.TradeEnchantedBookSearchTask;
import org.carpetorgaddition.periodic.task.search.TradeItemSearchTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.permission.PermissionLevel;
import org.carpetorgaddition.wheel.permission.PermissionManager;
import org.carpetorgaddition.wheel.predicate.BlockStatePredicate;
import org.carpetorgaddition.wheel.predicate.EnchantedBookPredicate;
import org.carpetorgaddition.wheel.predicate.ItemStackPredicate;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.carpetorgaddition.wheel.traverser.BlockEntityTraverser;
import org.carpetorgaddition.wheel.traverser.BlockPosTraverser;
import org.carpetorgaddition.wheel.traverser.WorldTraverser;

public class FinderCommand
extends AbstractServerCommand {
    public static final int MAXIMUM_STATISTICAL_COUNT = 30000;
    public static final long TIME_SLICE = 30L;
    public static final long MAX_SEARCH_TIME = 5000L;
    public static final int MAX_HORIZONTAL_RANGE = 256;
    public static final class_2561 VILLAGER = TextBuilder.translate("entity.minecraft.villager", new Object[0]);
    public static final String FINDER_BLOCK = "finder.block";
    public static final String FINDER_ITEM = "finder.item";
    public static final String FINDER_ITEM_FROM_OFFLINE_PLAYER = "finder.item.from.offline_player";

    public FinderCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandFinder))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"block").requires((Predicate)PermissionManager.register(FINDER_BLOCK, PermissionLevel.PASS))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"blockState", (ArgumentType)class_2252.method_9645((class_7157)this.access)).executes(context -> this.blockFinder((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.blockFinder((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))).then(class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"to").then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(this::areaBlockSearch)))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"item").requires((Predicate)PermissionManager.register(FINDER_ITEM, PermissionLevel.PASS))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"itemStack", (ArgumentType)class_2293.method_9801((class_7157)this.access)).executes(context -> this.searchItem((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.searchItem((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"to").then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(this::areaItemFinder))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"offline_player").requires((Predicate)PermissionManager.register(FINDER_ITEM_FROM_OFFLINE_PLAYER, PermissionLevel.PASS))).executes(this::searchItemFromOfflinePlayer)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trade").requires((Predicate)PermissionManager.register("finder.trade", PermissionLevel.PASS))).then(class_2170.method_9247((String)"item").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"itemStack", (ArgumentType)class_2293.method_9801((class_7157)this.access)).executes(context -> this.searchTradeItem((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.searchTradeItem((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))))).then(class_2170.method_9247((String)"enchanted_book").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)this.access, (class_5321)class_7924.field_41265)).executes(context -> this.searchEnchantedBookTrade((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.searchEnchantedBookTrade((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"worldEater").requires(((Predicate<class_2168>)source -> CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION).and(PermissionManager.registerHiddenCommand("finder.worldEater", PermissionLevel.PASS)))).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(this::mayAffectWorldEater)))));
    }

    private SuggestionProvider<class_2168> suggestionDefaultDistance() {
        return (context, builder) -> class_2172.method_9253((String[])new String[]{"64", "128", "256"}, (SuggestionsBuilder)builder);
    }

    private int searchItem(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        class_2338 sourceBlockPos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockEntityTraverser traverser = new BlockEntityTraverser((class_1937)world, sourceBlockPos, range);
        this.checkBoxSize(traverser);
        ItemSearchTask task = new ItemSearchTask((class_1937)world, predicate, traverser, (class_2168)context.getSource());
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int areaItemFinder(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        class_3218 world = FetcherUtils.getWorld(player);
        BlockEntityTraverser traverser = new BlockEntityTraverser((class_1937)world, from, to);
        this.checkBoxSize(traverser);
        ItemSearchTask task = new ItemSearchTask((class_1937)world, predicate, traverser, (class_2168)context.getSource());
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int searchItemFromOfflinePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        OfflinePlayerSearchTask task = new OfflinePlayerSearchTask((class_2168)context.getSource(), predicate, player);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int blockFinder(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 sourceBlockPos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockPosTraverser traverser = new BlockPosTraverser((class_1937)world, sourceBlockPos, range);
        this.checkBoxSize(traverser);
        BlockStatePredicate predicate = BlockStatePredicate.ofPredicate(context, "blockState");
        BlockSearchTask task = new BlockSearchTask(world, sourceBlockPos, traverser, (class_2168)context.getSource(), predicate);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int mayAffectWorldEater(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        class_2338 sourceBlockPos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockPosTraverser traverser = new BlockPosTraverser(from, to);
        this.checkBoxSize(traverser);
        BlockStatePredicate predicate = BlockStatePredicate.ofWorldEater();
        BlockSearchTask task = new BlockSearchTask(world, sourceBlockPos, traverser, (class_2168)context.getSource(), predicate);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int areaBlockSearch(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        BlockPosTraverser traverser = new BlockPosTraverser(from, to);
        this.checkBoxSize(traverser);
        BlockStatePredicate predicate = BlockStatePredicate.ofPredicate(context, "blockState");
        BlockSearchTask task = new BlockSearchTask(FetcherUtils.getWorld(player), player.method_24515(), traverser, (class_2168)context.getSource(), predicate);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int searchTradeItem(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        class_2338 sourcePos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockPosTraverser traverser = new BlockPosTraverser((class_1937)world, sourcePos, range);
        this.checkBoxSize(traverser);
        TradeItemSearchTask task = new TradeItemSearchTask((class_1937)world, traverser, sourcePos, predicate, (class_2168)context.getSource());
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private int searchEnchantedBookTrade(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_1887 enchantment = (class_1887)class_7733.method_45612(context, (String)"enchantment").comp_349();
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        EnchantedBookPredicate predicate = new EnchantedBookPredicate(server, enchantment);
        class_2338 sourcePos = player.method_24515();
        class_3218 world = FetcherUtils.getWorld(player);
        BlockPosTraverser traverser = new BlockPosTraverser((class_1937)world, sourcePos, range);
        this.checkBoxSize(traverser);
        TradeEnchantedBookSearchTask task = new TradeEnchantedBookSearchTask((class_1937)world, traverser, sourcePos, source, predicate);
        ServerComponentCoordinator.getCoordinator(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private void checkBoxSize(WorldTraverser<?> traverser) throws CommandSyntaxException {
        int max = 513;
        if (traverser.length() > max || traverser.width() > max) {
            throw CommandUtils.createException("carpet.commands.finder.toobig", max);
        }
    }

    public static class_2561 showCount(class_1799 itemStack, int count, boolean inTheShulkerBox) {
        TextBuilder builder = new TextBuilder(TextProvider.itemCount(count, itemStack.method_7914()));
        return inTheShulkerBox ? builder.setItalic().build() : builder.build();
    }

    @Override
    public String getDefaultName() {
        return "finder";
    }
}

