/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.page;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.page.Page;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.jetbrains.annotations.NotNull;

public class PagedCollection
implements Iterable<Page> {
    private final ArrayList<Page> pages = new ArrayList();
    private final int id;
    private final class_2168 source;
    private int length = 0;

    public PagedCollection(int id, class_2168 source) {
        this.id = id;
        this.source = source;
    }

    public void addContent(List<? extends Supplier<class_2561>> list) {
        int max = PagedCollection.maximumNumberOfRow();
        for (int from = 0; from < list.size(); from += max) {
            int to = Math.min(from + max, list.size());
            this.pages.add(new Page(list, from, to));
        }
        this.length += list.size();
    }

    public void print() throws CommandSyntaxException {
        this.print(1, false);
    }

    public void print(int pagination, boolean printBlankLine) throws CommandSyntaxException {
        if (pagination <= 0 || pagination > this.pages.size()) {
            throw CommandUtils.createException("carpet.command.page.invalid", pagination, this.totalPages());
        }
        if (printBlankLine) {
            MessageUtils.sendEmptyMessage(this.source);
        }
        if (this.totalPages() == 1) {
            this.getPage(pagination).print(this.source);
        } else {
            this.getPage(pagination).print(this.source);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new TextBuilder("  ======").setColor(class_124.field_1063));
            list.add(this.prevPageButton(pagination));
            list.add(" [");
            list.add(new TextBuilder(pagination).setColor(class_124.field_1065));
            list.add("/");
            list.add(new TextBuilder(this.totalPages()).setColor(class_124.field_1065));
            list.add("] ");
            list.add(this.nextPageButton(pagination));
            list.add(new TextBuilder("======").setColor(class_124.field_1063));
            class_2561 pageTurningButton = TextBuilder.combineList(list);
            MessageUtils.sendMessage(this.source, pageTurningButton);
        }
    }

    private class_2561 prevPageButton(int pagination) {
        TextBuilder builder = new TextBuilder(" <<< ");
        if (pagination == 1) {
            builder.setColor(class_124.field_1080);
        } else {
            builder.setHover("carpet.command.page.prev", new Object[0]);
            builder.setCommand(CommandProvider.pageTurning(this.id, pagination - 1));
            builder.setColor(class_124.field_1075);
        }
        return builder.build();
    }

    private class_2561 nextPageButton(int pagination) {
        TextBuilder builder = new TextBuilder(" >>> ");
        if (pagination == this.totalPages()) {
            builder.setColor(class_124.field_1080);
        } else {
            builder.setHover("carpet.command.page.next", new Object[0]);
            builder.setCommand(CommandProvider.pageTurning(this.id, pagination + 1));
            builder.setColor(class_124.field_1075);
        }
        return builder.build();
    }

    private Page getPage(int pagination) {
        return this.pages.get(pagination - 1);
    }

    public int totalPages() {
        return this.pages.size();
    }

    public int length() {
        return this.length;
    }

    public class_2168 getSource() {
        return this.source;
    }

    public static int maximumNumberOfRow() {
        return Math.max(CarpetOrgAdditionSettings.maxLinesPerPage.get(), 1);
    }

    @Override
    @NotNull
    public Iterator<Page> iterator() {
        return this.pages.iterator();
    }
}

