/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerPathfinder;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class GotoAction
extends AbstractPlayerAction {
    private final FakePlayerPathfinder pathfinder;
    private final TargetType targetType;
    private final class_2561 displayName;
    private final Supplier<Optional<class_2338>> target;

    public GotoAction(@NotNull EntityPlayerMPFake fakePlayer, class_2338 blockPos) {
        super(fakePlayer);
        this.target = () -> Optional.of(blockPos);
        this.pathfinder = FakePlayerPathfinder.of(this::getFakePlayer, this.target);
        this.targetType = TargetType.BLOCK;
        this.displayName = TextProvider.blockPos(blockPos);
    }

    public GotoAction(@NotNull EntityPlayerMPFake fakePlayer, class_1297 entity) {
        super(fakePlayer);
        this.target = new EntityTracker(this::getFakePlayer, FetcherUtils.getWorld(entity), entity);
        this.pathfinder = FakePlayerPathfinder.of(this::getFakePlayer, this.target);
        this.targetType = TargetType.ENTITY;
        this.displayName = entity.method_5476();
    }

    @Override
    protected void tick() {
        if (this.pathfinder.isFinished()) {
            switch (this.targetType.ordinal()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.target.get().ifPresent(blockPos -> {
                        EntityTracker tracker = (EntityTracker)this.target;
                        class_243 pos = tracker.entity.method_19538();
                        if (blockPos.method_61082().method_1022(pos) > 3.0) {
                            tracker.update();
                            this.pathfinder.pathfinding();
                        }
                    });
                }
            }
        }
        this.pathfinder.tick();
    }

    @Override
    public ArrayList<class_2561> info() {
        class_2561 name = this.getFakePlayer().method_5476();
        String key = this.targetType.getTranslateKey();
        class_2561 text = TextBuilder.translate(key, name, this.displayName);
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add(text);
        return list;
    }

    @Override
    public JsonObject toJson() {
        return new JsonObject();
    }

    @Override
    public class_2561 getDisplayName() {
        return TextBuilder.translate("carpet.commands.playerAction.action.goto", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.STOP;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void onStop() {
        this.pathfinder.onStop();
    }

    public static enum TargetType {
        BLOCK("carpet.commands.playerAction.info.goto.block"),
        ENTITY("carpet.commands.playerAction.info.goto.entity");

        private final String translateKey;

        private TargetType(String key) {
            this.translateKey = key;
        }

        private String getTranslateKey() {
            return this.translateKey;
        }
    }

    public static class EntityTracker
    implements Supplier<Optional<class_2338>> {
        private final Supplier<EntityPlayerMPFake> supplier;
        @NotNull
        private class_1297 entity;
        @NotNull
        private class_2338 target;
        private final UUID entityUuid;
        private boolean isEntityDestroy;
        private long lastUpdateTime;

        private EntityTracker(Supplier<EntityPlayerMPFake> supplier, class_1937 world, class_1297 entity) {
            this.supplier = supplier;
            this.entity = entity;
            this.entityUuid = entity.method_5667();
            this.target = entity.method_24515();
            this.lastUpdateTime = world.method_8510();
        }

        @Override
        public Optional<class_2338> get() {
            EntityPlayerMPFake fakePlayer = this.supplier.get();
            if (this.isEntityDestroy) {
                return Optional.empty();
            }
            long time = this.getWorld().method_8510();
            if (time - this.lastUpdateTime < 60L) {
                return Optional.of(this.target);
            }
            this.lastUpdateTime = time;
            this.target = this.entity.method_24515();
            MinecraftServer server = FetcherUtils.getServer((class_3222)fakePlayer);
            if (this.entity.method_31481()) {
                class_1297 class_12972 = this.entity;
                Objects.requireNonNull(class_12972);
                class_1297 class_12973 = class_12972;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3222.class, class_1309.class}, (Object)class_12973, n)) {
                    case 0: {
                        class_3222 player = (class_3222)class_12973;
                        class_3222 entity = server.method_3760().method_14602(player.method_5667());
                        if (entity == null) {
                            this.isEntityDestroy = true;
                            return Optional.empty();
                        }
                        this.entity = entity;
                        break;
                    }
                    case 1: {
                        class_1309 livingEntity = (class_1309)class_12973;
                        if (livingEntity.method_29504()) {
                            this.isEntityDestroy = true;
                            return Optional.empty();
                        }
                        class_1297.class_5529 reason = livingEntity.method_35049();
                        if (reason == null) break;
                        if (reason.method_31486()) {
                            this.isEntityDestroy = true;
                            return Optional.empty();
                        }
                        Optional<class_1297> optional = GenericUtils.getEntity(server, this.entityUuid);
                        optional.ifPresent(value -> {
                            this.entity = value;
                        });
                        break;
                    }
                    default: {
                        this.isEntityDestroy = true;
                        return Optional.empty();
                    }
                }
            }
            if (FetcherUtils.getWorld((class_3222)fakePlayer) == this.getWorld()) {
                return Optional.of(this.target);
            }
            return Optional.empty();
        }

        private void update() {
            this.target = this.entity.method_24515();
        }

        private class_1937 getWorld() {
            return FetcherUtils.getWorld(this.entity);
        }
    }
}

