/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.predicate;

import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.wheel.TextBuilder;

public class EnchantedBookPredicate
implements Predicate<class_1799> {
    private final MinecraftServer server;
    private final class_1887 enchantment;
    private final String id;

    public EnchantedBookPredicate(MinecraftServer server, class_1887 enchantment) {
        this.server = server;
        this.enchantment = enchantment;
        this.id = GenericUtils.getId(server, this.enchantment).map(class_2960::toString).orElse("<unregistered>");
    }

    @Override
    public boolean test(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8598) && this.getLevel(itemStack) > 0;
    }

    public int getLevel(class_1799 itemStack) {
        int level = EnchantmentUtils.getLevel(this.server, this.enchantment, itemStack);
        if (level > 0) {
            return level;
        }
        return -1;
    }

    public class_2561 getWithLevel(int level) {
        TextBuilder builder = new TextBuilder(EnchantmentUtils.getName(this.enchantment, level));
        builder.setStringHover(this.id);
        return builder.build();
    }

    public class_2561 getDisplayName() {
        TextBuilder builder = new TextBuilder(EnchantmentUtils.getName(this.enchantment));
        builder.setStringHover(this.id);
        return builder.build();
    }
}

