/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.api.settings.SettingsManager;
import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_4081;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.CommandRegister;
import org.carpetorgaddition.command.PlayerManagerCommand;
import org.carpetorgaddition.config.CustomCommandConfig;
import org.carpetorgaddition.logger.LoggerRegister;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.express.ExpressManager;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSerializer;
import org.carpetorgaddition.util.GenericFetcherUtils;
import org.carpetorgaddition.util.permission.PermissionManager;
import org.carpetorgaddition.util.wheel.Translation;
import org.carpetorgaddition.util.wheel.UuidNameMappingTable;
import org.jetbrains.annotations.Nullable;

public class CarpetOrgAdditionExtension
implements CarpetExtension {
    private static SettingsManager customSettingManager;

    public void onGameStarted() {
        SettingsManager settingManager = CarpetOrgAdditionExtension.getCustomSettingManager();
        if (settingManager == null) {
            CarpetServer.settingsManager.parseSettingsClass(CarpetOrgAdditionSettings.class);
        } else {
            settingManager.parseSettingsClass(CarpetOrgAdditionSettings.class);
        }
        UuidNameMappingTable mappingTable = UuidNameMappingTable.getInstance();
        mappingTable.init();
    }

    @Nullable
    public static SettingsManager getCustomSettingManager() {
        return customSettingManager;
    }

    public void onPlayerLoggedIn(class_3222 player) {
        CarpetOrgAdditionExtension.clearKnockback(player);
        ExpressManager expressManager = ServerComponentCoordinator.getManager(player.field_13995).getExpressManager();
        expressManager.promptToReceive(player);
        PlayerManagerCommand.loadSafeAfk(player);
        UuidNameMappingTable.getInstance().put(player.method_7334());
    }

    private static void clearKnockback(class_3222 player) {
        if (CarpetOrgAdditionSettings.fakePlayerSpawnNoKnockback && player instanceof EntityPlayerMPFake) {
            player.method_18799(class_243.field_1353);
            player.method_20803(0);
            player.field_6017 = 0.0;
            player.method_6026().removeIf(effect -> ((class_1291)effect.method_5579().comp_349()).method_18792() == class_4081.field_18272);
        }
    }

    public void onServerLoadedWorlds(MinecraftServer server) {
        FakePlayerSerializer.autoLogin(server);
        PermissionManager.load(server);
        GenericFetcherUtils.getRuleSelfManager(server).load();
        CustomCommandConfig.getInstance().refreshIfExpired();
    }

    public void onServerClosed(MinecraftServer server) {
        UuidNameMappingTable.getInstance().save();
        PermissionManager.reset();
        CustomCommandConfig.getInstance().refreshIfExpired();
    }

    public SettingsManager extensionSettingsManager() {
        return super.extensionSettingsManager();
    }

    public Map<String, String> canHasTranslations(String lang) {
        return Translation.getInstance().getTranslation();
    }

    public void registerLoggers() {
        LoggerRegister.register();
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        CommandRegister.register(dispatcher, access);
    }
}

