/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2172;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.carpetorgaddition.client.util.ClientCommandUtils;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.util.TextUtils;

public abstract class ClientObjectArgumentType<T>
implements ArgumentType<List<T>> {
    private ClientObjectArgumentType() {
    }

    public static List<?> getType(CommandContext<FabricClientCommandSource> context, String name) {
        return (List)context.getArgument(name, List.class);
    }

    public List<T> parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String itemName = ClientCommandUtils.readWord(reader);
        ArrayList<T> list = new ArrayList<T>();
        for (T t : this.getRegistry().toList()) {
            if (!Objects.equals(itemName, this.objectToString(t))) continue;
            list.add(t);
        }
        if (list.isEmpty()) {
            reader.setCursor(cursor);
            throw CommandUtils.createException("carpet.client.commands.dictionary.not_matched", new Object[0]);
        }
        return list;
    }

    protected abstract String objectToString(T var1);

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2172) {
            String[] array = (String[])this.getRegistry().map(this::objectToString).map(s -> s.contains(" ") ? "\"" + s + "\"" : s).toArray(String[]::new);
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            for (String candidate : array) {
                if (!candidate.toLowerCase(Locale.ROOT).contains(remaining)) continue;
                builder.suggest(candidate);
            }
            return builder.buildFuture();
        }
        return Suggestions.empty();
    }

    protected abstract Stream<T> getRegistry();

    public static class ClientBiomeArgumentType
    extends ClientObjectArgumentType<class_1959> {
        @Override
        protected String objectToString(class_1959 biome) {
            assert (class_310.method_1551().field_1724 != null);
            class_2378 biomes = class_310.method_1551().field_1724.field_3944.method_29091().method_30530(class_7924.field_41236);
            return TextUtils.translate(Objects.requireNonNull(biomes.method_10221((Object)biome)).method_42093("biome"), new Object[0]).getString();
        }

        @Override
        protected Stream<class_1959> getRegistry() {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return Stream.empty();
            }
            return player.field_3944.method_29091().method_30530(class_7924.field_41236).method_10220();
        }
    }

    public static class ClientStatusEffectArgumentType
    extends ClientObjectArgumentType<class_1291> {
        @Override
        protected String objectToString(class_1291 statusEffect) {
            return statusEffect.method_5560().getString();
        }

        @Override
        protected Stream<class_1291> getRegistry() {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                return player.field_3944.method_29091().method_30530(class_7924.field_41208).method_10220();
            }
            return Stream.empty();
        }
    }

    public static class ClientEnchantmentArgumentType
    extends ClientObjectArgumentType<class_1887> {
        @Override
        protected String objectToString(class_1887 enchantment) {
            return EnchantmentUtils.getName(enchantment).getString();
        }

        @Override
        protected Stream<class_1887> getRegistry() {
            if (class_310.method_1551().field_1724 != null) {
                class_2378 registry = class_310.method_1551().field_1724.field_3944.method_29091().method_30530(class_7924.field_41265);
                return registry.method_10220();
            }
            return Stream.empty();
        }
    }

    public static class ClientEntityArgumentType
    extends ClientObjectArgumentType<class_1299<?>> {
        @Override
        protected String objectToString(class_1299<?> entityType) {
            return entityType.method_5897().getString();
        }

        @Override
        protected Stream<class_1299<?>> getRegistry() {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                return player.field_3944.method_29091().method_30530(class_7924.field_41266).method_10220();
            }
            return Stream.empty();
        }
    }

    public static class ClientBlockArgumentType
    extends ClientObjectArgumentType<class_2248> {
        @Override
        protected String objectToString(class_2248 block) {
            return block.method_9518().getString();
        }

        @Override
        protected Stream<class_2248> getRegistry() {
            return class_7923.field_41175.method_10220();
        }
    }

    public static class ClientItemArgumentType
    extends ClientObjectArgumentType<class_1792> {
        @Override
        protected String objectToString(class_1792 item) {
            return item.method_63680().getString();
        }

        @Override
        protected Stream<class_1792> getRegistry() {
            return class_7923.field_41178.method_10220();
        }
    }
}

