/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.carpetorgaddition.client.renderer.Color;
import org.carpetorgaddition.client.util.ClientRenderUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class BoxRenderer {
    private final class_289 tessellator = class_289.method_1348();
    @NotNull
    private class_238 box;
    @NotNull
    private Color faceColor = new Color(0.0f, 0.8f, 0.0f, 0.25f);
    @NotNull
    private Color lineColor = new Color(1.0f, 1.0f, 1.0f, 0.3f);
    private boolean seeThroughFace = false;
    private boolean seeThroughLine = true;

    public BoxRenderer(@NotNull class_238 box) {
        this.box = box;
    }

    public void render(class_4587 matrixStack) {
        float minX = (float)this.box.field_1323;
        float minY = (float)this.box.field_1322;
        float minZ = (float)this.box.field_1321;
        float maxX = (float)this.box.field_1320;
        float maxY = (float)this.box.field_1325;
        float maxZ = (float)this.box.field_1324;
        matrixStack.method_22903();
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        class_287 bufferBuilder = this.tessellator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        this.drawFillBox(bufferBuilder, matrix4f, minX, minY, minZ, maxX, maxY, maxZ);
        ClientRenderUtils.draw(class_1921.method_61045(), bufferBuilder.method_60800());
        class_287 builder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27377, class_290.field_29337);
        this.drawLineBox(builder, entry, minX, minY, minZ, maxX, maxY, maxZ);
        RenderSystem.lineWidth((float)2.0f);
        class_1921 renderLayer = this.seeThroughLine ? ClientRenderUtils.SEE_THROUGH_LINE : class_1921.method_23594();
        ClientRenderUtils.draw(renderLayer, builder.method_60800());
        matrixStack.method_22909();
    }

    private void drawFillBox(class_287 bufferBuilder, Matrix4f matrix4f, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        float[][] fillBoxVertex;
        for (float[] arr : fillBoxVertex = this.getFillBoxVertex(minX, minY, minZ, maxX, maxY, maxZ)) {
            bufferBuilder.method_22918(matrix4f, arr[0], arr[1], arr[2]).method_22915(this.faceColor.red(), this.faceColor.green(), this.faceColor.blue(), this.faceColor.alpha());
        }
    }

    private void drawLineBox(class_287 bufferBuilder, class_4587.class_4665 entry, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        float[][] lineBoxVertex;
        for (float[] arr : lineBoxVertex = this.getLineBoxVertex(minX, minY, minZ, maxX, maxY, maxZ)) {
            bufferBuilder.method_56824(entry, arr[0], arr[1], arr[2]).method_22915(this.lineColor.red(), this.lineColor.green(), this.lineColor.blue(), this.lineColor.alpha()).method_60831(entry, arr[3], arr[4], arr[5]);
        }
    }

    private float[][] getFillBoxVertex(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new float[][]{{minX, minY, minZ}, {maxX, minY, minZ}, {maxX, maxY, minZ}, {minX, maxY, minZ}, {minX, minY, maxZ}, {minX, maxY, maxZ}, {maxX, maxY, maxZ}, {maxX, minY, maxZ}, {minX, minY, minZ}, {minX, maxY, minZ}, {minX, maxY, maxZ}, {minX, minY, maxZ}, {maxX, minY, minZ}, {maxX, minY, maxZ}, {maxX, maxY, maxZ}, {maxX, maxY, minZ}, {minX, minY, minZ}, {maxX, minY, minZ}, {maxX, minY, maxZ}, {minX, minY, maxZ}, {minX, maxY, minZ}, {maxX, maxY, minZ}, {maxX, maxY, maxZ}, {minX, maxY, maxZ}};
    }

    private float[][] getLineBoxVertex(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new float[][]{{minX, minY, minZ, 1.0f, 0.0f, 0.0f}, {maxX, minY, minZ, 1.0f, 0.0f, 0.0f}, {minX, minY, minZ, 0.0f, 1.0f, 0.0f}, {minX, maxY, minZ, 0.0f, 1.0f, 0.0f}, {minX, minY, minZ, 0.0f, 0.0f, 1.0f}, {minX, minY, maxZ, 0.0f, 0.0f, 1.0f}, {maxX, minY, minZ, 0.0f, 1.0f, 0.0f}, {maxX, maxY, minZ, 0.0f, 1.0f, 0.0f}, {maxX, maxY, minZ, -1.0f, 0.0f, 0.0f}, {minX, maxY, minZ, -1.0f, 0.0f, 0.0f}, {minX, maxY, minZ, 0.0f, 0.0f, 1.0f}, {minX, maxY, maxZ, 0.0f, 0.0f, 1.0f}, {minX, maxY, maxZ, 0.0f, -1.0f, 0.0f}, {minX, minY, maxZ, 0.0f, -1.0f, 0.0f}, {minX, minY, maxZ, 1.0f, 0.0f, 0.0f}, {maxX, minY, maxZ, 1.0f, 0.0f, 0.0f}, {maxX, minY, maxZ, 0.0f, 0.0f, -1.0f}, {maxX, minY, minZ, 0.0f, 0.0f, -1.0f}, {minX, maxY, maxZ, 1.0f, 0.0f, 0.0f}, {maxX, maxY, maxZ, 1.0f, 0.0f, 0.0f}, {maxX, minY, maxZ, 0.0f, 1.0f, 0.0f}, {maxX, maxY, maxZ, 0.0f, 1.0f, 0.0f}, {maxX, maxY, minZ, 0.0f, 0.0f, 1.0f}, {maxX, maxY, maxZ, 0.0f, 0.0f, 1.0f}};
    }

    @NotNull
    public class_238 getBox() {
        return this.box;
    }

    public void setBox(@NotNull class_238 box) {
        this.box = box;
    }

    public void setFaceColor(float red, float green, float blue, float alpha) {
        this.faceColor = new Color(red, green, blue, alpha);
    }

    public void setLineColor(float red, float green, float blue, float alpha) {
        this.lineColor = new Color(red, green, blue, alpha);
    }

    public void setSeeThroughFace(boolean seeThroughFace) {
        this.seeThroughFace = seeThroughFace;
    }

    public void setSeeThroughLine(boolean seeThroughLine) {
        this.seeThroughLine = seeThroughLine;
    }
}

