/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import org.carpetorgaddition.client.renderer.WorldRenderer;
import org.jetbrains.annotations.Nullable;

public class WorldRendererManager {
    private static final HashMap<Class<? extends WorldRenderer>, Set<WorldRenderer>> renders = new HashMap();

    public static void addOrUpdate(WorldRenderer render) {
        Set set = renders.computeIfAbsent(render.getClass(), k -> new HashSet());
        set.remove(render);
        set.add(render);
    }

    public static <T extends WorldRenderer> List<T> getRenderer(Class<T> clazz) {
        Set<WorldRenderer> set = renders.get(clazz);
        if (set == null) {
            return List.of();
        }
        return set.stream().filter(clazz::isInstance).map(clazz::cast).toList();
    }

    public static <T extends WorldRenderer> List<T> getRenderer(Class<T> clazz, Function<T, Boolean> function) {
        return WorldRendererManager.getRenderer(clazz).stream().filter(function::apply).toList();
    }

    @Nullable
    public static <T extends WorldRenderer> T getOnlyRenderer(Class<T> clazz, Function<T, Boolean> function) {
        List<T> list = WorldRendererManager.getRenderer(clazz, function);
        if (list.size() > 1) {
            throw new IllegalStateException();
        }
        return (T)(list.isEmpty() ? null : (WorldRenderer)list.getFirst());
    }

    public static <T extends WorldRenderer> T getOrCreate(Class<T> clazz, Function<T, Boolean> function, Supplier<T> supplier) {
        T onlyRenderer = WorldRendererManager.getOnlyRenderer(clazz, function);
        if (onlyRenderer == null) {
            WorldRenderer renderer = (WorldRenderer)supplier.get();
            WorldRendererManager.addOrUpdate(renderer);
            return (T)renderer;
        }
        return onlyRenderer;
    }

    public static <T extends WorldRenderer> void remove(Class<T> clazz) {
        renders.remove(clazz);
    }

    public static <T extends WorldRenderer> void remove(Class<T> clazz, Function<T, Boolean> function) {
        Set<WorldRenderer> set = renders.get(clazz);
        if (set == null) {
            return;
        }
        set.removeIf(renderer -> clazz.isInstance(renderer) ? (Boolean)function.apply((WorldRenderer)clazz.cast(renderer)) : false);
    }

    static {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> renders.clear());
        WorldRenderEvents.START.register(context -> renders.forEach((clazz, renderers) -> renderers.removeIf(WorldRenderer::shouldStop)));
    }
}

