/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer.villagerpoi;

import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import org.carpetorgaddition.client.renderer.BlockOutlineRender;
import org.carpetorgaddition.client.renderer.BoxRenderer;
import org.carpetorgaddition.client.renderer.Color;
import org.carpetorgaddition.client.renderer.LineRenderer;
import org.carpetorgaddition.client.renderer.WorldRenderer;

public class VillagerPoiRenderer
implements WorldRenderer {
    private final class_1646 villagerEntity;
    private final class_4208 bedPos;
    private final class_4208 jobSitePos;
    private final class_4208 potentialJobSite;

    public VillagerPoiRenderer(class_1646 villagerEntity, class_4208 bedPos, class_4208 jobSitePos, class_4208 potentialJobSite) {
        this.villagerEntity = villagerEntity;
        this.bedPos = bedPos;
        this.jobSitePos = jobSitePos;
        this.potentialJobSite = potentialJobSite;
    }

    @Override
    public void render(WorldRenderContext context) {
        class_4587 matrixStack = context.matrixStack();
        if (matrixStack == null) {
            return;
        }
        if (class_310.method_1551().field_1773.method_19418().method_19326().method_1022(this.villagerEntity.method_19538()) > 96.0) {
            return;
        }
        float tickDelta = context.tickCounter().method_60637(true);
        class_243 leashPos = this.villagerEntity.method_30950(tickDelta).method_1019(new class_243(0.0, (double)this.villagerEntity.method_17682() * 0.6, 0.0));
        class_4604 frustum = context.frustum();
        if (frustum == null) {
            return;
        }
        if (this.bedPos != null) {
            new LineRenderer(leashPos, this.bedPos.comp_2208().method_46558()).render(matrixStack);
            if (this.canRender(this.bedPos, frustum)) {
                BoxRenderer renderer = this.createBedRenderer();
                renderer.setSeeThroughLine(false);
                renderer.setFaceColor(1.0f, 0.9f, 0.2f, 0.4f);
                renderer.render(matrixStack);
            }
        }
        if (this.jobSitePos != null) {
            lineRenderer = new LineRenderer(leashPos, this.jobSitePos.comp_2208().method_46558());
            lineRenderer.setColor(new Color(0.1f, 0.75f, 0.4f, 1.0f));
            lineRenderer.render(matrixStack);
            if (this.canRender(this.jobSitePos, frustum)) {
                this.getBlockOutlineRender(this.jobSitePos.comp_2208()).render(matrixStack);
            }
        } else if (this.potentialJobSite != null) {
            lineRenderer = new LineRenderer(leashPos, this.potentialJobSite.comp_2208().method_46558());
            lineRenderer.setColor(new Color(0.8f, 0.4f, 0.9f, 1.0f));
            lineRenderer.render(matrixStack);
            if (this.canRender(this.potentialJobSite, frustum)) {
                this.getBlockOutlineRender(this.potentialJobSite.comp_2208()).render(matrixStack);
            }
        }
    }

    private boolean canRender(class_4208 globalPos, class_4604 frustum) {
        return frustum.method_23093(new class_238(globalPos.comp_2208()));
    }

    private BoxRenderer createBedRenderer() {
        class_2338 bedPos;
        class_1937 world = this.villagerEntity.method_37908();
        class_2680 blockState = world.method_8320(bedPos = this.bedPos.comp_2208());
        if (blockState.method_26204() instanceof class_2244 && blockState.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560) {
            class_2350 direction = ((class_2350)blockState.method_11654((class_2769)class_2383.field_11177)).method_10153();
            class_2338 offset = bedPos.method_10093(direction);
            class_2680 bedTailBlockState = world.method_8320(offset);
            class_238 box = bedTailBlockState.method_26204() instanceof class_2244 && bedTailBlockState.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12557 ? new class_238((double)Math.min(bedPos.method_10263(), offset.method_10263()) + 0.0, (double)Math.min(bedPos.method_10264(), offset.method_10264()) + 0.18, (double)Math.min(bedPos.method_10260(), offset.method_10260()) + 0.0, (double)Math.max(bedPos.method_10263(), offset.method_10263()) + 1.0, (double)Math.max(bedPos.method_10264(), offset.method_10264()) + 0.625, (double)Math.max(bedPos.method_10260(), offset.method_10260()) + 1.0) : new class_238((double)bedPos.method_10263() + 0.0, (double)bedPos.method_10264() + 0.18, (double)bedPos.method_10260() + 0.0, (double)bedPos.method_10263() + 1.0, (double)bedPos.method_10264() + 0.625, (double)bedPos.method_10260() + 1.0);
            return new BoxRenderer(box.method_1014(0.001));
        }
        return new BoxRenderer(new class_238(bedPos).method_1014(-0.001));
    }

    private BlockOutlineRender getBlockOutlineRender(class_2338 blockPos) {
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26215()) {
            return new BlockOutlineRender(blockPos, class_259.method_1077());
        }
        return new BlockOutlineRender(blockPos);
    }

    @Override
    public boolean shouldStop() {
        return this.villagerEntity.method_31481();
    }

    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            return this.villagerEntity.equals((Object)((VillagerPoiRenderer)obj).villagerEntity);
        }
        return false;
    }

    public int hashCode() {
        return this.villagerEntity.hashCode();
    }
}

